/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.Validate;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class MetadataStoreBase<T> {
    private Map<String, Map<Plugin, MetadataValue>> metadataMap = new ConcurrentHashMap<String, Map<Plugin, MetadataValue>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMetadata(@NotNull T subject, @NotNull String metadataKey, @NotNull MetadataValue newMetadataValue) {
        Validate.notNull((Object)newMetadataValue, (String)"Value cannot be null");
        Plugin owningPlugin = newMetadataValue.getOwningPlugin();
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        String key = this.disambiguate(subject, metadataKey);
        Map<Plugin, MetadataValue> entry = this.metadataMap.get(key);
        if (entry == null) {
            entry = new WeakHashMap<Plugin, MetadataValue>(1);
            this.metadataMap.put(key, entry);
        }
        Map<Plugin, MetadataValue> map = entry;
        synchronized (map) {
            entry.put(owningPlugin, newMetadataValue);
        }
    }

    @NotNull
    public List<MetadataValue> getMetadata(@NotNull T subject, @NotNull String metadataKey) {
        String key = this.disambiguate(subject, metadataKey);
        Map<Plugin, MetadataValue> entry = this.metadataMap.get(key);
        if (entry != null) {
            Collection<MetadataValue> values = entry.values();
            return Collections.unmodifiableList(new ArrayList<MetadataValue>(values));
        }
        return Collections.emptyList();
    }

    public boolean hasMetadata(@NotNull T subject, @NotNull String metadataKey) {
        String key = this.disambiguate(subject, metadataKey);
        return this.metadataMap.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMetadata(@NotNull T subject, @NotNull String metadataKey, @NotNull Plugin owningPlugin) {
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        String key = this.disambiguate(subject, metadataKey);
        Map<Plugin, MetadataValue> entry = this.metadataMap.get(key);
        if (entry == null) {
            return;
        }
        Map<Plugin, MetadataValue> map = entry;
        synchronized (map) {
            entry.remove(owningPlugin);
            if (entry.isEmpty()) {
                this.metadataMap.remove(key);
            }
        }
    }

    public void invalidateAll(@NotNull Plugin owningPlugin) {
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        for (Map<Plugin, MetadataValue> values : this.metadataMap.values()) {
            if (!values.containsKey(owningPlugin)) continue;
            values.get(owningPlugin).invalidate();
        }
    }

    public void removeAll(@NotNull Plugin owningPlugin) {
        Validate.notNull((Object)owningPlugin, (String)"Plugin cannot be null");
        Iterator<Map<Plugin, MetadataValue>> iterator = this.metadataMap.values().iterator();
        while (iterator.hasNext()) {
            Map<Plugin, MetadataValue> values = iterator.next();
            if (values.containsKey(owningPlugin)) {
                values.remove(owningPlugin);
            }
            if (!values.isEmpty()) continue;
            iterator.remove();
        }
    }

    @NotNull
    protected abstract String disambiguate(@NotNull T var1, @NotNull String var2);
}

