/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class TimingsCommand
extends BukkitCommand {
    private static final List<String> TIMINGS_SUBCOMMANDS = ImmutableList.of((Object)"report", (Object)"reset", (Object)"on", (Object)"off", (Object)"paste", (Object)"verbon", (Object)"verboff");
    private long lastResetAttempt = 0L;

    public TimingsCommand(@NotNull String name) {
        super(name);
        this.description = "Manages Spigot Timings data to see performance of the server.";
        this.usageMessage = "/timings <reset|report|on|off|verbon|verboff>";
        this.setPermission("bukkit.command.timings");
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage((Component)Component.text((String)("Usage: " + this.usageMessage), (TextColor)NamedTextColor.RED));
            return true;
        }
        String arg = args[0];
        if ("on".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(true);
            sender.sendMessage((Component)Component.text((String)"Enabled Timings & Reset"));
            return true;
        }
        if ("off".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(false);
            sender.sendMessage((Component)Component.text((String)"Disabled Timings"));
            return true;
        }
        if (!Timings.isTimingsEnabled()) {
            sender.sendMessage((Component)Component.text((String)"Please enable timings by typing /timings on"));
            return true;
        }
        long now = System.currentTimeMillis();
        if ("verbon".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(true);
            sender.sendMessage((Component)Component.text((String)"Enabled Verbose Timings"));
            return true;
        }
        if ("verboff".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(false);
            sender.sendMessage((Component)Component.text((String)"Disabled Verbose Timings"));
            return true;
        }
        if ("reset".equalsIgnoreCase(arg)) {
            if (now - this.lastResetAttempt < 30000L) {
                TimingsManager.reset();
                sender.sendMessage((Component)Component.text((String)"Timings reset. Please wait 5-10 minutes before using /timings report.", (TextColor)NamedTextColor.RED));
            } else {
                this.lastResetAttempt = now;
                sender.sendMessage((Component)Component.text((String)"WARNING: Timings v2 should not be reset. If you are experiencing lag, please wait 3 minutes and then issue a report. The best timings will include 10+ minutes, with data before and after your lag period. If you really want to reset, run this command again within 30 seconds.", (TextColor)NamedTextColor.RED));
            }
        } else if ("paste".equalsIgnoreCase(arg) || "report".equalsIgnoreCase(arg) || "get".equalsIgnoreCase(arg) || "merged".equalsIgnoreCase(arg) || "separate".equalsIgnoreCase(arg)) {
            Timings.generateReport(sender);
        } else {
            sender.sendMessage((Component)Component.text((String)("Usage: " + this.usageMessage), (TextColor)NamedTextColor.RED));
        }
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        Preconditions.checkNotNull((Object)sender, (Object)"Sender cannot be null");
        Preconditions.checkNotNull((Object)args, (Object)"Arguments cannot be null");
        Preconditions.checkNotNull((Object)alias, (Object)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], TIMINGS_SUBCOMMANDS, new ArrayList(TIMINGS_SUBCOMMANDS.size()));
        }
        return ImmutableList.of();
    }
}

