/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;

public class TimingsCommand
extends BukkitCommand {
    private static final List<String> TIMINGS_SUBCOMMANDS = ImmutableList.of((Object)"report", (Object)"reset", (Object)"on", (Object)"off", (Object)"paste", (Object)"verbon", (Object)"verboff");
    private long lastResetAttempt = 0L;

    public TimingsCommand(@NotNull String name) {
        super(name);
        this.description = "Manages Spigot Timings data to see performance of the server.";
        this.usageMessage = "/timings";
        this.setPermission("bukkit.command.timings");
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        MiniMessage mm = MiniMessage.miniMessage();
        sender.sendMessage(mm.deserialize((Object)"<gold>Purpur has removed timings to save your performance. Please use <click:suggest_command:'/spark'><grey>/spark</grey></click> instead"));
        sender.sendMessage(mm.deserialize((Object)"<gold>For more information, view its documentation at"));
        sender.sendMessage(mm.deserialize((Object)"<gold><click:open_url:'https://spark.lucko.me/docs/Command-Usage'>https://spark.lucko.me/docs/Command-Usage</click>"));
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        Preconditions.checkNotNull((Object)sender, (Object)"Sender cannot be null");
        Preconditions.checkNotNull((Object)args, (Object)"Arguments cannot be null");
        Preconditions.checkNotNull((Object)alias, (Object)"Alias cannot be null");
        return ImmutableList.of();
    }
}

