package org.bukkit.entity.minecart;

import org.bukkit.entity.Minecart;

/**
 * Represents a Minecart with TNT inside it that can explode when triggered.
 */
public interface ExplosiveMinecart extends Minecart {
    // Paper start - Entity API
    /**
     * Set the number of ticks until the Minecart explodes after being primed.
     *
     * @param fuseTicks fuse ticks or -1 if the fuse isn't primed
     */
    void setFuseTicks(int fuseTicks);

    /**
     * Retrieve the number of ticks until the explosive Minecart explodes.
     *
     * @return number of ticks or -1 if the fuse isn't primed
     */
    int getFuseTicks();

    /**
     * Checks whether this explosive Minecart is ignited (its fuse is primed).
     *
     * @return whether the Minecart is ignited
     */
    boolean isIgnited();

    /**
     * Ignites this explosive Minecart, beginning its fuse.
     */
    void ignite();

    /**
     * Immediately explodes the Minecart.
     * Power will depend on the Minecart's horizontal speed.
     */
    void explode();

    /**
     * Immediately explodes the Minecart with the specified power.
     *
     * @param power explosion power
     */
    void explode(double power);
    // Paper end - Entity API
}
