package org.purpurmc.purpur.event.entity;

import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Called when a bee targets a flower
 */
public class BeeFoundFlowerEvent extends EntityEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Location location;

    public BeeFoundFlowerEvent(@NotNull Bee bee, @Nullable Location location) {
        super(bee);
        this.location = location;
    }

    @Override
    @NotNull
    public Bee getEntity() {
        return (Bee) super.getEntity();
    }

    /**
     * Returns the location of the flower that the bee targets
     *
     * @return The location of the flower
     */
    @Nullable
    public Location getLocation() {
        return location;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}
