package org.purpurmc.purpur.event.entity;

import org.bukkit.entity.Goat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;

/**
 * Called when a goat rams an entity
 */
public class GoatRamEntityEvent extends EntityEvent implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private final LivingEntity rammedEntity;
    private boolean cancelled;

    public GoatRamEntityEvent(@NotNull Goat goat, @NotNull LivingEntity rammedEntity) {
        super(goat);
        this.rammedEntity = rammedEntity;
    }

    /**
     * Returns the entity that was rammed by the goat
     *
     * @return The rammed entity
     */
    @NotNull
    public LivingEntity getRammedEntity() {
        return this.rammedEntity;
    }

    @Override
    @NotNull
    public Goat getEntity() {
        return (Goat) super.getEntity();
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}
