/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import io.papermc.paper.entity.TeleportFlag;
import java.util.Collections;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerMoveEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerTeleportEvent
extends PlayerMoveEvent {
    private static final HandlerList handlers = new HandlerList();
    private TeleportCause cause = TeleportCause.UNKNOWN;
    private boolean dismounted = true;
    private final Set<TeleportFlag.Relative> teleportFlagSet;

    public PlayerTeleportEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to) {
        super(player, from, to);
        this.teleportFlagSet = Collections.emptySet();
    }

    public PlayerTeleportEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to, @NotNull TeleportCause cause) {
        this(player, from, to);
        this.cause = cause;
    }

    @ApiStatus.Experimental
    public PlayerTeleportEvent(@NotNull Player player, @NotNull Location from, @Nullable Location to, @NotNull TeleportCause cause, @NotNull @NotNull Set< @NotNull TeleportFlag.Relative> teleportFlagSet) {
        super(player, from, to);
        this.teleportFlagSet = teleportFlagSet;
        this.cause = cause;
    }

    @NotNull
    public TeleportCause getCause() {
        return this.cause;
    }

    @Deprecated(forRemoval=true)
    public boolean willDismountPlayer() {
        return this.dismounted;
    }

    @ApiStatus.Experimental
    @NotNull
    public @NotNull Set< @NotNull TeleportFlag.Relative> getRelativeTeleportationFlags() {
        return this.teleportFlagSet;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum TeleportCause {
        ENDER_PEARL,
        COMMAND,
        PLUGIN,
        NETHER_PORTAL,
        END_PORTAL,
        SPECTATE,
        END_GATEWAY,
        CHORUS_FRUIT,
        DISMOUNT,
        UNKNOWN;

    }
}

