/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin;

import co.aikar.timings.Timings;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerEventException;
import com.destroystokyo.paper.exception.ServerPluginEnableDisableException;
import com.google.common.base.Preconditions;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import gg.pufferfish.pufferfish.sentry.SentryContext;
import io.papermc.paper.plugin.PermissionManager;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.Server;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;
import org.bukkit.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
public final class SimplePluginManager
implements PluginManager {
    private final Server server;
    private final Map<Pattern, PluginLoader> fileAssociations = new HashMap<Pattern, PluginLoader>();
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private final Map<String, Plugin> lookupNames = new HashMap<String, Plugin>();
    private MutableGraph<String> dependencyGraph = GraphBuilder.directed().build();
    private File updateDirectory;
    private final SimpleCommandMap commandMap;
    public final Map<String, Permission> permissions = new HashMap<String, Permission>();
    public final Map<Boolean, Set<Permission>> defaultPerms = new LinkedHashMap<Boolean, Set<Permission>>();
    public final Map<String, Map<Permissible, Boolean>> permSubs = new HashMap<String, Map<Permissible, Boolean>>();
    public final Map<Boolean, Map<Permissible, Boolean>> defSubs = new HashMap<Boolean, Map<Permissible, Boolean>>();
    public PluginManager paperPluginManager;
    private boolean useTimings = false;

    public SimplePluginManager(@NotNull Server instance, @NotNull SimpleCommandMap commandMap) {
        this.server = instance;
        this.commandMap = commandMap;
        this.defaultPerms.put(true, new LinkedHashSet());
        this.defaultPerms.put(false, new LinkedHashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInterface(@NotNull Class<? extends PluginLoader> loader) throws IllegalArgumentException {
        PluginLoader instance;
        if (PluginLoader.class.isAssignableFrom(loader)) {
            try {
                Constructor<? extends PluginLoader> constructor = loader.getConstructor(Server.class);
                instance = constructor.newInstance(this.server);
            }
            catch (NoSuchMethodException ex) {
                String className = loader.getName();
                throw new IllegalArgumentException(String.format("Class %s does not have a public %s(Server) constructor", className, className), ex);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(String.format("Unexpected exception %s while attempting to construct a new instance of %s", ex.getClass().getName(), loader.getName()), ex);
            }
        } else {
            throw new IllegalArgumentException(String.format("Class %s does not implement interface PluginLoader", loader.getName()));
        }
        Pattern[] patterns = instance.getPluginFileFilters();
        SimplePluginManager simplePluginManager = this;
        synchronized (simplePluginManager) {
            for (Pattern pattern : patterns) {
                this.fileAssociations.put(pattern, instance);
            }
        }
    }

    @Override
    @NotNull
    public Plugin[] loadPlugins(@NotNull File directory) {
        return this.loadPlugins(directory, Collections.emptyList());
    }

    @NotNull
    public Plugin[] loadPlugins(@NotNull File directory, @NotNull List<File> extraPluginJars) {
        ArrayList<Plugin> pluginList = new ArrayList<Plugin>();
        Collections.addAll(pluginList, this.paperPluginManager.loadPlugins(directory));
        for (File file : extraPluginJars) {
            try {
                pluginList.add(this.paperPluginManager.loadPlugin(file));
            }
            catch (Exception e) {
                this.server.getLogger().log(Level.SEVERE, "Plugin loading error!", e);
            }
        }
        return pluginList.toArray(new Plugin[0]);
    }

    @Override
    @Nullable
    public synchronized Plugin loadPlugin(@NotNull File file) throws InvalidPluginException, UnknownDependencyException {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        try {
            return this.paperPluginManager.loadPlugin(file);
        }
        catch (InvalidDescriptionException ignored) {
            return null;
        }
    }

    private void checkUpdate(@NotNull File file) {
        if (this.updateDirectory == null || !this.updateDirectory.isDirectory()) {
            return;
        }
        File updateFile = new File(this.updateDirectory, file.getName());
        if (updateFile.isFile() && FileUtil.copy(updateFile, file)) {
            updateFile.delete();
        }
    }

    @Override
    @Nullable
    public synchronized Plugin getPlugin(@NotNull String name) {
        return this.paperPluginManager.getPlugin(name);
    }

    @Override
    @NotNull
    public synchronized Plugin[] getPlugins() {
        return this.paperPluginManager.getPlugins();
    }

    @Override
    public boolean isPluginEnabled(@NotNull String name) {
        return this.paperPluginManager.isPluginEnabled(name);
    }

    @Override
    public boolean isPluginEnabled(@Nullable Plugin plugin) {
        return this.paperPluginManager.isPluginEnabled(plugin);
    }

    @Override
    public void enablePlugin(@NotNull Plugin plugin) {
        this.paperPluginManager.enablePlugin(plugin);
    }

    @Override
    public void disablePlugins() {
        this.paperPluginManager.disablePlugins();
    }

    @Override
    public void disablePlugin(@NotNull Plugin plugin) {
        this.paperPluginManager.disablePlugin(plugin);
    }

    private void handlePluginException(String msg, Throwable ex, Plugin plugin) {
        SentryContext.setPluginContext(plugin);
        this.server.getLogger().log(Level.SEVERE, msg, ex);
        SentryContext.removePluginContext();
        this.callEvent(new ServerExceptionEvent(new ServerPluginEnableDisableException(msg, ex, plugin)));
    }

    @Override
    public void clearPlugins() {
        this.paperPluginManager.clearPlugins();
    }

    @Override
    public void callEvent(@NotNull Event event) {
        this.paperPluginManager.callEvent(event);
    }

    private void fireEvent(@NotNull Event event) {
        RegisteredListener[] listeners;
        HandlerList handlers = event.getHandlers();
        for (RegisteredListener registration : listeners = handlers.getRegisteredListeners()) {
            if (!registration.getPlugin().isEnabled()) continue;
            try {
                registration.callEvent(event);
            }
            catch (AuthorNagException ex) {
                Plugin plugin = registration.getPlugin();
                if (!plugin.isNaggable()) continue;
                plugin.setNaggable(false);
                this.server.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), ex.getMessage()));
            }
            catch (Throwable ex) {
                SentryContext.setEventContext(event, registration);
                String msg = "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getDescription().getFullName();
                this.server.getLogger().log(Level.SEVERE, msg, ex);
                SentryContext.removeEventContext();
                if (event instanceof ServerExceptionEvent) continue;
                this.callEvent(new ServerExceptionEvent(new ServerEventException(msg, ex, registration.getPlugin(), registration.getListener(), event)));
            }
        }
    }

    @Override
    public void registerEvents(@NotNull Listener listener, @NotNull Plugin plugin) {
        this.paperPluginManager.registerEvents(listener, plugin);
    }

    @Override
    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin) {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    @Override
    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin, boolean ignoreCancelled) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Listener cannot be null");
        Preconditions.checkArgument((priority != null ? 1 : 0) != 0, (Object)"Priority cannot be null");
        Preconditions.checkArgument((executor != null ? 1 : 0) != 0, (Object)"Executor cannot be null");
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        this.paperPluginManager.registerEvent(event, listener, priority, executor, plugin, ignoreCancelled);
    }

    @NotNull
    private HandlerList getEventListeners(@NotNull Class<? extends Event> type) {
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalAccessException("getHandlerList must be static");
            }
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalPluginAccessException("Error while registering listener for event type " + type.toString() + ": " + e.toString());
        }
    }

    @NotNull
    private Class<? extends Event> getRegistrationClass(@NotNull Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    @Override
    @Nullable
    public Permission getPermission(@NotNull String name) {
        return this.paperPluginManager.getPermission(name);
    }

    @Override
    public void addPermission(@NotNull Permission perm) {
        this.paperPluginManager.addPermission(perm);
    }

    @Deprecated
    public void addPermission(@NotNull Permission perm, boolean dirty) {
        this.paperPluginManager.addPermission(perm);
    }

    @Override
    @NotNull
    public Set<Permission> getDefaultPermissions(boolean op) {
        return this.paperPluginManager.getDefaultPermissions(op);
    }

    @Override
    public void removePermission(@NotNull Permission perm) {
        this.paperPluginManager.removePermission(perm);
    }

    @Override
    public void removePermission(@NotNull String name) {
        this.paperPluginManager.removePermission(name);
    }

    @Override
    public void recalculatePermissionDefaults(@NotNull Permission perm) {
        this.paperPluginManager.recalculatePermissionDefaults(perm);
    }

    private void calculatePermissionDefault(@NotNull Permission perm, boolean dirty) {
        if (perm.getDefault() == PermissionDefault.OP || perm.getDefault() == PermissionDefault.TRUE) {
            this.defaultPerms.get(true).add(perm);
            if (dirty) {
                this.dirtyPermissibles(true);
            }
        }
        if (perm.getDefault() == PermissionDefault.NOT_OP || perm.getDefault() == PermissionDefault.TRUE) {
            this.defaultPerms.get(false).add(perm);
            if (dirty) {
                this.dirtyPermissibles(false);
            }
        }
    }

    @Deprecated
    public void dirtyPermissibles() {
        this.dirtyPermissibles(true);
        this.dirtyPermissibles(false);
    }

    private void dirtyPermissibles(boolean op) {
        Set<Permissible> permissibles = this.getDefaultPermSubscriptions(op);
        for (Permissible p : permissibles) {
            p.recalculatePermissions();
        }
    }

    @Override
    public void subscribeToPermission(@NotNull String permission, @NotNull Permissible permissible) {
        this.paperPluginManager.subscribeToPermission(permission, permissible);
    }

    @Override
    public void unsubscribeFromPermission(@NotNull String permission, @NotNull Permissible permissible) {
        this.paperPluginManager.unsubscribeFromPermission(permission, permissible);
    }

    @Override
    @NotNull
    public Set<Permissible> getPermissionSubscriptions(@NotNull String permission) {
        return this.paperPluginManager.getPermissionSubscriptions(permission);
    }

    @Override
    public void subscribeToDefaultPerms(boolean op, @NotNull Permissible permissible) {
        this.paperPluginManager.subscribeToDefaultPerms(op, permissible);
    }

    @Override
    public void unsubscribeFromDefaultPerms(boolean op, @NotNull Permissible permissible) {
        this.paperPluginManager.unsubscribeFromDefaultPerms(op, permissible);
    }

    @Override
    @NotNull
    public Set<Permissible> getDefaultPermSubscriptions(boolean op) {
        return this.paperPluginManager.getDefaultPermSubscriptions(op);
    }

    @Override
    @NotNull
    public Set<Permission> getPermissions() {
        return this.paperPluginManager.getPermissions();
    }

    public boolean isTransitiveDepend(@NotNull PluginDescriptionFile plugin, @NotNull PluginDescriptionFile depend) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"plugin");
        Preconditions.checkArgument((depend != null ? 1 : 0) != 0, (Object)"depend");
        if (this.dependencyGraph.nodes().contains(plugin.getName())) {
            Set reachableNodes = Graphs.reachableNodes(this.dependencyGraph, (Object)plugin.getName());
            if (reachableNodes.contains(depend.getName())) {
                return true;
            }
            for (String provided : depend.getProvides()) {
                if (!reachableNodes.contains(provided)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean useTimings() {
        return this.paperPluginManager.useTimings();
    }

    public void useTimings(boolean use) {
        Timings.setTimingsEnabled(use);
    }

    @Override
    public void clearPermissions() {
        this.paperPluginManager.clearPermissions();
    }

    @Override
    public boolean isTransitiveDependency(PluginMeta pluginMeta, PluginMeta dependencyConfig) {
        return this.paperPluginManager.isTransitiveDependency(pluginMeta, dependencyConfig);
    }

    @Override
    public void overridePermissionManager(@NotNull Plugin plugin, @Nullable PermissionManager permissionManager) {
        this.paperPluginManager.overridePermissionManager(plugin, permissionManager);
    }

    @Override
    public void addPermissions(@NotNull List<Permission> perm) {
        this.paperPluginManager.addPermissions(perm);
    }
}

