package org.purpurmc.purpur.event.inventory;

import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

/**
 * Called when a player takes the result item out of a Grindstone
 */
public class GrindstoneTakeResultEvent extends InventoryEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Player player;
    private final ItemStack result;
    private int experienceAmount;

    public GrindstoneTakeResultEvent(@NotNull HumanEntity player, @NotNull InventoryView view, @NotNull ItemStack result, int experienceAmount) {
        super(view);
        this.player = (Player) player;
        this.result = result;
        this.experienceAmount = experienceAmount;
    }

    @NotNull
    public Player getPlayer() {
        return player;
    }

    @NotNull
    public ItemStack getResult() {
        return result;
    }

    @NotNull
    @Override
    public GrindstoneInventory getInventory() {
        return (GrindstoneInventory) super.getInventory();
    }

    /**
     * Get the amount of experience this transaction will give
     *
     * @return Amount of experience to give
     */
    public int getExperienceAmount() {
        return this.experienceAmount;
    }

    /**
     * Set the amount of experience this transaction will give
     *
     * @param experienceAmount Amount of experience to give
     */
    public void setExperienceAmount(int experienceAmount) {
        this.experienceAmount = experienceAmount;
    }

    @NotNull
    @Override
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}
