package org.purpurmc.purpur.event.packet;

import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Called when an item is about to be written to a packet.
 */
public class NetworkItemSerializeEvent extends Event {
    private ItemStack itemStack;

    public NetworkItemSerializeEvent(@NotNull ItemStack itemStack) {
        super(!org.bukkit.Bukkit.isPrimaryThread());
        this.itemStack = itemStack;
    }

    /**
     * @return The item that is about to be serialized. Not mutable
     */
    @NotNull
    public ItemStack getItemStack() {
        return itemStack;
    }

    /**
     * Sets the item that will be serialized.
     *
     * @param itemStack The item
     */
    public void setItemStack(@Nullable ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    private static final HandlerList handlers = new HandlerList();

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}
