/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.block;

import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilDamagedEvent
extends InventoryEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private boolean cancel;
    private DamageState damageState;

    @ApiStatus.Internal
    public AnvilDamagedEvent(@NotNull InventoryView inventory, @Nullable BlockData blockData) {
        super(inventory);
        this.damageState = DamageState.getState(blockData);
    }

    @Override
    @NotNull
    public AnvilInventory getInventory() {
        return (AnvilInventory)super.getInventory();
    }

    @NotNull
    public DamageState getDamageState() {
        return this.damageState;
    }

    public void setDamageState(@NotNull DamageState damageState) {
        this.damageState = damageState;
    }

    public boolean isBreaking() {
        return this.damageState == DamageState.BROKEN;
    }

    public void setBreaking(boolean breaking) {
        if (breaking) {
            this.damageState = DamageState.BROKEN;
        } else if (this.damageState == DamageState.BROKEN) {
            this.damageState = DamageState.DAMAGED;
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancel = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum DamageState {
        FULL(Material.ANVIL),
        CHIPPED(Material.CHIPPED_ANVIL),
        DAMAGED(Material.DAMAGED_ANVIL),
        BROKEN(Material.AIR);

        private final Material material;

        private DamageState(Material material) {
            this.material = material;
        }

        @NotNull
        public Material getMaterial() {
            return this.material;
        }

        @NotNull
        public static DamageState getState(@Nullable BlockData blockData) {
            return blockData == null ? BROKEN : DamageState.getState(blockData.getMaterial());
        }

        @NotNull
        public static DamageState getState(@Nullable Material material) {
            if (material == null) {
                return BROKEN;
            }
            for (DamageState state : DamageState.values()) {
                if (state.material != material) continue;
                return state;
            }
            throw new IllegalArgumentException("Material is not an anvil state");
        }
    }
}

