/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.regionized.bukkit;

import com.github.puregero.multilib.regionized.EntityScheduler;
import com.github.puregero.multilib.regionized.RegionizedTask;
import com.github.puregero.multilib.regionized.bukkit.BukkitRegionizedTaskWrapper;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitEntitySchedulerImpl
implements EntityScheduler {
    private final Entity entity;

    public BukkitEntitySchedulerImpl(Entity entity) {
        this.entity = entity;
    }

    private Entity getEntity() {
        return this.entity;
    }

    private void handle(RegionizedTask regionizedTask, Consumer<RegionizedTask> runnable, Runnable retired) {
        if (this.getEntity() == null || this.getEntity().isDead() || !this.getEntity().isValid()) {
            regionizedTask.cancel();
            if (retired != null) {
                retired.run();
            }
            return;
        }
        runnable.accept(regionizedTask);
    }

    public boolean execute(@NotNull Plugin plugin, @NotNull Runnable run, @Nullable Runnable retired, long delay) {
        new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, t -> run.run(), retired), delay).schedule();
        return true;
    }

    @Nullable
    public RegionizedTask run(@NotNull Plugin plugin, @NotNull Consumer<RegionizedTask> task, @Nullable Runnable retired) {
        return new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, task, retired)).schedule();
    }

    @Nullable
    public RegionizedTask runDelayed(@NotNull Plugin plugin, @NotNull Consumer<RegionizedTask> task, @Nullable Runnable retired, long delayTicks) {
        return new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, task, retired), delayTicks).schedule();
    }

    @Nullable
    public RegionizedTask runAtFixedRate(@NotNull Plugin plugin, @NotNull Consumer<RegionizedTask> task, @Nullable Runnable retired, long initialDelayTicks, long periodTicks) {
        return new BukkitRegionizedTaskWrapper(plugin, regionizedTask -> this.handle((RegionizedTask)regionizedTask, task, retired), initialDelayTicks, periodTicks).schedule();
    }
}

