/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.potion;

import io.papermc.paper.potion.PredicateRecipeChoice;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public class PotionMix
implements Keyed {
    private final NamespacedKey key;
    private final ItemStack result;
    private final RecipeChoice input;
    private final RecipeChoice ingredient;

    public PotionMix(@NotNull NamespacedKey key, @NotNull ItemStack result, @NotNull RecipeChoice input, @NotNull RecipeChoice ingredient) {
        this.key = key;
        this.result = result;
        this.input = input;
        this.ingredient = ingredient;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static RecipeChoice createPredicateChoice(@NotNull Predicate<? super ItemStack> stackPredicate) {
        return new PredicateRecipeChoice(stackPredicate);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public RecipeChoice getInput() {
        return this.input;
    }

    @NotNull
    public RecipeChoice getIngredient() {
        return this.ingredient;
    }

    public String toString() {
        return "PotionMix{result=" + String.valueOf(this.result) + ", base=" + String.valueOf(this.input) + ", addition=" + String.valueOf(this.ingredient) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PotionMix potionMix = (PotionMix)o;
        return this.key.equals(potionMix.key) && this.result.equals(potionMix.result) && this.input.equals(potionMix.input) && this.ingredient.equals(potionMix.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.result, this.input, this.ingredient);
    }
}

