(ns sluj.charmap)

;; This char map was acquired from: https://github.com/Trott/slug/blob/main/slug.js
(def charmap
  {"À" "A" 
   "Á" "A"
   "Â" "A"
   "Ã" "A"
   "Ä" "A"
   "Å" "A"
   "Æ" "A"
   "Ç" "C"
   "È" "E"
   "É" "E"
   "Ê" "E"
   "Ë" "E"
   "Ì" "I"
   "Í" "I"
   "Î" "I"
   "Ï" "I"
   "Ð" "D"
   "Ñ" "N"
   "Ò" "O"
   "Ó" "O"
   "Ô" "O"
   "Õ" "O"
   "Ö" "O"
   "Ő" "O"
   "Ø" "O"
   "Ō" "O"
   "Ù" "U"
   "Ú" "U"
   "Û" "U"
   "Ü" "U"
   "Ű" "U"
   "Ý" "Y"
   "Þ" "T"
   "ß" "s"
   "à" "a"
   "á" "a"
   "â" "a"
   "ã" "a"
   "ä" "a"
   "å" "a"
   "æ" "a"
   "ç" "c"
   "è" "e"
   "é" "e"
   "ê" "e"
   "ë" "e"
   "ì" "i"
   "í" "i"
   "î" "i"
   "ï" "i"
   "ð" "d"
   "ñ" "n"
   "ò" "o"
   "ó" "o"
   "ô" "o"
   "õ" "o"
   "ö" "o"
   "ő" "o"
   "ø" "o"
   "ō" "o"
   "Œ" "O"
   "œ" "o"
   "ù" "u"
   "ú" "u"
   "û" "u"
   "ü" "u"
   "ű" "u"
   "ý" "y"
   "þ" "t"
   "ÿ" "y"
   "ẞ" "S"
   "α" "a"
   "β" "b"
   "γ" "g"
   "δ" "d"
   "ε" "e"
   "ζ" "z"
   "η" "h"
   "θ" "8"
   "ι" "i"
   "κ" "k"
   "λ" "l"
   "μ" "m"
   "ν" "n"
   "ξ" "3"
   "ο" "o"
   "π" "p"
   "ρ" "r"
   "σ" "s"
   "τ" "t"
   "υ" "y"
   "φ" "f"
   "χ" "x"
   "ψ" "p"
   "ω" "w"
   "ά" "a"
   "έ" "e"
   "ί" "i"
   "ό" "o"
   "ύ" "y"
   "ή" "h"
   "ώ" "w"
   "ς" "s"
   "ϊ" "i"
   "ΰ" "y"
   "ϋ" "y"
   "ΐ" "i"
   "Α" "A"
   "Β" "B"
   "Γ" "G"
   "Δ" "D"
   "Ε" "E"
   "Ζ" "Z"
   "Η" "H"
   "Θ" "8"
   "Ι" "I"
   "Κ" "K"
   "Λ" "L"
   "Μ" "M"
   "Ν" "N"
   "Ξ" "3"
   "Ο" "O"
   "Π" "P"
   "Ρ" "R"
   "Σ" "S"
   "Τ" "T"
   "Υ" "Y"
   "Φ" "F"
   "Χ" "X"
   "Ψ" "P"
   "Ω" "W"
   "Ά" "A"
   "Έ" "E"
   "Ί" "I"
   "Ό" "O"
   "Ύ" "Y"
   "Ή" "H"
   "Ώ" "W"
   "Ϊ" "I"
   "Ϋ" "Y"
   "ş" "s"
   "Ş" "S"
   "ı" "i"
   "İ" "I"
   "ğ" "g"
   "Ğ" "G"
   "а" "a"
   "б" "b"
   "в" "v"
   "г" "g"
   "д" "d"
   "е" "e"
   "ё" "y"
   "ж" "z"
   "з" "z"
   "и" "i"
   "й" "j"
   "к" "k"
   "л" "l"
   "м" "m"
   "н" "n"
   "о" "o"
   "п" "p"
   "р" "r"
   "с" "s"
   "т" "t"
   "у" "u"
   "ф" "f"
   "х" "h"
   "ц" "c"
   "ч" "c"
   "ш" "s"
   "щ" "s"
   "ъ" "u"
   "ы" "y"
   "ь" ""
   "э" "e"
   "ю" "y"
   "я" "y"
   "А" "A"
   "Б" "B"
   "В" "V"
   "Г" "G"
   "Д" "D"
   "Е" "E"
   "Ё" "Y"
   "Ж" "Z"
   "З" "Z"
   "И" "I"
   "Й" "J"
   "К" "K"
   "Л" "L"
   "М" "M"
   "Н" "N"
   "О" "O"
   "П" "P"
   "Р" "R"
   "С" "S"
   "Т" "T"
   "У" "U"
   "Ф" "F"
   "Х" "H"
   "Ц" "C"
   "Ч" "C"
   "Ш" "S"
   "Щ" "S"
   "Ъ" "U"
   "Ы" "Y"
   "Ь" "'"
   "Э" "E"
   "Ю" "Y"
   "Я" "Y"
   "Є" "Y"
   "І" "I"
   "Ї" "Y"
   "Ґ" "G"
   "є" "y"
   "і" "i"
   "ї" "y"
   "ґ" "g"
   "č" "c"
   "ď" "d"
   "ě" "e"
   "ň" "n"
   "ř" "r"
   "š" "s"
   "ť" "t"
   "ů" "u"
   "ž" "z"
   "Č" "C"
   "Ď" "D"
   "Ě" "E"
   "Ň" "N"
   "Ř" "R"
   "Š" "S"
   "Ť" "T"
   "Ů" "U"
   "Ž" "Z"
   "ľ" "l"
   "ĺ" "l"
   "ŕ" "r"
   "Ľ" "L"
   "Ĺ" "L"
   "Ŕ" "R"
   "ą" "a"
   "ć" "c"
   "ę" "e"
   "ł" "l"
   "ń" "n"
   "ś" "s"
   "ź" "z"
   "ż" "z"
   "Ą" "A"
   "Ć" "C"
   "Ę" "E"
   "Ł" "L"
   "Ń" "N"
   "Ś" "S"
   "Ź" "Z"
   "Ż" "Z"
   "ā" "a"
   "ē" "e"
   "ģ" "g"
   "ī" "i"
   "ķ" "k"
   "ļ" "l"
   "ņ" "n"
   "ū" "u"
   "Ā" "A"
   "Ē" "E"
   "Ģ" "G"
   "Ī" "I"
   "Ķ" "K"
   "Ļ" "L"
   "Ņ" "N"
   "Ū" "U"
   "أ" "a"
   "إ" "i"
   "ب" "b"
   "ت" "t"
   "ث" "t"
   "ج" "g"
   "ح" "h"
   "خ" "k"
   "د" "d"
   "ذ" "t"
   "ر" "r"
   "ز" "z"
   "س" "s"
   "ش" "s"
   "ص" "s"
   "ض" "d"
   "ط" "t"
   "ظ" "t"
   "ع" "a"
   "غ" "g"
   "ف" "f"
   "ق" "k"
   "ك" "k"
   "ل" "l"
   "م" "m"
"ن" "n"
"ه" "h"
"و" "o"
"ي" "y"
"ء" "a"
"ة" "a"
"آ" "a"
"ا" "a"
"پ" "p"
"ژ" "z"
"گ" "g"
"چ" "c"
"ک" "k"
"ی" "i"
"ė" "e"
"į" "i"
"ų" "u"
"Ė" "E"
"Į" "I"
"Ų" "U"
"ț" "t"
"Ț" "T"
"ţ" "t"
"Ţ" "T"
"ș" "s"
"Ș" "S"
"ă" "a"
"Ă" "A"
"Ạ" "A"
"Ả" "A"
"Ầ" "A"
"Ấ" "A"
"Ậ" "A"
"Ẩ" "A"
"Ẫ" "A"
"Ằ" "A"
"Ắ" "A"
"Ặ" "A"
"Ẳ" "A"
"Ẵ" "A"
"Ẹ" "E"
"Ẻ" "E"
"Ẽ" "E"
"Ề" "E"
"Ế" "E"
"Ệ" "E"
"Ể" "E"
"Ễ" "E"
"Ị" "I"
"Ỉ" "I"
"Ĩ" "I"
"Ọ" "O"
"Ỏ" "O"
"Ồ" "O"
"Ố" "O"
"Ộ" "O"
"Ổ" "O"
"Ỗ" "O"
"Ơ" "O"
"Ờ" "O"
"Ớ" "O"
"Ợ" "O"
"Ở" "O"
"Ỡ" "O"
"Ụ" "U"
"Ủ" "U"
"Ũ" "U"
"Ư" "U"
"Ừ" "U"
"Ứ" "U"
"Ự" "U"
"Ử" "U"
"Ữ" "U"
"Ỳ" "Y"
"Ỵ" "Y"
"Ỷ" "Y"
"Ỹ" "Y"
"Đ" "D"
"ạ" "a"
"ả" "a"
"ầ" "a"
"ấ" "a"
"ậ" "a"
"ẩ" "a"
"ẫ" "a"
"ằ" "a"
"ắ" "a"
"ặ" "a"
"ẳ" "a"
"ẵ" "a"
"ẹ" "e"
"ẻ" "e"
"ẽ" "e"
"ề" "e"
"ế" "e"
"ệ" "e"
"ể" "e"
"ễ" "e"
"ị" "i"
"ỉ" "i"
"ĩ" "i"
"ọ" "o"
"ỏ" "o"
"ồ" "o"
"ố" "o"
"ộ" "o"
"ổ" "o"
"ỗ" "o"
"ơ" "o"
"ờ" "o"
"ớ" "o"
"ợ" "o"
"ở" "o"
"ỡ" "o"
"ụ" "u"
"ủ" "u"
"ũ" "u"
"ư" "u"
"ừ" "u"
"ứ" "u"
"ự" "u"
"ử" "u"
"ữ" "u"
"ỳ" "y"
"ỵ" "y"
"ỷ" "y"
"ỹ" "y"
"đ" "d"
"Ә" "A"
"ә" "a"
"Ғ" "G"
"ғ" "g"
"Қ" "K"
"қ" "k"
"Ң" "N"
"ң" "n"
"Ү" "U"
"ү" "u"
"Ұ" "U"
"ұ" "u"
"Һ" "H"
"һ" "h"
"Ө" "O"
"ө" "o"
"ђ" "d"
"ј" "j"
"љ" "l"
"њ" "n"
"ћ" "c"
"џ" "d"
"Ђ" "D"
"Ј" "j"
"Љ" "L"
"Њ" "N"
"Ћ" "C"
"Џ" "D"
"ǌ" "n"
"ǉ" "l"
"ǋ" "N"
"ǈ" "L"
"अ" "a"
"आ" "a"
"ए" "e"
"ई" "i"
"ऍ" "e"
"ऎ" "a"
"ऐ" "a"
"इ" "i"
"ओ" "o"
"ऑ" "o"
"ऒ" "oi"
"ऊ" "u"
"औ" "o"
"उ" "u"
"ब" "B"
"भ" "Ba"
"च" "C"
"छ" "Cha"
"ड" "D"
"ढ" "Da"
"फ" "F"
"ग" "G"
"घ" "Ga"
"ग़" "Gi"
"ह" "H"
"ज" "J"
"झ" "Ja"
"क" "K"
"ख" "Ka"
"ख़" "Ki"
"ल" "L"
"ळ" "Li"
"ऌ" "Li"
"ऴ" "Lii"
"ॡ" "Lii"
"म" "Ma"
"न" "Na"
"ङ" "Na"
"ञ" "Nia"
"ण" "Nae"
"ऩ" "Ni"
"ॐ" "oms"
"प" "Pa"
"क़" "Qi"
"र" "Ra"
"ऋ" "Ri"
"ॠ" "Ri"
"ऱ" "Ri"
"स" "Sa"
"श" "Sha"
"ष" "Shha"
"ट" "Ta"
"त" "Ta",
"ठ" "Tha"
"द" "Tha"
"थ" "Tha"
"ध" "Thha"
"ड़" "ugDha"
"ढ़" "ugDhha"
"व" "Va"
"य" "Ya"
"य़" "Yi"
"ज़" "Za"
"ə" "e"
"Ə" "E"
"ა" "a"
"ბ" "b"
"გ" "g"
"დ" "d"
"ე" "e"
"ვ" "v"
"ზ" "z"
"თ" "t"
"ი" "i"
"კ" "k"
"ლ" "l"
"მ" "m"
"ნ" "n"
"ო" "o"
"პ" "p"
"ჟ" "h"
"რ" "r"
"ს" "s"
"ტ" "t"
"უ" "u"
"ფ" "p"
"ქ" "k"
"ღ" "gh"
"ყ" "q"
"შ" "sh"
"ჩ" "ch"
"ც" "ts"
"ძ" "dz"
"წ" "ts"
"ჭ" "ch"
"ხ" "kh"
"ჯ" "j"
"ჰ" "h"
"ב" "v"
"גּ" "g"
"ג" "g"
"ד" "d"
"דּ" "d"
"ה" "h"
"ו" "v"
"ז" "z"
"ח" "h"
"ט" "t"
"י" "y"
"כ" "kh"
"ך" "kh"
"ל" "l"
"מ" "m"
"ם" "m"
"נ" "n"
"ן" "n"
"ס" "s"
"פ" "f"
"ף" "f"
"ץ" "ts"
"צ" "ts"
"ק" "k"
"ר" "r"
"תּ" "t"
"ת" "t"})
;; http://www.eki.ee/wgrs/rom1_bg.pdf
(def locales 
  {:bg {"Й" "Y" 
        "й" "y" 
        "X" "H" 
        "x" "h" 
        "Ц" "Ts" 
        "ц" "ts" 
        "Щ" "Sht" 
        "щ" "sht" 
        "Ъ" "A" 
        "ъ" "a" 
        "Ь" "Y" 
        "ь" "y"}
   :de {"Ä" "AE"
        "ä" "ae" 
        "Ö" "OE"
        "ö" "oe"
        "Ü" "UE"
        "ü" "ue" }
   :sr {"đ" "dj"
        "Đ" "DJ"}
;; https://assets.publishing.service.gov.uk/government/uploads/system/uploads/attachment_data/file/864314/ROMANIZATION_OF_UKRAINIAN.pdf
   :uk {"И" "Y" 
         "и" "y" 
         "Й" "Y"
         "й" "y"
         "Ц" "Ts"
         "ц" "ts"
         "Х" "Kh"
         "х" "kh"
         "Щ" "Shch"
         "щ" "shch"
         "Г" "H"
         "г" "h"} 
   :none {}})
