(ns reveal.actions
  (:require [clojure.core.protocols :as p]
            [clojure.core.specs.alpha :as specs]
            [clojure.set :as set]
            [clojure.spec.alpha :as s]))

(defonce ^:private *registry
  (atom {::actions (sorted-map-by (fn [[priority-a id-a] [priority-b id-b]]
                                    (compare [(- priority-a) id-a] [(- priority-b) id-b])))
         ::priorities {}}))

(defn- unregister [registry id]
  (let [priority (get-in registry [::priorities id] 0)]
    (-> registry
        (update ::actions dissoc [priority id])
        (update ::priorities dissoc id))))

(defn- register [registry action]
  (let [{:keys [id priority]
         :or {priority 0}} action]
    (-> registry
        (unregister id)
        (assoc-in [::priorities id] priority)
        (assoc-in [::actions [priority id]] action))))

(s/def ::id any?)
(s/def ::doc string?)
(s/def ::priority int?)
(s/def ::check fn?)
(s/def ::action
  (s/keys :req-un [::id ::check]
          :opt-un [::doc ::priority]))

(defn reg! [action]
  (s/assert ::action action)
  (swap! *registry register action)
  (:id action))

#_(reg! ::nav {:doc "Navigate" :priority 1}
        (fn [values]
          (when (<= 2 (count values))
            (let [x (peek values)
                  container (p/datafy (peek (pop values)))
                  c (class container)]
              (when (or (instance? (:on-interface p/Navigable) container)
                        (contains? (meta container) `p/nav)
                        (seq (set/intersection (disj (supers c) Object)
                                               (set (keys (:impls p/Navigable))))))
                (cond
                  (map? container) #(p/nav container x (get container x))
                  (sequential? container) #(p/nav container ?index x)
                  :else (p/nav container nil x)))))))

(reg! {:id ::show-exception
       :doc "Show Exception"
       :check (fn [[prepl-output]]
                (when (:exception prepl-output)
                  #(:val prepl-output)))})

(defn most-fitting [values]
  (let [registry @*registry]
    (some (fn [action]
            (try
              (let [f ((:check action) values)]
                (when (ifn? f) (assoc action :invoke f)))
              (catch Exception _)))
          (vals (::actions registry)))))