(ns reveal.popup
  (:require [clojure.string :as str]
            [cljfx.lifecycle :as fx.lifecycle]
            [reveal.event :as event])
  (:import [javafx.scene.input KeyCode KeyEvent]))

;; todo popup
;; - blocking: events consumed
;; - explicit closing by escape
;; - better auto-fixing: shows above or below selection depending on screen position
;; - results are displayed in same popup (enter)
;; - results can be added to main output with closing popup (alt+enter)
;; - results can be cljfx markup
;; - what about changing popup size?

(def ext-value
  (reify fx.lifecycle/Lifecycle
    (create [_ {:keys [value]} _] value)
    (advance [_ _ {:keys [value]} _] value)
    (delete [_ _ _])))

(defmethod event/handle ::on-key-pressed [{:keys [^KeyEvent fx/event dispatch]}]
  (when (= KeyCode/ESCAPE (.getCode event))
    {:dispatch dispatch}))

(defn view [{:keys [actions bounds owner path on-cancel]}]
  {:fx/type :stage
   :owner {:fx/type ext-value :value owner}
   :style :transparent
   :modality :window-modal
   :showing true
   :scene {:fx/type :scene
           :on-key-pressed {::event/type ::on-key-pressed :path path :dispatch on-cancel}
           :root {:fx/type :v-box
                  :style {:-fx-background-color :grey}
                  :padding 50
                  :children [{:fx/type :label
                              :text (str/join ", " (map :label actions))}]}}})
