;;; .ent.el --- local ent config file -*- lexical-binding: t; -*-

;;; Commentary:

;;; Code:

;; project settings
(setq ent-project-home (file-name-directory (if load-file-name load-file-name buffer-file-name)))
(setq ent-project-name "{{name}}")
(setq ent-clean-regexp "~$\\|\\.tex$")
(setq ent-project-orgfile "README.org")

(require 'ent)

(ent-tasks-init)


(task 'format  '() "run format" '(lambda (&optional x) "clojure -M:format"))

(task 'kondo  '() "check source syntax with kondo" '(lambda (&optional x) "clojure -M:kondo"))
(task 'kibit  '() "check source syntax with kibit" '(lambda (&optional x) "clojure -M:kibit"))
(task 'eastwood  '() "check source syntax with eastwood" '(lambda (&optional x) "clojure -M:eastwood"))

(task 'lint  '(kondo kibit eastwood) "check source syntax" '(lambda (&optional x) "ls -l"))


(task 'test  '() "run tests" '(lambda (&optional x) "bin/test"))

(task 'doc  '() "generate docs" '(lambda (&optional x) "clojure -X:doc"))

(task 'libupdate  '() "updates libs" '(lambda (&optional x) "clojure -M:outdated"))

(task 'jar  '() "generate uberjar" '(lambda (&optional x) "clojure -X:uberjar"))

(provide '.ent)
;;; .ent.el ends here

;; Local Variables:
;; no-byte-compile: t
;; no-update-autoloads: t
;; End:
