(ns {{namespace}}.main
  (:require
   [duct.logger :refer [log]]
   [integrant.core :as ig]
   [manifold.stream :as stm]
   [mirror.system :as sys])
  (:import
   [org.jline.terminal TerminalBuilder Terminal])
  (:gen-class))

(def ig-key :mirror/main)

(defmethod ig/init-key ig-key [_ config]
  (let [{:keys [logger]} config]
    (log logger :info ::init)
    config))

(defmethod ig/halt-key! ig-key [_ sys]
  (log (:logger sys) :info ::halt))


(defn -main
  "{{name}} entry point"
  []
  (let [system (-> :prod
                   sys/prep
                   ig/init)]
    ))
