(ns {{namespace}}.system
  (:require
   [aero.core :as aero]
   [clojure.java.io :as io]
   [duct.logger]
   [integrant.core :as ig]))

(defmethod aero/reader 'ig/ref
  [_ _ value]
  (ig/ref value))

(defn config [profile]
  (aero/read-config (io/resource "{{namespace}}/config.edn") {:profile profile}))

(defn prep [profile]
  (let [config (config profile)]
    (ig/load-namespaces config)
    config))
