(ns clj.new.dpom.cljapp
  (:require
   [clj.new.templates :refer [renderer project-data ->files]])
  (:gen-class))

(defn cljapp
  "entry point to run template"
  [name]
  (let [render (renderer "cljapp")
        data   (project-data name)]
    (println "Generating fresh 'clj new' cljapp project.")
    (->files data
             [".clj-kondo/config.edn" (render ".clj-kondo/config.edn" data)]
             ["bin/repl" (render "bin/repl" data)]
             ["bin/run" (render "bin/run" data)]
             ["bin/run-jar" (render "bin/run-jar" data)]
             ["bin/test" (render "bin/test" data)]
             ["dev/user.clj" (render "dev/user.clj" data)]
             [".cljstyle" (render ".cljstyle" data)]
             [".dir-locals.el" (render ".dir-locals.el" data)]
             [".ent.el" (render ".ent.el" data)]
             [".gitlab-ci.yml" (render ".gitlab-ci.yml" data)]
             ["Notebook.org" (render "Notebook.org" data)]
             ["README.org" (render "README.org" data)]
             ["deps.edn" (render "deps.edn" data)]
             ["src/{{nested-dirs}}/system.clj" (render "system.clj" data)]
             ["src/{{nested-dirs}}/main.clj" (render "main.clj" data)]
             ["tests.edn" (render "tests.edn" data)])))
