(ns ligable.plugins
  "A few default plugins for ligable")

(defn- key-to-sym [k]
  (symbol (subs (str k) 1)))

;; TODO: change to a reagent-like rum atom
;; TODO: don't forget to unquote splice
(defn data-plugin
  "The data-plugin creates Reagent atoms for each keyword given."
  [data-map]
  (map (fn [[k# v#]]
         `(def ~(key-to-sym k#) (reagent.core/atom ~v#)))
    data-map))

(comment (data-plugin {:hi "woot"}))


(defn key-to-str [k]
  (subs (str k) 1))

;; NOTE: assumes we're using hiccup syntax
(defn- page-router
  "This reads the UI pages and sets up the routing"
  [ui homepage]
  ;; HACK: page-atom goes here because it must be globally defined and this
  ;; fn depends on it
  `(do (def ~'page-atom (reagent.core/atom {:page ~homepage}))
       (defn ~'screen []
         (let [page# (:page ~'@page-atom)
               current# (case page#
                          ~@(reduce (fn [acc# [p# _]]
                                      (conj acc# (key-to-str p#)
                                        [(key-to-sym p#)]))
                              [] ui))]
           [:div current#]))))

(comment (page-router {:home "woot" :stuff "hiya"}))

;; FIXME: there should be a better way than using :homepage
(defn ui-plugin
  "This builds a UI with app pages and DOM code for each page. A default page
  of :homepage is required and acts as the first page that gets loaded (the
  homepage/homescreen)."
  [ui-map]
  (let [homepage# (-> ui-map :homepage key-to-str)
        new-map# (dissoc ui-map :homepage)]
    `[~(page-router new-map# homepage#)
      ~@(reduce (fn [acc [page body]]
                  (conj acc
                    `(defn ~(key-to-sym page) []
                       ;; FIXME: should put a closure here if doing reagent
                       ;; or the equivalent for Rum
                       ~body)))
          [] new-map#)]))

(comment (println (ui-plugin {:home [:section [:stuff]]
                               :prefs [:moar]
                               :homepage :home})))
