/*
 * Decompiled with CFR 0.152.
 */
package com.hbase.haxwell.util;

import com.hbase.haxwell.util.ZkConnectException;
import com.hbase.haxwell.util.ZooKeeperOperation;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZookeeperHelper
implements Closeable {
    protected ZooKeeper delegate;
    protected Set<Watcher> additionalDefaultWatchers = Collections.newSetFromMap(new IdentityHashMap());
    protected boolean connected = false;
    protected volatile boolean stop = false;
    protected final Object connectedMonitor = new Object();
    protected Thread zkEventThread;
    private Log log = LogFactory.getLog(this.getClass());

    protected ZookeeperHelper() {
    }

    public ZookeeperHelper(String connectString, int sessionTimeout) throws ZkConnectException {
        this.connect(connectString, sessionTimeout);
    }

    public ZookeeperHelper(String connectionString) {
    }

    public void addDefaultWatcher(Watcher watcher) {
        this.additionalDefaultWatchers.add(watcher);
    }

    public void removeDefaultWatcher(Watcher watcher) {
        this.additionalDefaultWatchers.remove(watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stop = true;
        Object object = this.connectedMonitor;
        synchronized (object) {
            this.connectedMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForConnection() throws InterruptedException {
        if (this.isCurrentThreadEventThread()) {
            throw new RuntimeException("waitForConnection should not be called from within the ZooKeeper event thread.");
        }
        Object object = this.connectedMonitor;
        synchronized (object) {
            while (!this.connected && !this.stop) {
                this.connectedMonitor.wait();
            }
        }
        if (this.stop) {
            throw new InterruptedException("This ZooKeeper handle is shutting down.");
        }
    }

    public boolean isCurrentThreadEventThread() {
        return this.zkEventThread != null && this.zkEventThread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectedState(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            Object object = this.connectedMonitor;
            synchronized (object) {
                if (!this.connected) {
                    this.connected = true;
                    this.connectedMonitor.notifyAll();
                }
            }
        }
        if (event.getState() == Watcher.Event.KeeperState.Disconnected || event.getState() == Watcher.Event.KeeperState.Expired) {
            Object object = this.connectedMonitor;
            synchronized (object) {
                if (this.connected) {
                    this.connected = false;
                    this.connectedMonitor.notifyAll();
                }
            }
        }
    }

    public <T> T retryOperation(ZooKeeperOperation<T> operation) throws InterruptedException, KeeperException {
        if (this.isCurrentThreadEventThread()) {
            throw new RuntimeException("retryOperation should not be called from within the ZooKeeper event thread.");
        }
        int tryCount = 0;
        while (true) {
            ++tryCount;
            try {
                return operation.execute();
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                if (tryCount > 3) {
                    this.log.warn((Object)("ZooKeeper operation attempt " + tryCount + " failed due to connection loss."));
                }
                this.waitForConnection();
                continue;
            }
            break;
        }
    }

    public long getSessionId() {
        return this.delegate.getSessionId();
    }

    public byte[] getSessionPasswd() {
        return this.delegate.getSessionPasswd();
    }

    public int getSessionTimeout() {
        return this.delegate.getSessionTimeout();
    }

    public void addAuthInfo(String scheme, byte[] auth) {
        this.delegate.addAuthInfo(scheme, auth);
    }

    public void register(Watcher watcher) {
        this.delegate.register(watcher);
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.delegate.create(path, data, acl, createMode);
    }

    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this.delegate.create(path, data, acl, createMode, cb, ctx);
    }

    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.delegate.delete(path, version);
    }

    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this.delegate.delete(path, version, cb, ctx);
    }

    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.delegate.exists(path, watcher);
    }

    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.delegate.exists(path, watch);
    }

    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.exists(path, watcher, cb, ctx);
    }

    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.exists(path, watch, cb, ctx);
    }

    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getData(path, watcher, stat);
    }

    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getData(path, watch, stat);
    }

    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.delegate.getData(path, watcher, cb, ctx);
    }

    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.delegate.getData(path, watch, cb, ctx);
    }

    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.delegate.setData(path, data, version);
    }

    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.setData(path, data, version, cb, ctx);
    }

    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getACL(path, stat);
    }

    public void getACL(String path, Stat stat, AsyncCallback.ACLCallback cb, Object ctx) {
        this.delegate.getACL(path, stat, cb, ctx);
    }

    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        return this.delegate.setACL(path, acl, version);
    }

    public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.setACL(path, acl, version, cb, ctx);
    }

    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watcher);
    }

    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watch);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.delegate.getChildren(path, watcher, cb, ctx);
    }

    public void getChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.delegate.getChildren(path, watch, cb, ctx);
    }

    public List<String> getChildren(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watcher, stat);
    }

    public List<String> getChildren(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watch, stat);
    }

    public void getChildren(String path, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.delegate.getChildren(path, watcher, cb, ctx);
    }

    public void getChildren(String path, boolean watch, AsyncCallback.Children2Callback cb, Object ctx) {
        this.delegate.getChildren(path, watch, cb, ctx);
    }

    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.delegate.sync(path, cb, ctx);
    }

    public ZooKeeper.States getState() {
        return this.delegate.getState();
    }

    public void connect(String connectString, int sessionTimeout) throws ZkConnectException {
        try {
            this.delegate = new ZooKeeper(connectString, sessionTimeout, null);
        }
        catch (IOException e) {
            throw new ZkConnectException("Failed to connect with Zookeeper @ '" + connectString + "'", e);
        }
        long waitUntil = System.currentTimeMillis() + (long)sessionTimeout;
        boolean connected = ZooKeeper.States.CONNECTED.equals((Object)this.delegate.getState());
        while (!connected && waitUntil > System.currentTimeMillis()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                connected = ZooKeeper.States.CONNECTED.equals((Object)this.delegate.getState());
                break;
            }
            connected = ZooKeeper.States.CONNECTED.equals((Object)this.delegate.getState());
        }
        if (!connected) {
            System.out.println("Failed to connect to Zookeeper within timeout: Dumping stack: ");
            Thread.dumpStack();
            try {
                this.delegate.close();
            }
            catch (InterruptedException e) {
                System.out.println("Failed to close connection: " + e.getMessage());
            }
            throw new ZkConnectException("Failed to connect with Zookeeper @ '" + connectString + "' within timeout " + sessionTimeout);
        }
    }

    public void createPath(String path) throws InterruptedException, KeeperException {
        this.createPath(path, null);
    }

    public void createPath(String path, byte[] data) throws InterruptedException, KeeperException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path should start with a slash.");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path should not end on a slash.");
        }
        String[] parts = path.substring(1).split("/");
        StringBuilder subPath = new StringBuilder();
        boolean created = false;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            subPath.append("/").append(part);
            byte[] newData = (byte[])(i == parts.length - 1 ? data : null);
            created = this.retryOperation(() -> {
                if (this.delegate.exists(subPath.toString(), false) == null) {
                    try {
                        this.delegate.create(subPath.toString(), newData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                        return true;
                    }
                    catch (KeeperException.NodeExistsException e) {
                        return false;
                    }
                }
                return false;
            });
        }
        if (!created) {
            this.retryOperation(() -> {
                byte[] currentData = this.delegate.getData(path, false, new Stat());
                if (!Arrays.equals(currentData, data)) {
                    this.delegate.setData(path, data, -1);
                }
                return null;
            });
        }
    }

    public void update(String path, byte[] data, int version) throws InterruptedException, KeeperException {
        this.retryOperation(() -> {
            this.delegate.setData(path, data, version);
            return null;
        });
    }

    public void deleteNode(String path) throws InterruptedException, KeeperException {
        this.retryOperation(() -> {
            Stat stat = this.delegate.exists(path, false);
            if (stat != null) {
                try {
                    this.delegate.delete(path, stat.getVersion());
                }
                catch (KeeperException.NoNodeException noNodeException) {
                    // empty catch block
                }
            }
            return true;
        });
    }

    public class MyWatcher
    implements Watcher {
        private boolean printConnectMsg = false;

        public void process(WatchedEvent event) {
            ZookeeperHelper.this.zkEventThread = Thread.currentThread();
            if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                System.err.println("ZooKeeper disconnected at " + new Date());
                this.printConnectMsg = true;
            } else if (event.getState() == Watcher.Event.KeeperState.Expired) {
                System.err.println("ZooKeeper session expired at " + new Date());
                this.printConnectMsg = true;
            } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.printConnectMsg) {
                System.out.println("ZooKeeper connected at " + new Date());
            }
            ZookeeperHelper.this.setConnectedState(event);
            for (Watcher watcher : ZookeeperHelper.this.additionalDefaultWatchers) {
                watcher.process(event);
            }
        }
    }
}

