/*
 * Decompiled with CFR 0.152.
 */
package clojure.osgi.internal;

import clojure.lang.Associative;
import clojure.lang.Compiler;
import clojure.lang.RT;
import clojure.lang.Var;
import clojure.osgi.IClojureLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClojureLoader
implements IClojureLoader {
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    @Override
    public Object createInstance(final ClassLoader cl, final String className) throws Exception {
        return this.executor.submit(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Thread.currentThread().setContextClassLoader(cl);
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{Compiler.LOADER, cl}));
                try {
                    Class<?> clazz = cl.loadClass(className);
                    Object obj = clazz.newInstance();
                    return obj;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }).get();
    }

    @Override
    public Object invoke(final ClassLoader cl, final Callable callable) throws Exception {
        return this.executor.submit(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Thread.currentThread().setContextClassLoader(cl);
                Var.pushThreadBindings((Associative)RT.map((Object[])new Object[]{Compiler.LOADER, cl}));
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    Var.popThreadBindings();
                }
            }
        }).get();
    }

    public void destroy() {
        this.executor.shutdownNow();
    }
}

