(ns contrib.hash-map
  (:refer-clojure :exclude [get contains?]))

(defn create [] (js/Map.))
(defn put [hm k v] (doto hm (.set k v)))
(defn contains? [hm k] (.has hm k))
(defn ?put [hm k thunk] (if (contains? hm k) hm (doto hm (.set k (thunk)))))
(defn get [hm k] (.get hm k))
(defn ->persistent [hm]
  (let [iter (.entries hm)]
    (loop [ac (transient {})]
      (let [nx (.next iter)]
        (if (.-done nx)
          (persistent! ac)
          (let [[k v] (.-value nx)]
            (recur (assoc! ac k v))))))))
