/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import TestJavaClient.ComboLegModel;
import TestJavaClient.Main;
import com.ib.client.ComboLeg;
import com.ib.client.OrderComboLeg;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboLegDlg
extends JDialog {
    private Vector m_comboLegs;
    private Vector m_orderComboLegs;
    private JTextField m_conId = new JTextField("0");
    private JTextField m_ratio = new JTextField("0");
    private JTextField m_action = new JTextField("BUY");
    private JTextField m_exchange = new JTextField("");
    private JTextField m_openClose = new JTextField("0");
    private JTextField m_shortSaleSlot = new JTextField("0");
    private JTextField m_designatedLocation = new JTextField("");
    private JTextField m_exemptCode = new JTextField("-1");
    private JTextField m_price = new JTextField("");
    private JButton m_addLeg = new JButton("Add");
    private JButton m_removeLeg = new JButton("Remove");
    private JButton m_ok = new JButton("OK");
    private JButton m_cancel = new JButton("Cancel");
    private ComboLegModel m_comboLegsModel = new ComboLegModel();
    private JTable m_comboTable = new JTable(this.m_comboLegsModel);
    private JScrollPane m_comboLegsPane = new JScrollPane(this.m_comboTable);

    public ComboLegModel comboLegModel() {
        return this.m_comboLegsModel;
    }

    public ComboLegDlg(Vector<ComboLeg> vector, Vector<OrderComboLeg> vector2, String string, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.m_comboLegs = vector;
        this.m_orderComboLegs = vector2;
        this.setTitle("Combination Legs");
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Combination Order legs:"));
        this.m_comboLegsModel.comboLegData().addAll(vector);
        this.m_comboLegsModel.orderComboLegData().addAll(vector2);
        jPanel.add(this.m_comboLegsPane);
        if (string != null && string.length() > 0) {
            this.m_exchange.setText(string);
        }
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 10, 10));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Combo Leg Details:"));
        jPanel2.add(new JLabel("ConId:"));
        jPanel2.add(this.m_conId);
        jPanel2.add(new JLabel("Ratio:"));
        jPanel2.add(this.m_ratio);
        jPanel2.add(new JLabel("Side:"));
        jPanel2.add(this.m_action);
        jPanel2.add(new JLabel("Exchange:"));
        jPanel2.add(this.m_exchange);
        jPanel2.add(new JLabel("Open/Close:"));
        jPanel2.add(this.m_openClose);
        jPanel2.add(new JLabel("Short Sale Slot:"));
        jPanel2.add(this.m_shortSaleSlot);
        jPanel2.add(new JLabel("Designated Location:"));
        jPanel2.add(this.m_designatedLocation);
        jPanel2.add(new JLabel("Exempt Code:"));
        jPanel2.add(this.m_exemptCode);
        jPanel2.add(new JLabel("Price:"));
        jPanel2.add(this.m_price);
        jPanel2.add(this.m_addLeg);
        jPanel2.add(this.m_removeLeg);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.m_ok);
        jPanel3.add(this.m_cancel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        this.getContentPane().add((Component)jPanel4, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.m_addLeg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboLegDlg.this.onAddLeg();
            }
        });
        this.m_removeLeg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboLegDlg.this.onRemoveLeg();
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboLegDlg.this.onOk();
            }
        });
        this.m_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboLegDlg.this.onCancel();
            }
        });
        this.setSize(250, 600);
        this.centerOnOwner(this);
    }

    public void onAddLeg() {
        try {
            int n = Integer.parseInt(this.m_conId.getText());
            int n2 = Integer.parseInt(this.m_ratio.getText());
            int n3 = Integer.parseInt(this.m_openClose.getText());
            int n4 = Integer.parseInt(this.m_shortSaleSlot.getText());
            int n5 = Integer.parseInt(this.m_exemptCode.getText().length() != 0 ? this.m_exemptCode.getText() : "-1");
            double d = this.parseStringToMaxDouble(this.m_price.getText());
            this.m_comboLegsModel.addComboLeg(new ComboLeg(n, n2, this.m_action.getText(), this.m_exchange.getText(), n3, n4, this.m_designatedLocation.getText(), n5), new OrderComboLeg(d));
        }
        catch (Exception exception) {
            this.reportError("Error - ", exception);
            return;
        }
    }

    public void onRemoveLeg() {
        try {
            if (this.m_comboTable.getSelectedRowCount() != 0) {
                int[] nArray = this.m_comboTable.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.m_comboLegsModel.removeComboLeg(nArray[i]);
                }
            }
        }
        catch (Exception exception) {
            this.reportError("Error - ", exception);
            return;
        }
    }

    void onOk() {
        this.m_comboLegs.clear();
        this.m_comboLegs.addAll(this.m_comboLegsModel.comboLegData());
        this.m_orderComboLegs.clear();
        this.m_orderComboLegs.addAll(this.m_comboLegsModel.orderComboLegData());
        this.setVisible(false);
    }

    void onCancel() {
        this.setVisible(false);
    }

    void reportError(String string, Exception exception) {
        Main.inform(this, string + " --" + exception);
    }

    private void centerOnOwner(Window window) {
        Window window2 = window.getOwner();
        if (window2 == null) {
            return;
        }
        int n = window2.getX() + (window2.getWidth() - window.getWidth()) / 2;
        int n2 = window2.getY() + (window2.getHeight() - window.getHeight()) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }

    private double parseStringToMaxDouble(String string) {
        if (string.trim().length() == 0) {
            return Double.MAX_VALUE;
        }
        return Double.parseDouble(string);
    }
}

