/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MktDepthModel
extends AbstractTableModel {
    private LinkedList<MktDepthTableRow> m_allData = new LinkedList();

    MktDepthModel() {
    }

    public synchronized void addOrderAt(int n, String string, double d, int n2) {
        MktDepthTableRow mktDepthTableRow = new MktDepthTableRow(string, d, n2);
        this.m_allData.add(n, mktDepthTableRow);
        this.fireTableRowsInserted(n, n);
    }

    public synchronized void removeOrderAt(int n) {
        this.m_allData.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public synchronized MktDepthTableRow getOrderAt(int n) {
        return this.getIteratorAt(n).next();
    }

    public synchronized ListIterator<MktDepthTableRow> getIteratorAt(int n) {
        return this.m_allData.listIterator(n);
    }

    public synchronized void updateCumSizesAndAvgPrices(int n) {
        int n2 = 0;
        double d = 0.0;
        MktDepthTableRow mktDepthTableRow = null;
        if (n > 0) {
            mktDepthTableRow = this.m_allData.get(n - 1);
            n2 = mktDepthTableRow.m_cumSize;
            d = mktDepthTableRow.m_price * (double)n2;
        }
        for (int i = n; i < this.m_allData.size(); ++i) {
            mktDepthTableRow = this.m_allData.get(i);
            mktDepthTableRow.m_cumSize = n2 += mktDepthTableRow.m_size;
            mktDepthTableRow.m_avgPrice = (d += mktDepthTableRow.m_price * (double)mktDepthTableRow.m_size) / (double)n2;
            this.fireTableCellUpdated(i, 3);
            this.fireTableCellUpdated(i, 4);
        }
    }

    public synchronized void reset() {
        this.m_allData.clear();
        this.fireTableDataChanged();
    }

    @Override
    public synchronized int getRowCount() {
        return this.m_allData.size();
    }

    @Override
    public synchronized int getColumnCount() {
        return 5;
    }

    @Override
    public synchronized Object getValueAt(int n, int n2) {
        if (n >= this.m_allData.size()) {
            return null;
        }
        return this.m_allData.get(n).getValue(n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "MM";
            }
            case 1: {
                return "Price";
            }
            case 2: {
                return "Size";
            }
            case 3: {
                return "Cum Size";
            }
            case 4: {
                return "Avg Price";
            }
        }
        return null;
    }

    class MktDepthTableRow {
        public String m_marketMaker;
        public double m_price;
        public int m_size;
        public int m_cumSize;
        public double m_avgPrice;

        MktDepthTableRow(String string, double d, int n) {
            this.m_marketMaker = string;
            this.m_price = d;
            this.m_size = n;
            this.m_cumSize = 0;
            this.m_avgPrice = 0.0;
        }

        Object getValue(int n) {
            switch (n) {
                case 0: {
                    return this.m_marketMaker;
                }
                case 1: {
                    return "" + this.m_price;
                }
                case 2: {
                    return "" + this.m_size;
                }
                case 3: {
                    return "" + this.m_cumSize;
                }
                case 4: {
                    return "" + this.m_avgPrice;
                }
            }
            return null;
        }
    }
}

