/*
 * Decompiled with CFR 0.152.
 */
package TestJavaClient;

import TestJavaClient.Main;
import TestJavaClient.SmartComboRoutingParamModel;
import com.ib.client.Order;
import com.ib.client.TagValue;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class SmartComboRoutingParamsDlg
extends JDialog {
    private Order m_order;
    private Vector m_smartComboRoutingParams;
    private JTextField m_tag = new JTextField("");
    private JTextField m_value = new JTextField("");
    private JButton m_addParam = new JButton("Add");
    private JButton m_removeParam = new JButton("Remove");
    private JButton m_ok = new JButton("OK");
    private JButton m_cancel = new JButton("Cancel");
    private SmartComboRoutingParamModel m_paramModel = new SmartComboRoutingParamModel();
    private JTable m_paramTable = new JTable(this.m_paramModel);
    private JScrollPane m_paramPane = new JScrollPane(this.m_paramTable);

    public SmartComboRoutingParamModel paramModel() {
        return this.m_paramModel;
    }

    public SmartComboRoutingParamsDlg(Order order, JDialog jDialog) {
        super((Dialog)jDialog, true);
        this.m_order = order;
        this.setTitle("Smart Combo Routing Parameters");
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        jPanel.setBorder(BorderFactory.createTitledBorder("Smart Combo Routing Parameters"));
        Vector<TagValue> vector = this.m_order.m_smartComboRoutingParams;
        if (vector != null) {
            this.m_paramModel.smartComboRoutingParams().addAll(vector);
        }
        jPanel.add(this.m_paramPane);
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 10, 10));
        jPanel2.setBorder(BorderFactory.createTitledBorder("Add / Remove"));
        jPanel2.add(new JLabel("Param:"));
        jPanel2.add(this.m_tag);
        jPanel2.add(new JLabel("Value:"));
        jPanel2.add(this.m_value);
        jPanel2.add(this.m_addParam);
        jPanel2.add(this.m_removeParam);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.m_ok);
        jPanel3.add(this.m_cancel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(jPanel);
        jPanel4.add(jPanel2);
        this.getContentPane().add((Component)jPanel4, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        this.m_addParam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SmartComboRoutingParamsDlg.this.onAddParam();
            }
        });
        this.m_removeParam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SmartComboRoutingParamsDlg.this.onRemoveParam();
            }
        });
        this.m_ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SmartComboRoutingParamsDlg.this.onOk();
            }
        });
        this.m_cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SmartComboRoutingParamsDlg.this.onCancel();
            }
        });
        this.setSize(250, 600);
        this.centerOnOwner(this);
    }

    public void onAddParam() {
        try {
            String string = this.m_tag.getText();
            String string2 = this.m_value.getText();
            this.m_paramModel.addParam(new TagValue(string, string2));
        }
        catch (Exception exception) {
            this.reportError("Error - ", exception);
            return;
        }
    }

    public void onRemoveParam() {
        try {
            if (this.m_paramTable.getSelectedRowCount() != 0) {
                int[] nArray = this.m_paramTable.getSelectedRows();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    this.m_paramModel.removeParam(nArray[i]);
                }
            }
        }
        catch (Exception exception) {
            this.reportError("Error - ", exception);
            return;
        }
    }

    void onOk() {
        Vector vector = this.m_paramModel.smartComboRoutingParams();
        this.m_order.m_smartComboRoutingParams = vector.isEmpty() ? null : vector;
        this.setVisible(false);
    }

    void onCancel() {
        this.setVisible(false);
    }

    void reportError(String string, Exception exception) {
        Main.inform(this, string + " --" + exception);
    }

    private void centerOnOwner(Window window) {
        Window window2 = window.getOwner();
        if (window2 == null) {
            return;
        }
        int n = window2.getX() + (window2.getWidth() - window.getWidth()) / 2;
        int n2 = window2.getY() + (window2.getHeight() - window.getHeight()) / 2;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }
}

