/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.UnderComp;
import com.ib.client.Util;
import java.util.Vector;

public class Contract
implements Cloneable {
    public int m_conId;
    public String m_symbol;
    public String m_secType;
    public String m_expiry;
    public double m_strike;
    public String m_right;
    public String m_multiplier;
    public String m_exchange;
    public String m_currency;
    public String m_localSymbol;
    public String m_primaryExch;
    public boolean m_includeExpired;
    public String m_secIdType;
    public String m_secId;
    public String m_comboLegsDescrip;
    public Vector m_comboLegs = new Vector();
    public UnderComp m_underComp;

    public Contract() {
        this.m_conId = 0;
        this.m_strike = 0.0;
        this.m_includeExpired = false;
    }

    public Object clone() throws CloneNotSupportedException {
        Contract contract = (Contract)super.clone();
        contract.m_comboLegs = (Vector)contract.m_comboLegs.clone();
        return contract;
    }

    public Contract(int n, String string, String string2, String string3, double d, String string4, String string5, String string6, String string7, String string8, Vector vector, String string9, boolean bl, String string10, String string11) {
        this.m_conId = n;
        this.m_symbol = string;
        this.m_secType = string2;
        this.m_expiry = string3;
        this.m_strike = d;
        this.m_right = string4;
        this.m_multiplier = string5;
        this.m_exchange = string6;
        this.m_currency = string7;
        this.m_includeExpired = bl;
        this.m_localSymbol = string8;
        this.m_comboLegs = vector;
        this.m_primaryExch = string9;
        this.m_secIdType = string10;
        this.m_secId = string11;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Contract)) {
            return false;
        }
        Contract contract = (Contract)object;
        if (this.m_conId != contract.m_conId) {
            return false;
        }
        if (Util.StringCompare(this.m_secType, contract.m_secType) != 0) {
            return false;
        }
        if (Util.StringCompare(this.m_symbol, contract.m_symbol) != 0 || Util.StringCompare(this.m_exchange, contract.m_exchange) != 0 || Util.StringCompare(this.m_primaryExch, contract.m_primaryExch) != 0 || Util.StringCompare(this.m_currency, contract.m_currency) != 0) {
            return false;
        }
        if (!Util.NormalizeString(this.m_secType).equals("BOND")) {
            if (this.m_strike != contract.m_strike) {
                return false;
            }
            if (Util.StringCompare(this.m_expiry, contract.m_expiry) != 0 || Util.StringCompare(this.m_right, contract.m_right) != 0 || Util.StringCompare(this.m_multiplier, contract.m_multiplier) != 0 || Util.StringCompare(this.m_localSymbol, contract.m_localSymbol) != 0) {
                return false;
            }
        }
        if (Util.StringCompare(this.m_secIdType, contract.m_secIdType) != 0) {
            return false;
        }
        if (Util.StringCompare(this.m_secId, contract.m_secId) != 0) {
            return false;
        }
        if (!Util.VectorEqualsUnordered(this.m_comboLegs, contract.m_comboLegs)) {
            return false;
        }
        if (this.m_underComp != contract.m_underComp) {
            if (this.m_underComp == null || contract.m_underComp == null) {
                return false;
            }
            if (!this.m_underComp.equals(contract.m_underComp)) {
                return false;
            }
        }
        return true;
    }
}

