/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.AnyWrapperMsgGenerator;
import com.ib.client.ComboLeg;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.EClientSocket;
import com.ib.client.Execution;
import com.ib.client.MarketDataType;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderState;
import com.ib.client.TagValue;
import com.ib.client.TickType;
import com.ib.client.UnderComp;
import com.ib.client.Util;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;

public class EWrapperMsgGenerator
extends AnyWrapperMsgGenerator {
    public static final String SCANNER_PARAMETERS = "SCANNER PARAMETERS:";
    public static final String FINANCIAL_ADVISOR = "FA:";

    public static String tickPrice(int n, int n2, double d, int n3) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + d + " " + (n3 != 0 ? " canAutoExecute" : " noAutoExecute");
    }

    public static String tickSize(int n, int n2, int n3) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + n3;
    }

    public static String tickOptionComputation(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        String string = "id=" + n + "  " + TickType.getField(n2) + ": vol = " + (d >= 0.0 && d != Double.MAX_VALUE ? Double.toString(d) : "N/A") + " delta = " + (Math.abs(d2) <= 1.0 ? Double.toString(d2) : "N/A") + " gamma = " + (Math.abs(d5) <= 1.0 ? Double.toString(d5) : "N/A") + " vega = " + (Math.abs(d6) <= 1.0 ? Double.toString(d6) : "N/A") + " theta = " + (Math.abs(d7) <= 1.0 ? Double.toString(d7) : "N/A") + " optPrice = " + (d3 >= 0.0 && d3 != Double.MAX_VALUE ? Double.toString(d3) : "N/A") + " pvDividend = " + (d4 >= 0.0 && d4 != Double.MAX_VALUE ? Double.toString(d4) : "N/A") + " undPrice = " + (d8 >= 0.0 && d8 != Double.MAX_VALUE ? Double.toString(d8) : "N/A");
        return string;
    }

    public static String tickGeneric(int n, int n2, double d) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + d;
    }

    public static String tickString(int n, int n2, String string) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + string;
    }

    public static String tickEFP(int n, int n2, double d, String string, double d2, int n3, String string2, double d3, double d4) {
        return "id=" + n + "  " + TickType.getField(n2) + ": basisPoints = " + d + "/" + string + " impliedFuture = " + d2 + " holdDays = " + n3 + " futureExpiry = " + string2 + " dividendImpact = " + d3 + " dividends to expiry = " + d4;
    }

    public static String orderStatus(int n, String string, int n2, int n3, double d, int n4, int n5, double d2, int n6, String string2) {
        return "order status: orderId=" + n + " clientId=" + n6 + " permId=" + n4 + " status=" + string + " filled=" + n2 + " remaining=" + n3 + " avgFillPrice=" + d + " lastFillPrice=" + d2 + " parent Id=" + n5 + " whyHeld=" + string2;
    }

    public static String openOrder(int n, Contract contract, Order order, OrderState orderState) {
        Object object;
        String string = "open order: orderId=" + n + " action=" + order.m_action + " quantity=" + order.m_totalQuantity + " symbol=" + contract.m_symbol + " exchange=" + contract.m_exchange + " secType=" + contract.m_secType + " type=" + order.m_orderType + " lmtPrice=" + Util.DoubleMaxString(order.m_lmtPrice) + " auxPrice=" + Util.DoubleMaxString(order.m_auxPrice) + " TIF=" + order.m_tif + " localSymbol=" + contract.m_localSymbol + " client Id=" + order.m_clientId + " parent Id=" + order.m_parentId + " permId=" + order.m_permId + " outsideRth=" + order.m_outsideRth + " hidden=" + order.m_hidden + " discretionaryAmt=" + order.m_discretionaryAmt + " displaySize=" + order.m_displaySize + " triggerMethod=" + order.m_triggerMethod + " goodAfterTime=" + order.m_goodAfterTime + " goodTillDate=" + order.m_goodTillDate + " faGroup=" + order.m_faGroup + " faMethod=" + order.m_faMethod + " faPercentage=" + order.m_faPercentage + " faProfile=" + order.m_faProfile + " shortSaleSlot=" + order.m_shortSaleSlot + " designatedLocation=" + order.m_designatedLocation + " exemptCode=" + order.m_exemptCode + " ocaGroup=" + order.m_ocaGroup + " ocaType=" + order.m_ocaType + " rule80A=" + order.m_rule80A + " allOrNone=" + order.m_allOrNone + " minQty=" + Util.IntMaxString(order.m_minQty) + " percentOffset=" + Util.DoubleMaxString(order.m_percentOffset) + " eTradeOnly=" + order.m_eTradeOnly + " firmQuoteOnly=" + order.m_firmQuoteOnly + " nbboPriceCap=" + Util.DoubleMaxString(order.m_nbboPriceCap) + " optOutSmartRouting=" + order.m_optOutSmartRouting + " auctionStrategy=" + order.m_auctionStrategy + " startingPrice=" + Util.DoubleMaxString(order.m_startingPrice) + " stockRefPrice=" + Util.DoubleMaxString(order.m_stockRefPrice) + " delta=" + Util.DoubleMaxString(order.m_delta) + " stockRangeLower=" + Util.DoubleMaxString(order.m_stockRangeLower) + " stockRangeUpper=" + Util.DoubleMaxString(order.m_stockRangeUpper) + " volatility=" + Util.DoubleMaxString(order.m_volatility) + " volatilityType=" + order.m_volatilityType + " deltaNeutralOrderType=" + order.m_deltaNeutralOrderType + " deltaNeutralAuxPrice=" + Util.DoubleMaxString(order.m_deltaNeutralAuxPrice) + " deltaNeutralConId=" + order.m_deltaNeutralConId + " deltaNeutralSettlingFirm=" + order.m_deltaNeutralSettlingFirm + " deltaNeutralClearingAccount=" + order.m_deltaNeutralClearingAccount + " deltaNeutralClearingIntent=" + order.m_deltaNeutralClearingIntent + " deltaNeutralOpenClose=" + order.m_deltaNeutralOpenClose + " deltaNeutralShortSale=" + order.m_deltaNeutralShortSale + " deltaNeutralShortSaleSlot=" + order.m_deltaNeutralShortSaleSlot + " deltaNeutralDesignatedLocation=" + order.m_deltaNeutralDesignatedLocation + " continuousUpdate=" + order.m_continuousUpdate + " referencePriceType=" + order.m_referencePriceType + " trailStopPrice=" + Util.DoubleMaxString(order.m_trailStopPrice) + " trailingPercent=" + Util.DoubleMaxString(order.m_trailingPercent) + " scaleInitLevelSize=" + Util.IntMaxString(order.m_scaleInitLevelSize) + " scaleSubsLevelSize=" + Util.IntMaxString(order.m_scaleSubsLevelSize) + " scalePriceIncrement=" + Util.DoubleMaxString(order.m_scalePriceIncrement) + " scalePriceAdjustValue=" + Util.DoubleMaxString(order.m_scalePriceAdjustValue) + " scalePriceAdjustInterval=" + Util.IntMaxString(order.m_scalePriceAdjustInterval) + " scaleProfitOffset=" + Util.DoubleMaxString(order.m_scaleProfitOffset) + " scaleAutoReset=" + order.m_scaleAutoReset + " scaleInitPosition=" + Util.IntMaxString(order.m_scaleInitPosition) + " scaleInitFillQty=" + Util.IntMaxString(order.m_scaleInitFillQty) + " scaleRandomPercent=" + order.m_scaleRandomPercent + " hedgeType=" + order.m_hedgeType + " hedgeParam=" + order.m_hedgeParam + " account=" + order.m_account + " settlingFirm=" + order.m_settlingFirm + " clearingAccount=" + order.m_clearingAccount + " clearingIntent=" + order.m_clearingIntent + " notHeld=" + order.m_notHeld + " whatIf=" + order.m_whatIf;
        if ("BAG".equals(contract.m_secType)) {
            if (contract.m_comboLegsDescrip != null) {
                string = string + " comboLegsDescrip=" + contract.m_comboLegsDescrip;
            }
            string = string + " comboLegs={";
            if (contract.m_comboLegs != null) {
                for (int i = 0; i < contract.m_comboLegs.size(); ++i) {
                    ComboLeg comboLeg = (ComboLeg)contract.m_comboLegs.get(i);
                    string = string + " leg " + (i + 1) + ": ";
                    string = string + "conId=" + comboLeg.m_conId;
                    string = string + " ratio=" + comboLeg.m_ratio;
                    string = string + " action=" + comboLeg.m_action;
                    string = string + " exchange=" + comboLeg.m_exchange;
                    string = string + " openClose=" + comboLeg.m_openClose;
                    string = string + " shortSaleSlot=" + comboLeg.m_shortSaleSlot;
                    string = string + " designatedLocation=" + comboLeg.m_designatedLocation;
                    string = string + " exemptCode=" + comboLeg.m_exemptCode;
                    if (order.m_orderComboLegs != null && contract.m_comboLegs.size() == order.m_orderComboLegs.size()) {
                        object = order.m_orderComboLegs.get(i);
                        string = string + " price=" + Util.DoubleMaxString(((OrderComboLeg)object).m_price);
                    }
                    string = string + ";";
                }
            }
            string = string + "}";
            if (order.m_basisPoints != Double.MAX_VALUE) {
                string = string + " basisPoints=" + Util.DoubleMaxString(order.m_basisPoints);
                string = string + " basisPointsType=" + Util.IntMaxString(order.m_basisPointsType);
            }
        }
        if (contract.m_underComp != null) {
            UnderComp underComp = contract.m_underComp;
            string = string + " underComp.conId =" + underComp.m_conId + " underComp.delta =" + underComp.m_delta + " underComp.price =" + underComp.m_price;
        }
        if (!Util.StringIsEmpty(order.m_algoStrategy)) {
            string = string + " algoStrategy=" + order.m_algoStrategy;
            string = string + " algoParams={";
            if (order.m_algoParams != null) {
                Vector<TagValue> vector = order.m_algoParams;
                for (int i = 0; i < vector.size(); ++i) {
                    object = vector.elementAt(i);
                    if (i > 0) {
                        string = string + ",";
                    }
                    string = string + ((TagValue)object).m_tag + "=" + ((TagValue)object).m_value;
                }
            }
            string = string + "}";
        }
        if ("BAG".equals(contract.m_secType)) {
            string = string + " smartComboRoutingParams={";
            if (order.m_smartComboRoutingParams != null) {
                Vector<TagValue> vector = order.m_smartComboRoutingParams;
                for (int i = 0; i < vector.size(); ++i) {
                    object = vector.elementAt(i);
                    if (i > 0) {
                        string = string + ",";
                    }
                    string = string + ((TagValue)object).m_tag + "=" + ((TagValue)object).m_value;
                }
            }
            string = string + "}";
        }
        String string2 = " status=" + orderState.m_status + " initMargin=" + orderState.m_initMargin + " maintMargin=" + orderState.m_maintMargin + " equityWithLoan=" + orderState.m_equityWithLoan + " commission=" + Util.DoubleMaxString(orderState.m_commission) + " minCommission=" + Util.DoubleMaxString(orderState.m_minCommission) + " maxCommission=" + Util.DoubleMaxString(orderState.m_maxCommission) + " commissionCurrency=" + orderState.m_commissionCurrency + " warningText=" + orderState.m_warningText;
        return string + string2;
    }

    public static String openOrderEnd() {
        return " =============== end ===============";
    }

    public static String updateAccountValue(String string, String string2, String string3, String string4) {
        return "updateAccountValue: " + string + " " + string2 + " " + string3 + " " + string4;
    }

    public static String updatePortfolio(Contract contract, int n, double d, double d2, double d3, double d4, double d5, String string) {
        String string2 = "updatePortfolio: " + EWrapperMsgGenerator.contractMsg(contract) + n + " " + d + " " + d2 + " " + d3 + " " + d4 + " " + d5 + " " + string;
        return string2;
    }

    public static String updateAccountTime(String string) {
        return "updateAccountTime: " + string;
    }

    public static String accountDownloadEnd(String string) {
        return "accountDownloadEnd: " + string;
    }

    public static String nextValidId(int n) {
        return "Next Valid Order ID: " + n;
    }

    public static String contractDetails(int n, ContractDetails contractDetails) {
        Contract contract = contractDetails.m_summary;
        String string = "reqId = " + n + " ===================================\n" + " ---- Contract Details begin ----\n" + EWrapperMsgGenerator.contractMsg(contract) + EWrapperMsgGenerator.contractDetailsMsg(contractDetails) + " ---- Contract Details End ----\n";
        return string;
    }

    private static String contractDetailsMsg(ContractDetails contractDetails) {
        String string = "marketName = " + contractDetails.m_marketName + "\n" + "tradingClass = " + contractDetails.m_tradingClass + "\n" + "minTick = " + contractDetails.m_minTick + "\n" + "price magnifier = " + contractDetails.m_priceMagnifier + "\n" + "orderTypes = " + contractDetails.m_orderTypes + "\n" + "validExchanges = " + contractDetails.m_validExchanges + "\n" + "underConId = " + contractDetails.m_underConId + "\n" + "longName = " + contractDetails.m_longName + "\n" + "contractMonth = " + contractDetails.m_contractMonth + "\n" + "industry = " + contractDetails.m_industry + "\n" + "category = " + contractDetails.m_category + "\n" + "subcategory = " + contractDetails.m_subcategory + "\n" + "timeZoneId = " + contractDetails.m_timeZoneId + "\n" + "tradingHours = " + contractDetails.m_tradingHours + "\n" + "liquidHours = " + contractDetails.m_liquidHours + "\n" + "evRule = " + contractDetails.m_evRule + "\n" + "evMultiplier = " + contractDetails.m_evMultiplier + "\n" + EWrapperMsgGenerator.contractDetailsSecIdList(contractDetails);
        return string;
    }

    public static String contractMsg(Contract contract) {
        String string = "conid = " + contract.m_conId + "\n" + "symbol = " + contract.m_symbol + "\n" + "secType = " + contract.m_secType + "\n" + "expiry = " + contract.m_expiry + "\n" + "strike = " + contract.m_strike + "\n" + "right = " + contract.m_right + "\n" + "multiplier = " + contract.m_multiplier + "\n" + "exchange = " + contract.m_exchange + "\n" + "primaryExch = " + contract.m_primaryExch + "\n" + "currency = " + contract.m_currency + "\n" + "localSymbol = " + contract.m_localSymbol + "\n";
        return string;
    }

    public static String bondContractDetails(int n, ContractDetails contractDetails) {
        Contract contract = contractDetails.m_summary;
        String string = "reqId = " + n + " ===================================\n" + " ---- Bond Contract Details begin ----\n" + "symbol = " + contract.m_symbol + "\n" + "secType = " + contract.m_secType + "\n" + "cusip = " + contractDetails.m_cusip + "\n" + "coupon = " + contractDetails.m_coupon + "\n" + "maturity = " + contractDetails.m_maturity + "\n" + "issueDate = " + contractDetails.m_issueDate + "\n" + "ratings = " + contractDetails.m_ratings + "\n" + "bondType = " + contractDetails.m_bondType + "\n" + "couponType = " + contractDetails.m_couponType + "\n" + "convertible = " + contractDetails.m_convertible + "\n" + "callable = " + contractDetails.m_callable + "\n" + "putable = " + contractDetails.m_putable + "\n" + "descAppend = " + contractDetails.m_descAppend + "\n" + "exchange = " + contract.m_exchange + "\n" + "currency = " + contract.m_currency + "\n" + "marketName = " + contractDetails.m_marketName + "\n" + "tradingClass = " + contractDetails.m_tradingClass + "\n" + "conid = " + contract.m_conId + "\n" + "minTick = " + contractDetails.m_minTick + "\n" + "orderTypes = " + contractDetails.m_orderTypes + "\n" + "validExchanges = " + contractDetails.m_validExchanges + "\n" + "nextOptionDate = " + contractDetails.m_nextOptionDate + "\n" + "nextOptionType = " + contractDetails.m_nextOptionType + "\n" + "nextOptionPartial = " + contractDetails.m_nextOptionPartial + "\n" + "notes = " + contractDetails.m_notes + "\n" + "longName = " + contractDetails.m_longName + "\n" + "evRule = " + contractDetails.m_evRule + "\n" + "evMultiplier = " + contractDetails.m_evMultiplier + "\n" + EWrapperMsgGenerator.contractDetailsSecIdList(contractDetails) + " ---- Bond Contract Details End ----\n";
        return string;
    }

    public static String contractDetailsSecIdList(ContractDetails contractDetails) {
        String string = "secIdList={";
        if (contractDetails.m_secIdList != null) {
            Vector<TagValue> vector = contractDetails.m_secIdList;
            for (int i = 0; i < vector.size(); ++i) {
                TagValue tagValue = vector.elementAt(i);
                if (i > 0) {
                    string = string + ",";
                }
                string = string + tagValue.m_tag + "=" + tagValue.m_value;
            }
        }
        string = string + "}\n";
        return string;
    }

    public static String contractDetailsEnd(int n) {
        return "reqId = " + n + " =============== end ===============";
    }

    public static String execDetails(int n, Contract contract, Execution execution) {
        String string = " ---- Execution Details begin ----\nreqId = " + n + "\n" + "orderId = " + execution.m_orderId + "\n" + "clientId = " + execution.m_clientId + "\n" + "symbol = " + contract.m_symbol + "\n" + "secType = " + contract.m_secType + "\n" + "expiry = " + contract.m_expiry + "\n" + "strike = " + contract.m_strike + "\n" + "right = " + contract.m_right + "\n" + "multiplier = " + contract.m_multiplier + "\n" + "contractExchange = " + contract.m_exchange + "\n" + "currency = " + contract.m_currency + "\n" + "localSymbol = " + contract.m_localSymbol + "\n" + "execId = " + execution.m_execId + "\n" + "time = " + execution.m_time + "\n" + "acctNumber = " + execution.m_acctNumber + "\n" + "executionExchange = " + execution.m_exchange + "\n" + "side = " + execution.m_side + "\n" + "shares = " + execution.m_shares + "\n" + "price = " + execution.m_price + "\n" + "permId = " + execution.m_permId + "\n" + "liquidation = " + execution.m_liquidation + "\n" + "cumQty = " + execution.m_cumQty + "\n" + "avgPrice = " + execution.m_avgPrice + "\n" + "orderRef = " + execution.m_orderRef + "\n" + "evRule = " + execution.m_evRule + "\n" + "evMultiplier = " + execution.m_evMultiplier + "\n" + " ---- Execution Details end ----\n";
        return string;
    }

    public static String execDetailsEnd(int n) {
        return "reqId = " + n + " =============== end ===============";
    }

    public static String updateMktDepth(int n, int n2, int n3, int n4, double d, int n5) {
        return "updateMktDepth: " + n + " " + n2 + " " + n3 + " " + n4 + " " + d + " " + n5;
    }

    public static String updateMktDepthL2(int n, int n2, String string, int n3, int n4, double d, int n5) {
        return "updateMktDepth: " + n + " " + n2 + " " + string + " " + n3 + " " + n4 + " " + d + " " + n5;
    }

    public static String updateNewsBulletin(int n, int n2, String string, String string2) {
        return "MsgId=" + n + " :: MsgType=" + n2 + " :: Origin=" + string2 + " :: Message=" + string;
    }

    public static String managedAccounts(String string) {
        return "Connected : The list of managed accounts are : [" + string + "]";
    }

    public static String receiveFA(int n, String string) {
        return "FA: " + EClientSocket.faMsgTypeName(n) + " " + string;
    }

    public static String historicalData(int n, String string, double d, double d2, double d3, double d4, int n2, int n3, double d5, boolean bl) {
        return "id=" + n + " date = " + string + " open=" + d + " high=" + d2 + " low=" + d3 + " close=" + d4 + " volume=" + n2 + " count=" + n3 + " WAP=" + d5 + " hasGaps=" + bl;
    }

    public static String realtimeBar(int n, long l, double d, double d2, double d3, double d4, long l2, double d5, int n2) {
        return "id=" + n + " time = " + l + " open=" + d + " high=" + d2 + " low=" + d3 + " close=" + d4 + " volume=" + l2 + " count=" + n2 + " WAP=" + d5;
    }

    public static String scannerParameters(String string) {
        return "SCANNER PARAMETERS:\n" + string;
    }

    public static String scannerData(int n, int n2, ContractDetails contractDetails, String string, String string2, String string3, String string4) {
        Contract contract = contractDetails.m_summary;
        return "id = " + n + " rank=" + n2 + " symbol=" + contract.m_symbol + " secType=" + contract.m_secType + " expiry=" + contract.m_expiry + " strike=" + contract.m_strike + " right=" + contract.m_right + " exchange=" + contract.m_exchange + " currency=" + contract.m_currency + " localSymbol=" + contract.m_localSymbol + " marketName=" + contractDetails.m_marketName + " tradingClass=" + contractDetails.m_tradingClass + " distance=" + string + " benchmark=" + string2 + " projection=" + string3 + " legsStr=" + string4;
    }

    public static String scannerDataEnd(int n) {
        return "id = " + n + " =============== end ===============";
    }

    public static String currentTime(long l) {
        return "current time = " + l + " (" + DateFormat.getDateTimeInstance().format(new Date(l * 1000L)) + ")";
    }

    public static String fundamentalData(int n, String string) {
        return "id  = " + n + " len = " + string.length() + '\n' + string;
    }

    public static String deltaNeutralValidation(int n, UnderComp underComp) {
        return "id = " + n + " underComp.conId =" + underComp.m_conId + " underComp.delta =" + underComp.m_delta + " underComp.price =" + underComp.m_price;
    }

    public static String tickSnapshotEnd(int n) {
        return "id=" + n + " =============== end ===============";
    }

    public static String marketDataType(int n, int n2) {
        return "id=" + n + " marketDataType = " + MarketDataType.getField(n2);
    }

    public static String commissionReport(CommissionReport commissionReport) {
        String string = "commission report: execId=" + commissionReport.m_execId + " commission=" + Util.DoubleMaxString(commissionReport.m_commission) + " currency=" + commissionReport.m_currency + " realizedPNL=" + Util.DoubleMaxString(commissionReport.m_realizedPNL) + " yield=" + Util.DoubleMaxString(commissionReport.m_yield) + " yieldRedemptionDate=" + Util.IntMaxString(commissionReport.m_yieldRedemptionDate);
        return string;
    }
}

