(ns clj-utils.idbevt
  (:require [flatland.protobuf.core :as pbuf]
;            [com.impdesk.idbevt :as idbevt]
            ))

(import com.impdesk.idbevt.Events$Auction)
(import com.impdesk.idbevt.Events$Bid)

(def Auction (pbuf/protodef Events$Auction))
(def Bid (pbuf/protodef Events$Bid))

(defn parse
  "Parse protobuf message into clojure map"
  [type ; message type
   data ; byte array of data
   ]
  (cond
    (= type :auction) (pbuf/protobuf-load Auction data)
    (= type :bid) (pbuf/protobuf-load Bid data)
    :else (throw (Exception. "Unhandled message type")))
   )

(defn get-auction-data
  [message-type
   map
   ]
  (cond
    (= message-type :auction) map
    (= message-type :bid) (:auction map)
    :else (throw (Exception. "Unhandled message type"))))

