(ns clj-utils.user
  (:require [clojure.data.codec.base64 :as b64]
            [clojure.string :as str]))

(defn user-id-convert
  "Convert user id from bytearray to web safe string"
  ^String [^com.google.protobuf.ByteString$LiteralByteString user-bytes]
  (-> user-bytes
      (.toByteArray)
      ^bytes (b64/encode)
      (String. "UTF-8")
      (str/replace "+" "-")
      (str/replace "/" "_")))

(defn device-id-convert
  "Convert b64 device ID to UUID"
  
  [device-id]
  device-id)


 
