(ns clj-utils.idbevt
  (:require [clojure.set :as set]
            [clj-utils.user :as user]
            [flatland.protobuf.core :as pbuf]))

;; TODO: Add Viewability and Intent defintions to events.proto
(import com.impdesk.idbevt.Events$Auction)
(import com.impdesk.idbevt.Events$AudienceMatch)
(import com.impdesk.idbevt.Events$Bid)
(import com.impdesk.idbevt.Events$Click)
(import com.impdesk.idbevt.Events$Conversion)
(import com.impdesk.idbevt.Events$Pixel)
(import com.impdesk.idbevt.Events$SmartPixel)
(import com.impdesk.idbevt.Events$Impression)
(import com.impdesk.idbevt.Events$Increment)
;; (import com.impdesk.idbevt.Events$Intent)
(import com.impdesk.idbevt.Events$Loss)
;; (import com.impdesk.idbevt.Events$Viewability)
(import com.impdesk.idbevt.Events$Win)

(def Auction (pbuf/protodef Events$Auction))
(def Audience (pbuf/protodef Events$AudienceMatch))
(def Bid (pbuf/protodef Events$Bid))
(def Click (pbuf/protodef Events$Click))
(def Conversion (pbuf/protodef Events$Conversion))
(def Pixel (pbuf/protodef Events$Pixel))
(def SmartPixel (pbuf/protodef Events$SmartPixel))
(def Impression (pbuf/protodef Events$Impression))
(def Increment (pbuf/protodef Events$Increment))
;; (def Intent (pbuf/protodef Events$Intent))
(def Loss (pbuf/protodef Events$Loss))
;; (def Adloox (pbuf/protodef Events$Viewability))
(def Win (pbuf/protodef Events$Win))

(defn parse
  "Parse protobuf message into clojure map"
  [^clojure.lang.Keyword message-type ^bytes raw-pb]
  (cond
    (= message-type :auction) (pbuf/protobuf-load Auction raw-pb)
    (= message-type :audience) (pbuf/protobuf-load Audience raw-pb)
    (= message-type :bid) (pbuf/protobuf-load Bid raw-pb)
    (= message-type :click) (pbuf/protobuf-load Click raw-pb)
    (= message-type :conversion) (pbuf/protobuf-load Conversion raw-pb)
    (= message-type :pixel) (pbuf/protobuf-load Pixel raw-pb)
    (= message-type :smartpix) (pbuf/protobuf-load SmartPixel raw-pb)
    (= message-type :impression) (pbuf/protobuf-load Impression raw-pb)
    (= message-type :inc) (pbuf/protobuf-load Increment raw-pb)
    (= message-type :loss) (pbuf/protobuf-load Loss raw-pb)
    (= message-type :win) (pbuf/protobuf-load Win raw-pb)
    :else (throw (Exception. "Unhandled message type"))))

(defn flatten-record
  "Take a protobuf nested record and recursively flatten.
  =>(let [test {:foo {:bar {:baz 123}} :qux false}]
      (flatten-record test)
  => {:baz 123, :qux false}
  =>
  
  Only recurs further on maps, the input must fit the BSM data structure."
  [^flatland.protobuf.PersistentProtocolBufferMap record]
  (into {}
    (for [[k v] record]
      (if (map? v)
        (flatten-record v)
        {k v}))))

;; Key lookup of protobuf to default values.
(def key-lookup {:ad-group-id :ad_group_id
                 :ad-id :ad_id
                 :adserving-cost :adserving_cost
                 :allowed-vendors :avnd
                 :allowed-video-types :vidt
                 :auction-id :auction_id
                 :bid-host :bid_host
                 :bid-price :bid
                 :city :city
                 :content-language :lang
                 :country :country
                 :creative-id :creative_id
                 :deal-id :deal_id
                 :device-browser :browser
                 :device-os :os
                 :exchange-bid-price :x_price
                 :exchange-currency :x_cur
                 :exchange-id :x_id
                 :exchange-request-id :x_request_id
                 :exchange-user-id :x_user_id
                 :homebiz :homebiz
                 :inv-domain :domain
                 :inv-id :inv_id
                 :ip :ip
                 :isp :isp
                 :keywords :keywords
                 :metro :metro
                 :pace-factor :pfct
                 :position :pos
                 :postal-code :postal_code
                 :rain :wr
                 :region :region
                 :restricted-categories :rcat
                 :restricted-pmp-categories :rcat_pmpd
                 :segments :segments
                 :slot :slot
                 :slots :slots
                 :snow :ws
                 :timestamp :ts
                 :ua :ua
                 :url :url
                 :user-id :user_id
                 :utc-how :how
                 :weather-level :wl})

(defn- try-decode-id
  "Decode a proto id if not a nil value."
  [id]
  (when (some? id)
    (user/user-id-convert id)))

(defn- map-values
  "Apply fn to all keys in m."
  [m keys f]
  (reduce #(update %1 %2 f) m keys))

(defn normalise
  "Takes a raw record and returns a cleaned up ETL object.
  
   This function does no transformations, just normalising
   a protobuf object to a raw ETL map."
  [^clojure.lang.Keyword message-type ^bytes raw-pb]
  (let [record (parse message-type raw-pb)]
    (-> record
      (flatten-record)
      (set/rename-keys key-lookup)
      (map-values [:user_id :auction_id :device_id] try-decode-id))))
