(ns clj-utils.idbevt
  (:require [clojure.set :as set]
            [clj-utils.user :as user]
            [flatland.protobuf.core :as pbuf]))

;; TODO: Add Viewability and Intent defintions to events.proto
(import com.impdesk.idbevt.Events$Auction)
(import com.impdesk.idbevt.Events$AudienceMatch)
(import com.impdesk.idbevt.Events$Bid)
(import com.impdesk.idbevt.Events$Click)
(import com.impdesk.idbevt.Events$Conversion)
(import com.impdesk.idbevt.Events$Pixel)
(import com.impdesk.idbevt.Events$SmartPixel)
(import com.impdesk.idbevt.Events$Impression)
(import com.impdesk.idbevt.Events$Increment)
(import com.impdesk.idbevt.Events$Interest)
(import com.impdesk.idbevt.Events$Loss)
;; (import com.impdesk.idbevt.Events$Viewability)
(import com.impdesk.idbevt.Events$Win)

(def Auction (pbuf/protodef Events$Auction))
(def Audience (pbuf/protodef Events$AudienceMatch))
(def Bid (pbuf/protodef Events$Bid))
(def Click (pbuf/protodef Events$Click))
(def Conversion (pbuf/protodef Events$Conversion))
(def Pixel (pbuf/protodef Events$Pixel))
(def SmartPixel (pbuf/protodef Events$SmartPixel))
(def Impression (pbuf/protodef Events$Impression))
(def Increment (pbuf/protodef Events$Increment))
(def Interest (pbuf/protodef Events$Interest))
(def Loss (pbuf/protodef Events$Loss))
;; (def Adloox (pbuf/protodef Events$Viewability))
(def Win (pbuf/protodef Events$Win))

(defn parse
  "Parse protobuf message into clojure map"
  [^clojure.lang.Keyword message-type ^bytes raw-pb]
  (cond
    (= message-type :auction) (pbuf/protobuf-load Auction raw-pb)
    (= message-type :audience) (pbuf/protobuf-load Audience raw-pb)
    (= message-type :bid) (pbuf/protobuf-load Bid raw-pb)
    (= message-type :click) (pbuf/protobuf-load Click raw-pb)
    (= message-type :conversion) (pbuf/protobuf-load Conversion raw-pb)
    (= message-type :pixel) (pbuf/protobuf-load Pixel raw-pb)
    (= message-type :smartpix) (pbuf/protobuf-load SmartPixel raw-pb)
    (= message-type :impression) (pbuf/protobuf-load Impression raw-pb)
    (= message-type :inc) (pbuf/protobuf-load Increment raw-pb)
    (= message-type :loss) (pbuf/protobuf-load Loss raw-pb)
    (= message-type :win) (pbuf/protobuf-load Win raw-pb)
    (= message-type :interest) (pbuf/protobuf-load Interest raw-pb)
    :else (throw (Exception. "Unhandled message type"))))

;; Key lookup of protobuf to default values.
(def key-lookup {:ad-group-id :ad_group_id
                 :ad-id :ad_id
                 :adserving-cost :adserving_cost
                 :advertiser-id :advertiser_id
                 :allowed-vendors :avnd
                 :allowed-video-types :vidt
                 :auction-id :auction_id
                 :auction-ip :auction_ip
                 :bid-host :bid_host
                 :bid-price :bid
                 :bid-device-id :bid_device_id
                 :bid-user-id :bid_user_id
                 :blocked-properties :bprop
                 :browser-os :browser_os
                 :content-language :lang
                 :context :ctx
                 :creative-id :creative_id
                 :data-cost-cpm :data_cost_cpm
                 :deal-id :deal_id
                 :device-type :device
                 :device-browser :browser
                 :device-id :device_id
                 :device-os :os
                 :exchange-bid-price :x_price
                 :exchange-currency :x_cur
                 :exchange-id :x_id
                 :exchange-request-id :x_request_id
                 :exchange-user-id :x_user_id
                 :excluded-attrs :ex_attrs
                 :floor-price :floor
                 :gross-win-price :gross_price
                 :id :pub_id
                 :inv-domain :domain
                 :inv-id :inv_id
                 :inv-type :inv_type
                 :inv-name :inv_name
                 :inv-rating :inv_rating
                 :inv-placement-id :x_pmnt_id
                 :is-secure :ssl
                 :keywords :kw
                 :market-price :market_price
                 :market-price-votes :market_price_votes
                 :market-price-variance :market_price_var
                 :metric :m
                 :name :pub_name
                 :opt-group-id :ogid
                 :pace-factor :pfct
                 :pmp-deal :pmpd
                 :position :pos
                 :postal-code :postal_code
                 :rain :wr
                 :restricted-categories :rcat
                 :restricted-pmp-categories :rcat_pmpd
                 :seen-before :seen
                 :snow :ws
                 :src-timestamp :source_ts
                 :timestamp :ts
                 :user-id :user_id
                 :utc-how :how
                 :video-player-size :vidsz
                 :win-price :price
                 :win-host :win_host
                 :weather-level :wl})

(defn- try-decode-id
  "Decode a proto id if not a nil value."
  [^bytes id]
  (when (some? id)
    (user/user-id-convert id)))

(defn- map-values
  "Apply fn to all keys in m."
  [m keys f]
  (reduce #(update %1 %2 f) m keys))

(defn flatten-record
  [^flatland.protobuf.PersistentProtocolBufferMap record]
  (reduce
    (fn [a [k v]]
      (if (map? v)
        (into a (flatten-record v))
        (conj a (clojure.lang.MapEntry. (key-lookup k k) v))))
    []
    record))

(defn flat-comp
  [^flatland.protobuf.PersistentProtocolBufferMap record]
  (into {} (flatten-record record)))

(defn normalise
  "Takes a raw record and returns a cleaned up ETL object.

   This function does no transformations, just normalising
   a protobuf object to a raw ETL map."
  [^clojure.lang.Keyword message-type ^bytes raw-pb]
  (let [record (parse message-type raw-pb)
        fltrec (flat-comp record)]
    (map-values fltrec [:user_id :auction_id :device_id] try-decode-id)))
