/*
 * Decompiled with CFR 0.152.
 */
package com.instrument.triface;

import com.instrument.triface.IObjectFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSObjectFactory
implements IObjectFactory {
    protected final Context context = Context.enter();
    protected final Scriptable scriptable = new ImporterTopLevel(this.context);
    protected Class interfaceType;
    protected String scriptName;
    protected List<String> searchPaths;

    public JSObjectFactory(Class interfaceType, String scriptName) {
        this.interfaceType = interfaceType;
        this.scriptName = scriptName;
        this.searchPaths = new ArrayList<String>();
    }

    @Override
    public Object createObject() {
        Object generator = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.resolveScriptPath(this.scriptName)));
            Script script = this.context.compileReader((Reader)reader, "source", 0, null);
            Object object = script.exec(this.context, this.scriptable);
            generator = Context.jsToJava((Object)object, (Class)this.interfaceType);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + this.interfaceType + " object from: " + this.scriptName, e);
        }
        return generator;
    }

    protected String resolveScriptPath(String scriptName) {
        for (String path : this.searchPaths) {
            String filePath = path + "/" + scriptName + ".js";
            if (!new File(filePath).isFile()) continue;
            return filePath;
        }
        return "";
    }

    @Override
    public void addLoadPath(String path) {
        this.searchPaths.add(path);
    }

    @Override
    public void addLoadPaths(List<String> paths) {
        this.searchPaths.addAll(paths);
    }
}

