/*
 * Decompiled with CFR 0.152.
 */
package com.instrument.triface.util;

import clojure.lang.IPersistentList;
import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.PersistentList;
import com.instrument.triface.util.ITypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.mozilla.javascript.NativeArray;
import org.python.core.PyDictionary;
import org.python.core.PyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClojureTypeUtils
implements ITypeUtils {
    private static final ITypeUtils.Function<Object, Object> MAP_TO_PERSISTENTHASHMAP = new ITypeUtils.Function<Object, Object>(){

        @Override
        public IPersistentMap apply(Object in) {
            return PersistentHashMap.create((Map)((Map)in));
        }
    };
    private static final ITypeUtils.Function<Object, Object> LIST_TO_PERSISTENTLIST = new ITypeUtils.Function<Object, Object>(){

        @Override
        public IPersistentList apply(Object in) {
            return PersistentList.create((List)((List)in));
        }
    };
    private static final ITypeUtils.Function<Object, Object> RUBYARRAY_TO_PERSISTENTLIST = new ITypeUtils.Function<Object, Object>(){

        @Override
        public IPersistentList apply(Object in) {
            PersistentList pl = (PersistentList)PersistentList.create((List)((List)in));
            return pl.pop();
        }
    };
    private static final ITypeUtils.Function<Object, Object> NATIVEARRAY_TO_PERSISTENTLIST = new ITypeUtils.Function<Object, Object>(){

        @Override
        public IPersistentList apply(Object in) {
            NativeArray arr = (NativeArray)in;
            ArrayList<Object> list = new ArrayList<Object>((int)arr.getLength());
            for (Object o : arr.getIds()) {
                int index = (Integer)o;
                list.add(index, arr.get(index, null));
            }
            PersistentList pl = (PersistentList)PersistentList.create(list);
            return pl;
        }
    };
    private static final Map<Class<?>, ITypeUtils.Function<Object, Object>> CLOJURE_CONVERSION_MAP = ClojureTypeUtils.buildClojureConversionMap();

    public static Object convert(Object o) {
        if (CLOJURE_CONVERSION_MAP.containsKey(o.getClass())) {
            return ClojureTypeUtils.transform(o, CLOJURE_CONVERSION_MAP.get(o.getClass()));
        }
        return o;
    }

    private static <F, T> Object transform(F from, ITypeUtils.Function<? super F, ? extends T> func) {
        return func.apply(from);
    }

    public static boolean hasConversion(Object o) {
        return CLOJURE_CONVERSION_MAP.containsKey(o.getClass());
    }

    private static Map<Class<?>, ITypeUtils.Function<Object, Object>> buildClojureConversionMap() {
        HashMap map = new HashMap();
        map.put(PyDictionary.class, MAP_TO_PERSISTENTHASHMAP);
        map.put(PyList.class, LIST_TO_PERSISTENTLIST);
        map.put(RubyHash.class, MAP_TO_PERSISTENTHASHMAP);
        map.put(RubyArray.class, RUBYARRAY_TO_PERSISTENTLIST);
        map.put(NativeArray.class, NATIVEARRAY_TO_PERSISTENTLIST);
        map.put(HashMap.class, MAP_TO_PERSISTENTHASHMAP);
        return map;
    }
}

