/*
 * Decompiled with CFR 0.152.
 */
package com.instrument.triface.template;

import com.instrument.triface.template.renderer.ERBTemplateRenderer;
import com.instrument.triface.template.renderer.FreemarkerTemplateRenderer;
import com.instrument.triface.template.renderer.ITrifaceTemplateRenderer;
import com.instrument.triface.template.renderer.JinjaTemplateRenderer;
import com.instrument.triface.util.FileUtils;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrifaceTemplateEngine {
    private static ITrifaceTemplateRenderer freemarkerEngine;
    private static ITrifaceTemplateRenderer ERBEngine;
    private static ITrifaceTemplateRenderer jinjaEngine;
    private File baseTemplateDirectory;

    public TrifaceTemplateEngine() {
    }

    public TrifaceTemplateEngine(File baseTemplateDirectory) {
        this.baseTemplateDirectory = baseTemplateDirectory;
    }

    public String render(Map<Object, Object> objectMap, File template) {
        ITrifaceTemplateRenderer renderer = null;
        String extension = FileUtils.getFileExtension(template);
        if (extension.equalsIgnoreCase(".rb")) {
            if (ERBEngine == null) {
                ERBEngine = new ERBTemplateRenderer();
            }
            renderer = ERBEngine;
        } else if (extension.equalsIgnoreCase(".py")) {
            if (jinjaEngine == null) {
                jinjaEngine = new JinjaTemplateRenderer();
            }
            renderer = jinjaEngine;
        } else if (extension.equalsIgnoreCase(".ftl")) {
            if (freemarkerEngine == null) {
                freemarkerEngine = new FreemarkerTemplateRenderer(this.baseTemplateDirectory);
            }
            renderer = freemarkerEngine;
        }
        if (renderer != null) {
            return renderer.render(objectMap, template);
        }
        return null;
    }

    public void setBaseTemplateDirectory(File baseTemplateDirectory) {
        this.baseTemplateDirectory = baseTemplateDirectory;
    }
}

