/*
 * Decompiled with CFR 0.152.
 */
package com.instrument.triface.template.renderer;

import com.instrument.triface.template.renderer.ITrifaceTemplateRenderer;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerTemplateRenderer
implements ITrifaceTemplateRenderer {
    private Configuration cfg;
    private File baseTemplateDirectory;

    public FreemarkerTemplateRenderer(File baseTemplateDirectory) {
        try {
            this.baseTemplateDirectory = baseTemplateDirectory;
            this.cfg = new Configuration();
            this.cfg.setDirectoryForTemplateLoading(baseTemplateDirectory);
            this.cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String render(Map<Object, Object> objectMap, File template) {
        StringWriter writer = new StringWriter();
        try {
            Template temp = this.cfg.getTemplate(this.calculateTemplateName(template));
            temp.process(objectMap, (Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    private String calculateTemplateName(File template) {
        return template.getPath().replace(this.baseTemplateDirectory.getPath() + "/", "");
    }
}

