# Component-HTTP-Kit

A [component][1] for an [HTTP Kit][2] [Ring][3] adapter, for use in
applications that use Stuart Sierra's [reloaded workflow][4].

[1]: https://github.com/stuartsierra/component
[2]: https://github.com/http-kit/http-kit
[3]: https://github.com/ring-clojure/ring
[4]: http://thinkrelevance.com/blog/2013/06/04/clojure-workflow-reloaded


## Installation

Add the following dependency to your `project.clj`:

```clojure
[com.invisiblefriend.component/http-kit "0.1.0"]
```


## Example

```clojure
(ns microservice
  (:require [com.invisiblefriend.component.http-kit :refer [http-kit-server]]
            [com.stuartsierra.component :as component]
            [compojure.core :refer [defroutes GET]]))

(defroutes routes
  (GET "*" [req]
    {:status  200
     :headers {"Content-Type" "text/plain"}
     :body    "Hello World"}))
```

After wrapping the app component...

```clojure
(defn wrap-app-component [handler app]
  (fn [request]
    (handler (assoc request ::app app))))

(defn make-handler [app]
  (-> routes
      (wrap-app-component app)))
```

... the value of `req` will look something like:

```clojure
{#_...
 :microservice/user {:component "app"
                     :db {:component "db"}}
 #_...}
```

The `options` must contain the key `:make-handler` which maps to a function that
returns a Ring hander. All other options are passed to the Ring HTTP Kit adapter.

```clojure
(defn make-system [options]
  (component/system-map
    :db  {:component "database"}             ; database component, et cetera
    :app (component/using {:component "app"} ; app component...
	       [:db])                            ; ... with dependencies
    :web (http-kit-server options)))

(def the-options
  {:make-handler make-handler
   :port         3000})

(defn -main [& args]
  (component/start (make-system the-options)))
```

For more information on how to use components, and how they're useful, refer to
Stuart Sierra's [Component library][1].


## Acknowledgments

This README and the general style of the component borrow heavily from James Reeves's
[ring-jetty-component][5], for at least the following reasons:

1. There's no need to [reinvent the wheel][6].
2. Ring-Jetty-Component is well-designed and aligns with our ideology.

It also incorporates the `make-handler` idea from ["Components: Just Enough Structure"][7].

[7]: https://www.youtube.com/watch?v=13cmHf_kt-Q


Many thanks to [James Reeves][8] and [Stuart Sierra][9] for their contributions to the Clojure community.

[5]: https://github.com/weavejester/ring-jetty-component
[6]: http://blog.codinghorror.com/dont-reinvent-the-wheel-unless-you-plan-on-learning-more-about-wheels/
[8]: https://github.com/weavejester
[9]: https://github.com/stuartsierra


## License

Copyright © 2015 invisible friend

Distributed under the MIT License.
