(ns com.invisiblefriend.component.http-kit
  "Provides an HTTP Kit component."
  (:require [com.stuartsierra.component :as component]
            [org.httpkit.server :refer [run-server]]))

(defrecord HTTPKitServer [app handler server]
  component/Lifecycle
  (start [component]
    (if (and server handler)
      component
      (let [options (-> component (dissoc :app :make-handler :server))
            handler ((:make-handler component) app)
            server  (run-server handler options)]
        (println "Listening on port" (:port options))
        (assoc component :handler handler :server server))))
  (stop [component]
    (if-not (or server handler)
      component
      (do (server :timeout 100)
          (dissoc component :handler :server)))))

(defn http-kit-server
  "Creates and returns an HTTP Kit server component from a map of options.
  **Required**: `{:make-handler \"a function that returns a Ring a handler\"}`"
  [options]
  {:pre  [((every-pred map? (comp fn? :make-handler)) options)]}
  (component/using (map->HTTPKitServer options)
    [:app]))
