(ns com.invisiblefriend.component.redis
  "Provides a Redis component."
  (:require [com.stuartsierra.component :as component]
            [taoensso.carmine :as car])
  (:import (java.net ConnectException)))

(defrecord Redis [db host password port timeout-ms uri]
  component/Lifecycle
  (start [component]
    (if (:spec component)
      component
      (let [defaults {:host "127.0.0.1" :port 6379}
            spec     (select-keys component
                                  [:db :host :password :port :timeout-ms :uri])
            spec     (apply dissoc spec (for [[k v] spec :when (nil? v)] k))
            spec     (merge defaults spec)
            client   (assoc component :spec spec)]
        (doto client (car/wcar (car/ping))))))
  (stop [component]
    (if-not (:spec component)
      component
      nil)))

(defn new-redis-client
  "Creates and returns a Redis client component from a map of options.
  See [`#'carmine.core/wcar`][1] for options.

  [1]: http://ptaoussanis.github.io/carmine/taoensso.carmine.html#var-wcar"
  [spec]
  (map->Redis spec))
