(ns betfairsports.account
  (:require   [betfairsports.network :as net]))

(def ^{:dynamic true} *handle-error* (fn [error msg] (println (str "Error: " error " Message: " msg))))

(defn do-api-ng-cert-login 
  [keystorepath keystorepass username password]
  ;; application/x-www-form-urlencoded
  (binding [com.jamiei.betfairsports.network/*options* {:form-params {:username username :password password}
                                                                                    :keystore keystorepath
                                                                                    :keystore-padd keystorepass}]
    (let [headers (net/get-auth-headers)
          headers-with-accept (conj headers "Accept" "application/json")
           resp (net/do-post "https://identitysso-api.betfair.com/api/certlogin" "" headers-with-accept)]
      resp)))

(defn do-api-ng-keep-alive 
  []
  (let [headers (net/get-auth-headers)
          headers-with-accept (conj headers "Accept" "application/json")
          resp (net/do-get "https://identitysso.betfair.com/api/keepAlive" {} headers-with-accept)]
    (= "SUCCESS" (resp :status))))

(defn do-api-ng-logout
  []
  (let [headers (net/get-auth-headers)
          headers-with-accept (conj headers "Accept" "application/json")
          resp (net/do-get "https://identitysso.betfair.com/api/logout" {} headers-with-accept)]
    (= "SUCCESS" (resp :status)))
  )