/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.iter;

import com.google.ical.iter.Generator;
import com.google.ical.iter.IntSet;
import com.google.ical.iter.ThrottledGenerator;
import com.google.ical.iter.Util;
import com.google.ical.util.DTBuilder;
import com.google.ical.util.TimeUtils;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.util.Arrays;

final class Generators {
    private static final int MAX_YEARS_BETWEEN_INSTANCES = 100;

    static ThrottledGenerator serialYearGenerator(final int interval, final DateValue dtStart) {
        return new ThrottledGenerator(){
            int year;
            int throttle;
            {
                this.year = dtStart.year() - interval;
                this.throttle = 100;
            }

            boolean generate(DTBuilder builder) throws Generator.IteratorShortCircuitingException {
                if (--this.throttle < 0) {
                    throw Generator.IteratorShortCircuitingException.instance();
                }
                builder.year = this.year += interval;
                return true;
            }

            void workDone() {
                this.throttle = 100;
            }

            public String toString() {
                return "serialYearGenerator:" + interval;
            }
        };
    }

    static Generator serialMonthGenerator(final int interval, final DateValue dtStart) {
        return new Generator(){
            int year;
            int month;
            {
                this.year = dtStart.year();
                this.month = dtStart.month() - interval;
                while (this.month < 1) {
                    this.month += 12;
                    --this.year;
                }
            }

            boolean generate(DTBuilder builder) {
                int nmonth;
                if (this.year != builder.year) {
                    int monthsBetween = (builder.year - this.year) * 12 - (this.month - 1);
                    nmonth = (interval - monthsBetween % interval) % interval + 1;
                    if (nmonth > 12) {
                        return false;
                    }
                    this.year = builder.year;
                } else {
                    nmonth = this.month + interval;
                    if (nmonth > 12) {
                        return false;
                    }
                }
                this.month = builder.month = nmonth;
                return true;
            }

            public String toString() {
                return "serialMonthGenerator:" + interval;
            }
        };
    }

    static Generator serialDayGenerator(final int interval, final DateValue dtStart) {
        return new Generator(){
            int year;
            int month;
            int date;
            int nDays;
            {
                DTBuilder dtStartMinus1B = new DTBuilder(dtStart);
                dtStartMinus1B.day -= interval;
                DateValue dtStartMinus1 = dtStartMinus1B.toDate();
                this.year = dtStartMinus1.year();
                this.month = dtStartMinus1.month();
                this.date = dtStartMinus1.day();
                this.nDays = TimeUtils.monthLength(this.year, this.month);
            }

            boolean generate(DTBuilder builder) {
                int ndate;
                if (this.year == builder.year && this.month == builder.month) {
                    ndate = this.date + interval;
                    if (ndate > this.nDays) {
                        return false;
                    }
                } else {
                    this.nDays = TimeUtils.monthLength(builder.year, builder.month);
                    if (interval != 1) {
                        int daysBetween = TimeUtils.daysBetween(new DateValueImpl(builder.year, builder.month, 1), new DateValueImpl(this.year, this.month, this.date));
                        ndate = (interval - daysBetween % interval) % interval + 1;
                        if (ndate > this.nDays) {
                            return false;
                        }
                    } else {
                        ndate = 1;
                    }
                    this.year = builder.year;
                    this.month = builder.month;
                }
                this.date = builder.day = ndate;
                return true;
            }

            public String toString() {
                return "serialDayGenerator:" + interval;
            }
        };
    }

    static Generator byYearGenerator(int[] years, final DateValue dtStart) {
        final int[] uyears = Util.uniquify(years);
        return new Generator(){
            int i;
            {
                while (this.i < uyears.length && dtStart.year() > uyears[this.i]) {
                    ++this.i;
                }
            }

            boolean generate(DTBuilder builder) {
                if (this.i >= uyears.length) {
                    return false;
                }
                builder.year = uyears[this.i++];
                return true;
            }

            public String toString() {
                return "byYearGenerator";
            }
        };
    }

    static Generator byMonthGenerator(int[] months, final DateValue dtStart) {
        final int[] umonths = Util.uniquify(months);
        return new Generator(){
            int i;
            int year;
            {
                this.year = dtStart.year();
            }

            boolean generate(DTBuilder builder) {
                if (this.year != builder.year) {
                    this.i = 0;
                    this.year = builder.year;
                }
                if (this.i >= umonths.length) {
                    return false;
                }
                builder.month = umonths[this.i++];
                return true;
            }

            public String toString() {
                return "byMonthGenerator";
            }
        };
    }

    static Generator byMonthDayGenerator(int[] dates, final DateValue dtStart) {
        final int[] udates = Util.uniquify(dates);
        return new Generator(){
            int year;
            int month;
            int[] posDates;
            int i;
            {
                this.year = dtStart.year();
                this.month = dtStart.month();
                this.i = 0;
                this.convertDatesToAbsolute();
            }

            private void convertDatesToAbsolute() {
                IntSet posDates = new IntSet();
                int nDays = TimeUtils.monthLength(this.year, this.month);
                for (int j = 0; j < udates.length; ++j) {
                    int date = udates[j];
                    if (date < 0) {
                        date += nDays + 1;
                    }
                    if (date < 1 || date > nDays) continue;
                    posDates.add(date);
                }
                this.posDates = posDates.toIntArray();
            }

            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    this.year = builder.year;
                    this.month = builder.month;
                    this.convertDatesToAbsolute();
                    this.i = 0;
                }
                if (this.i >= this.posDates.length) {
                    return false;
                }
                builder.day = this.posDates[this.i++];
                return true;
            }

            public String toString() {
                return "byMonthDayGenerator";
            }
        };
    }

    static Generator byDayGenerator(WeekdayNum[] days, final boolean weeksInYear, final DateValue dtStart) {
        final WeekdayNum[] udays = (WeekdayNum[])days.clone();
        return new Generator(){
            int year;
            int month;
            int[] dates;
            int i;
            {
                this.year = dtStart.year();
                this.month = dtStart.month();
                this.i = 0;
                this.generateDates();
            }

            void generateDates() {
                int d0;
                Weekday dow0;
                int nDays;
                int nDaysInMonth = TimeUtils.monthLength(this.year, this.month);
                if (weeksInYear) {
                    nDays = TimeUtils.yearLength(this.year);
                    dow0 = Weekday.firstDayOfWeekInMonth(this.year, 1);
                    d0 = TimeUtils.dayOfYear(this.year, this.month, 1);
                } else {
                    nDays = nDaysInMonth;
                    dow0 = Weekday.firstDayOfWeekInMonth(this.year, this.month);
                    d0 = 0;
                }
                int w0 = d0 / 7;
                IntSet udates = new IntSet();
                for (int j = 0; j < udays.length; ++j) {
                    WeekdayNum day = udays[j];
                    if (0 != day.num) {
                        int date = Util.dayNumToDate(dow0, nDays, day.num, day.wday, d0, nDaysInMonth);
                        if (0 == date) continue;
                        udates.add(date);
                        continue;
                    }
                    int wn = w0 + 6;
                    for (int w = w0; w <= wn; ++w) {
                        int date = Util.dayNumToDate(dow0, nDays, w, day.wday, d0, nDaysInMonth);
                        if (0 == date) continue;
                        udates.add(date);
                    }
                }
                this.dates = udates.toIntArray();
            }

            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    this.year = builder.year;
                    this.month = builder.month;
                    this.generateDates();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                builder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byDayGenerator:" + Arrays.toString(udays);
            }
        };
    }

    static Generator byWeekNoGenerator(int[] weekNos, final Weekday wkst, final DateValue dtStart) {
        final int[] uWeekNos = Util.uniquify(weekNos);
        return new Generator(){
            int year;
            int month;
            int weeksInYear;
            int[] dates;
            int i;
            int doyOfStartOfWeek1;
            {
                this.year = dtStart.year();
                this.month = dtStart.month();
                this.i = 0;
                this.checkYear();
                this.checkMonth();
            }

            void checkYear() {
                Weekday dowJan1 = Weekday.firstDayOfWeekInMonth(this.year, 1);
                int nDaysInFirstWeek = 7 - (7 + dowJan1.javaDayNum - wkst.javaDayNum) % 7;
                int nOrphanedDays = 0;
                if (nDaysInFirstWeek < 4) {
                    nOrphanedDays = nDaysInFirstWeek;
                    nDaysInFirstWeek = 7;
                }
                this.doyOfStartOfWeek1 = nDaysInFirstWeek - 7 + nOrphanedDays;
                this.weeksInYear = (TimeUtils.yearLength(this.year) - nOrphanedDays + 6) / 7;
            }

            void checkMonth() {
                int doyOfMonth1 = TimeUtils.dayOfYear(this.year, this.month, 1);
                int weekOfMonth = (doyOfMonth1 - this.doyOfStartOfWeek1) / 7 + 1;
                int nDays = TimeUtils.monthLength(this.year, this.month);
                IntSet udates = new IntSet();
                for (int j = 0; j < uWeekNos.length; ++j) {
                    int weekNo = uWeekNos[j];
                    if (weekNo < 0) {
                        weekNo += this.weeksInYear + 1;
                    }
                    if (weekNo < weekOfMonth - 1 || weekNo > weekOfMonth + 6) continue;
                    for (int d = 0; d < 7; ++d) {
                        int date = (weekNo - 1) * 7 + d + this.doyOfStartOfWeek1 - doyOfMonth1 + 1;
                        if (date < 1 || date > nDays) continue;
                        udates.add(date);
                    }
                }
                this.dates = udates.toIntArray();
            }

            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    if (this.year != builder.year) {
                        this.year = builder.year;
                        this.checkYear();
                    }
                    this.month = builder.month;
                    this.checkMonth();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                builder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byWeekNoGenerator";
            }
        };
    }

    static Generator byYearDayGenerator(int[] yearDays, final DateValue dtStart) {
        final int[] uYearDays = Util.uniquify(yearDays);
        return new Generator(){
            int year;
            int month;
            int[] dates;
            int i;
            {
                this.year = dtStart.year();
                this.month = dtStart.month();
                this.i = 0;
                this.checkMonth();
            }

            void checkMonth() {
                int doyOfMonth1 = TimeUtils.dayOfYear(this.year, this.month, 1);
                int nDays = TimeUtils.monthLength(this.year, this.month);
                int nYearDays = TimeUtils.yearLength(this.year);
                IntSet udates = new IntSet();
                for (int j = 0; j < uYearDays.length; ++j) {
                    int date;
                    int yearDay = uYearDays[j];
                    if (yearDay < 0) {
                        yearDay += nYearDays + 1;
                    }
                    if ((date = yearDay - doyOfMonth1) < 1 || date > nDays) continue;
                    udates.add(date);
                }
                this.dates = udates.toIntArray();
            }

            boolean generate(DTBuilder builder) {
                if (this.year != builder.year || this.month != builder.month) {
                    this.year = builder.year;
                    this.month = builder.month;
                    this.checkMonth();
                    this.i = 0;
                }
                if (this.i >= this.dates.length) {
                    return false;
                }
                builder.day = this.dates[this.i++];
                return true;
            }

            public String toString() {
                return "byYearDayGenerator";
            }
        };
    }

    private Generators() {
    }
}

