(ns com.kahui.spiders.app
  (:require [clojure.string :as string]
            [com.kahui.spiders.dianping.commands :as dianping-cmds])
  (:use [clojure.tools.logging :only (debug info error warn)]
        [clojure.tools.cli :as cli])
  (:gen-class))

(def action-handlers)

(defn usage
  [_]
  (println (string/join "" (repeat 10 "-")))
  (println "sub commands:")
  (doseq [[k v] action-handlers]
    (let [desc (:desc v)]
      (println k ":" desc))))

(def action-handlers (apply array-map ["dianping-down-store" {:handler dianping-cmds/spider-dianping-store :desc "下载大众点评数据"}
                                       "dianping-put-store-es" {:handler dianping-cmds/put-dianping-store-es :desc "将点评商户写入ES"}
                                       "merge-file" {:handler dianping-cmds/merge-file :desc "合并文件"}
                                       "list-store-id" {:handler dianping-cmds/list-store-id :desc "读取shop id"}
                                       "merge-file-avro" {:handler dianping-cmds/merge-file-avro :desc "将小文件合并到avro文件中"}
                                       "parse-failed-id" {:handler dianping-cmds/parse-failed-id :desc "解析失败的ID"}
                                       "next-dp-id-range" {:handler dianping-cmds/next-dp-id-range :desc "对比点评的最新ID和卡惠已经抓取的最大ID,取得要抓取的点评id区间"}
                                       "help" {:handler usage :desc "帮助"}]))

(defn -main
  [& args]
  (let [action (first args)
        sub-args (rest args)]
    (try
      (info "Run action " action " with args " (string/join " " sub-args))
      (if-let [handler (:handler (action-handlers action))]
        (handler sub-args)
        (do
          (println (str "Not action match :'" action "'"))
          (usage action-handlers)
          (System/exit 1)))
      (info "Finish")
      (catch Exception e
        (error e "Run action fail")
        (usage action-handlers)
        (System/exit 1)))
    (System/exit 0)))

