package com.kahui.spiders.proxy;

import java.util.concurrent.atomic.AtomicLong;

/**
 * User: dongyong.wang@renren-inc.com
 */
public class Proxy {
    private final String host;
    private final int port;
    private final String id;
    private final long lastUseTime;
    private final String user;
    private final String password;
    private final String sessionId;
    private final AtomicLong errCount;
    private final AtomicLong usedCount;


    public Proxy(String host, int port, long lastUseTime) {
        this(host, port, lastUseTime, null, null, null);
    }

    public Proxy(String host, int port, long lastUseTime, String user, String password, String sessionId) {
        this(host, port, lastUseTime, user, password, sessionId, new AtomicLong(0), new AtomicLong(0));
    }

    public Proxy(String host, int port, long lastUseTime, String user, String password, String sessionId, AtomicLong errCount, AtomicLong usedCount) {
        this.host = host;
        this.port = port;
        this.lastUseTime = lastUseTime;
        this.id = this.host + ":" + this.port;
        this.user = user;
        this.password = password;
        this.sessionId = sessionId;
        this.errCount = errCount;
        this.usedCount = usedCount;
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return host;
    }

    public int getPort() {
        return port;
    }

    public long getLastUseTime() {
        return lastUseTime;
    }

    public String getUser() {
        return user;
    }

    public String getPassword() {
        return password;
    }

    public String getSessionId() {
        return sessionId;
    }

    public AtomicLong getErrCount() {
        return errCount;
    }

    public AtomicLong getUsedCount() {
        return usedCount;
    }

    public void incrementErrorCount() {
        this.errCount.incrementAndGet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Proxy proxy = (Proxy) o;

        if (!id.equals(proxy.id)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public String toString() {
        return "Proxy{" +
                "host='" + host + '\'' +
                ", port=" + port +
                ", id='" + id + '\'' +
                ", lastUseTime=" + lastUseTime +
                ", user='" + user + '\'' +
                ", password='" + password + '\'' +
                ", sessionId='" + sessionId + '\'' +
                '}';
    }
}
