(ns garden-libs.purecss.core
  (:require [garden.stylesheet]
            [garden.units]
            [garden.core]
            [garden.def]))

(garden.def/defstyles base ["html" {:font-family "sans-serif"} {:-ms-text-size-adjust "100%"} {:-webkit-text-size-adjust "100%"}] ["body" {:margin "0"}] ["article" "aside" "details" "figcaption" "figure" "footer" "header" "hgroup" "main" "menu" "nav" "section" "summary" {:display "block"}] ["audio" "canvas" "progress" "video" {:display "inline-block"} {:vertical-align "baseline"}] ["audio:not([controls])" {:display "none"} {:height "0"}] ["[hidden]" "template" {:display "none"}] ["a" {:background-color "transparent"} ["&:active" "&:hover" {:outline "0"}]] ["abbr[title]" {:border-bottom "1px dotted"}] ["b" "strong" {:font-weight "bold"}] ["dfn" {:font-style "italic"}] ["h1" {:font-size "2em"} {:margin "0.67em 0"}] ["mark" {:background "#ff0"} {:color "#000"}] ["small" {:font-size "80%"}] ["sub" {:font-size "75%"} {:line-height "0"} {:position "relative"} {:vertical-align "baseline"}] ["sup" {:font-size "75%"} {:line-height "0"} {:position "relative"} {:vertical-align "baseline"} {:top "-0.5em"}] ["sub" {:bottom "-0.25em"}] ["img" {:border "0"}] ["svg:not(:root)" {:overflow "hidden"}] ["figure" {:margin "1em 40px"}] ["hr" {:box-sizing "content-box"} {:height "0"}] ["pre" {:overflow "auto"}] ["code" "kbd" "pre" "samp" {:font-family "monospace, monospace"} {:font-size "1em"}] ["button" "input" "optgroup" "select" "textarea" {:color "inherit"} {:font "inherit"} {:margin "0"}] ["button" {:overflow "visible"} {:text-transform "none"}] ["select" {:text-transform "none"}] ["button" "html input[type=\"button\"]" {:-webkit-appearance "button"} {:cursor "pointer"}] ["input" ["&[type=\"reset\"]" "&[type=\"submit\"]" {:-webkit-appearance "button"} {:cursor "pointer"}]] ["button[disabled]" "html input[disabled]" {:cursor "default"}] ["button::-moz-focus-inner" {:border "0"} {:padding "0"}] ["input" ["&::-moz-focus-inner" {:border "0"} {:padding "0"}] {:line-height "normal"} ["&[type=\"checkbox\"]" "&[type=\"radio\"]" {:box-sizing "border-box"} {:padding "0"}] ["&[type=\"number\"]" ["&::-webkit-inner-spin-button" "&::-webkit-outer-spin-button" {:height "auto"}]] ["&[type=\"search\"]" {:-webkit-appearance "textfield"} {:box-sizing "content-box"} ["&::-webkit-search-cancel-button" "&::-webkit-search-decoration" {:-webkit-appearance "none"}]]] ["fieldset" {:border "1px solid #c0c0c0"} {:margin "0 2px"} {:padding "0.35em 0.625em 0.75em"}] ["legend" {:border "0"} {:padding "0"}] ["textarea" {:overflow "auto"}] ["optgroup" {:font-weight "bold"}] ["table" {:border-collapse "collapse"} {:border-spacing "0"}] ["td" "th" {:padding "0"}] [".hidden" "[hidden]" {:display "none !important"}] [".pure-img" {:max-width "100%"} {:height "auto"} {:display "block"}])


;; buttons
(garden.def/defcssfn rgba)
(garden.def/defcssfn alpha)
(garden.def/defcssfn -webkit-linear-gradient)
(garden.def/defcssfn linear-gradient)
(garden.def/defcssfn rgb)
(garden.def/defstyles buttons [".pure-button" {:display "inline-block"} {:zoom "1"} {:line-height "normal"} {:white-space "nowrap"} {:vertical-align "middle"} {:text-align "center"} {:cursor "pointer"} {:-webkit-user-drag "none"} {:-webkit-user-select "none"} {:-moz-user-select "none"} {:-ms-user-select "none"} {:user-select "none"} {:box-sizing "border-box"} ["&::-moz-focus-inner" {:padding "0"} {:border "0"}] {:font-family "inherit"} {:font-size "100%"} {:padding "0.5em 1em"} {:color "#444"} {:color (rgba 0 0 0 0.8)} {:border "1px solid #999"} {:border [["none" (rgba 0 0 0 0)]]} {:background-color "#E6E6E6"} {:text-decoration "none"} {:border-radius "2px"}]
  [".pure-button-hover" {:filter (alpha "opacity=90")} {:background-image (-webkit-linear-gradient "transparent" [(rgba 0 0 0 0.05)
                                                                                                                  (garden.units/percent 40)] (rgba 0 0 0 0.1))} {:background-image (linear-gradient "transparent" [(rgba 0 0 0 0.05) (garden.units/percent 40)] (rgba 0 0 0 0.1))}] [".pure-button" ["&:hover" {:filter (alpha "opacity=90")} {:background-image (-webkit-linear-gradient "transparent" [(rgba 0 0 0 0.05) (garden.units/percent 40)] (rgba 0 0 0 0.1))} {:background-image (linear-gradient "transparent" [(rgba 0 0 0 0.05) (garden.units/percent 40)] (rgba 0 0 0 0.1))}] ["&:focus" {:filter (alpha "opacity=90")} {:background-image (-webkit-linear-gradient "transparent" [(rgba 0 0 0 0.05) (garden.units/percent 40)] (rgba 0 0 0 0.1))} {:background-image (linear-gradient "transparent" [(rgba 0 0 0 0.05) (garden.units/percent 40)] (rgba 0 0 0 0.1))} {:outline "0"}]] [".pure-button-active" {:box-shadow [[0 0 0 (garden.units/px 1) (rgba 0 0 0 0.15) "inset"] [0 0 (garden.units/px 6) (rgba 0 0 0 0.2) "inset"]]} {:border-color "#000 \\9"}] [".pure-button" ["&:active" {:box-shadow [[0 0 0 (garden.units/px 1) (rgba 0 0 0 0.15) "inset"] [0 0 (garden.units/px 6) (rgba 0 0 0 0.2) "inset"]]} {:border-color "#000 \\9"}] ["&[disabled]" {:border "none"} {:background-image "none"} {:filter (alpha "opacity=40")} {:opacity "0.40"} {:cursor "not-allowed"} {:box-shadow "none"} {:pointer-events "none"}]] [".pure-button-disabled" {:border "none"} {:background-image "none"} {:filter (alpha "opacity=40")} {:opacity "0.40"} {:cursor "not-allowed"} {:box-shadow "none"} {:pointer-events "none"} ["&:hover" "&:focus" "&:active" {:border "none"} {:background-image "none"} {:filter (alpha "opacity=40")} {:opacity "0.40"} {:cursor "not-allowed"} {:box-shadow "none"} {:pointer-events "none"}]] [".pure-button-hidden" {:display "none"}] [".pure-button-primary" ".pure-button-selected" {:background-color (rgb 0 120 231)} {:color "#fff"}] ["a" ["&.pure-button-primary" "&.pure-button-selected" {:background-color (rgb 0 120 231)} {:color "#fff"}]])


;; FORMS
(garden.def/defstyles forms
  [".pure-form"
   ["input" ["&[type=\"text\"]" "&[type=\"password\"]" "&[type=\"email\"]" "&[type=\"url\"]" "&[type=\"date\"]" "&[type=\"month\"]" "&[type=\"time\"]" "&[type=\"datetime\"]" "&[type=\"datetime-local\"]" "&[type=\"week\"]" "&[type=\"number\"]" "&[type=\"search\"]" "&[type=\"tel\"]" "&[type=\"color\"]"
             {:padding "0.5em 0.6em"}
             {:display "inline-block"}
             {:border "1px solid #ccc"}
             {:box-shadow "inset 0 1px 3px #ddd"}
             {:border-radius "4px"}
             {:vertical-align "middle"}
             {:box-sizing "border-box"}
             ]]
   ["select" "textarea" {:padding "0.5em 0.6em"} {:display "inline-block"} {:border "1px solid #ccc"} {:box-shadow "inset 0 1px 3px #ddd"} {:border-radius "4px"} {:vertical-align "middle"} {:box-sizing "border-box"}]
   ["input" ["&:not([type])" {:padding "0.5em 0.6em"} {:display "inline-block"} {:border "1px solid #ccc"} {:box-shadow "inset 0 1px 3px #ddd"} {:border-radius "4px"} {:box-sizing "border-box"}] ["&[type=\"color\"]" {:padding "0.2em 0.5em"}] ["&[type=\"text\"]:focus" "&[type=\"password\"]:focus" "&[type=\"email\"]:focus" "&[type=\"url\"]:focus" "&[type=\"date\"]:focus" "&[type=\"month\"]:focus" "&[type=\"time\"]:focus" "&[type=\"datetime\"]:focus" "&[type=\"datetime-local\"]:focus" "&[type=\"week\"]:focus" "&[type=\"number\"]:focus" "&[type=\"search\"]:focus" "&[type=\"tel\"]:focus" "&[type=\"color\"]:focus" {:outline "0"} {:border-color "#129FEA"}]]
   ["select:focus" "textarea:focus" {:outline "0"} {:border-color "#129FEA"}]
   ["input" ["&:not([type]):focus" {:outline "0"} {:border-color "#129FEA"}] ["&[type=\"file\"]:focus" "&[type=\"radio\"]:focus" "&[type=\"checkbox\"]:focus" {:outline "thin solid #129FEA"} {:outline "1px auto #129FEA"}]]
   [".pure-checkbox" ".pure-radio" {:margin "0.5em 0"} {:display "block"}]
   ["input" ["&[type=\"text\"][disabled]" "&[type=\"password\"][disabled]" "&[type=\"email\"][disabled]" "&[type=\"url\"][disabled]" "&[type=\"date\"][disabled]" "&[type=\"month\"][disabled]" "&[type=\"time\"][disabled]" "&[type=\"datetime\"][disabled]" "&[type=\"datetime-local\"][disabled]" "&[type=\"week\"][disabled]" "&[type=\"number\"][disabled]" "&[type=\"search\"][disabled]" "&[type=\"tel\"][disabled]" "&[type=\"color\"][disabled]" {:cursor "not-allowed"} {:background-color "#eaeded"} {:color "#cad2d3"}]]
   ["select[disabled]" "textarea[disabled]" {:cursor "not-allowed"} {:background-color "#eaeded"} {:color "#cad2d3"}]
   ["input" ["&:not([type])[disabled]" {:cursor "not-allowed"} {:background-color "#eaeded"} {:color "#cad2d3"}] ["&[readonly]" {:background-color "#eee"} {:color "#777"} {:border-color "#ccc"}]]
   ["select[readonly]" "textarea[readonly]" {:background-color "#eee"} {:color "#777"} {:border-color "#ccc"}]
   ["input:focus:invalid" "textarea:focus:invalid" "select:focus:invalid" {:color "#b94a48"} {:border-color "#e9322d"}]
   ["input" ["&[type=\"file\"]:focus:invalid:focus" "&[type=\"radio\"]:focus:invalid:focus" "&[type=\"checkbox\"]:focus:invalid:focus" {:outline-color "#e9322d"}]]
   ["select" {:height "2.25em"} {:border "1px solid #ccc"} {:background-color "white"} ["&[multiple]" {:height "auto"}]]
   ["label" {:margin "0.5em 0 0.2em"}]
   ["fieldset" {:margin "0"} {:padding "0.35em 0 0.75em"} {:border "0"}]
   ["legend" {:display "block"} {:width "100%"} {:padding "0.3em 0"} {:margin-bottom "0.3em"} {:color "#333"} {:border-bottom "1px solid #e5e5e5"}]
   ]
  [".pure-form-stacked" ["input" ["&[type=\"text\"]" "&[type=\"password\"]" "&[type=\"email\"]" "&[type=\"url\"]" "&[type=\"date\"]" "&[type=\"month\"]" "&[type=\"time\"]" "&[type=\"datetime\"]" "&[type=\"datetime-local\"]" "&[type=\"week\"]" "&[type=\"number\"]" "&[type=\"search\"]" "&[type=\"tel\"]" "&[type=\"color\"]" "&[type=\"file\"]" {:display "block"} {:margin "0.25em 0"}]] ["select" "label" "textarea" "input:not([type])" {:display "block"} {:margin "0.25em 0"}]]
  [".pure-form-aligned" ["input" "textarea" "select" ".pure-help-inline" {:display "inline-block"} {:*display "inline"} {:*zoom "1"} {:vertical-align "middle"}]]
  [".pure-form-message-inline" {:display "inline-block"} {:*display "inline"} {:*zoom "1"} {:vertical-align "middle"}]
  [".pure-form-aligned" ["textarea" {:vertical-align "top"}] [".pure-control-group" {:margin-bottom "0.5em"} ["label" {:text-align "right"} {:display "inline-block"} {:vertical-align "middle"} {:width "10em"} {:margin "0 1em 0 0"}]] [".pure-controls" {:margin "1.5em 0 0 11em"}]]
  [".pure-form"
   ["input.pure-input-rounded" ".pure-input-rounded" {:border-radius "2em"} {:padding "0.5em 1em"}]
   [".pure-group" ["fieldset" {:margin-bottom "10px"}] ["input" "textarea" {:display "block"} {:padding "10px"} {:margin "0 0 -1px"} {:border-radius "0"} {:position "relative"} {:top "-1px"}] ["input:focus" "textarea:focus" {:z-index "3"}] ["input:first-child" "textarea:first-child" {:top "1px"} {:border-radius "4px 4px 0 0"} {:margin "0"}] ["input:first-child:last-child" "textarea:first-child:last-child" {:top "1px"} {:border-radius "4px"} {:margin "0"}] ["input:last-child" "textarea:last-child" {:top "-2px"} {:border-radius "0 0 4px 4px"} {:margin "0"}] ["button" {:margin "0.35em 0"}]] [".pure-input-1" {:width "100%"}] [".pure-input-3-4" {:width "75%"}] [".pure-input-2-3" {:width "66%"}] [".pure-input-1-2" {:width "50%"}] [".pure-input-1-3" {:width "33%"}] [".pure-input-1-4" {:width "25%"}] [".pure-help-inline" {:display "inline-block"} {:padding-left "0.3em"} {:color "#666"} {:vertical-align "middle"} {:font-size "0.875em"}]]
  [".pure-form-message-inline" {:display "inline-block"} {:padding-left "0.3em"} {:color "#666"} {:vertical-align "middle"} {:font-size "0.875em"}]
  [".pure-form-message" {:display "block"} {:color "#666"} {:font-size "0.875em"}]

  ;;  "only screen and (max-width: 480px)"
  (garden.stylesheet/at-media
   {:screen :only :max-width (garden.units/px 480)}
   [".pure-form" ["button[type=\"submit\"]" {:margin "0.7em 0 0"}] ["input" ["&:not([type])" "&[type=\"text\"]" "&[type=\"password\"]" "&[type=\"email\"]" "&[type=\"url\"]" "&[type=\"date\"]" "&[type=\"month\"]" "&[type=\"time\"]" "&[type=\"datetime\"]" "&[type=\"datetime-local\"]" "&[type=\"week\"]" "&[type=\"number\"]" "&[type=\"search\"]" "&[type=\"tel\"]" "&[type=\"color\"]" {:margin-bottom "0.3em"} {:display "block"}]] ["label" {:margin-bottom "0.3em"} {:display "block"}]] [".pure-group input" ["&:not([type])" "&[type=\"text\"]" "&[type=\"password\"]" "&[type=\"email\"]" "&[type=\"url\"]" "&[type=\"date\"]" "&[type=\"month\"]" "&[type=\"time\"]" "&[type=\"datetime\"]" "&[type=\"datetime-local\"]" "&[type=\"week\"]" "&[type=\"number\"]" "&[type=\"search\"]" "&[type=\"tel\"]" "&[type=\"color\"]" {:margin-bottom "0"}]] [".pure-form-aligned" [".pure-control-group label" {:margin-bottom "0.3em"} {:text-align "left"} {:display "block"} {:width "100%"}] [".pure-controls" {:margin "1.5em 0 0 0"}]] [".pure-form .pure-help-inline" ".pure-form-message-inline" ".pure-form-message" {:display "block"} {:font-size "0.75em"} {:padding "0.2em 0 0.8em"}]))


(garden.def/defstyles grids-responsive
  (garden.stylesheet/at-media
   ;"screen and (min-width: 35.5em)"
   {:screen true :min-width (garden.units/em 35.5)}
   [".pure-u-sm-1" ".pure-u-sm-1-1" ".pure-u-sm-1-2" ".pure-u-sm-1-3" ".pure-u-sm-2-3" ".pure-u-sm-1-4" ".pure-u-sm-3-4" ".pure-u-sm-1-5" ".pure-u-sm-2-5" ".pure-u-sm-3-5" ".pure-u-sm-4-5" ".pure-u-sm-5-5" ".pure-u-sm-1-6" ".pure-u-sm-5-6" ".pure-u-sm-1-8" ".pure-u-sm-3-8" ".pure-u-sm-5-8" ".pure-u-sm-7-8" ".pure-u-sm-1-12" ".pure-u-sm-5-12" ".pure-u-sm-7-12" ".pure-u-sm-11-12" ".pure-u-sm-1-24" ".pure-u-sm-2-24" ".pure-u-sm-3-24" ".pure-u-sm-4-24" ".pure-u-sm-5-24" ".pure-u-sm-6-24" ".pure-u-sm-7-24" ".pure-u-sm-8-24" ".pure-u-sm-9-24" ".pure-u-sm-10-24" ".pure-u-sm-11-24" ".pure-u-sm-12-24" ".pure-u-sm-13-24" ".pure-u-sm-14-24" ".pure-u-sm-15-24" ".pure-u-sm-16-24" ".pure-u-sm-17-24" ".pure-u-sm-18-24" ".pure-u-sm-19-24" ".pure-u-sm-20-24" ".pure-u-sm-21-24" ".pure-u-sm-22-24" ".pure-u-sm-23-24" ".pure-u-sm-24-24" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:letter-spacing "normal"} {:word-spacing "normal"} {:vertical-align "top"} {:text-rendering "auto"}] [".pure-u-sm-1-24" {:width "4.1667%"} {:*width "4.1357%"}] [".pure-u-sm-1-12" ".pure-u-sm-2-24" {:width "8.3333%"} {:*width "8.3023%"}] [".pure-u-sm-1-8" ".pure-u-sm-3-24" {:width "12.5000%"} {:*width "12.4690%"}] [".pure-u-sm-1-6" ".pure-u-sm-4-24" {:width "16.6667%"} {:*width "16.6357%"}] [".pure-u-sm-1-5" {:width "20%"} {:*width "19.9690%"}] [".pure-u-sm-5-24" {:width "20.8333%"} {:*width "20.8023%"}] [".pure-u-sm-1-4" ".pure-u-sm-6-24" {:width "25%"} {:*width "24.9690%"}] [".pure-u-sm-7-24" {:width "29.1667%"} {:*width "29.1357%"}] [".pure-u-sm-1-3" ".pure-u-sm-8-24" {:width "33.3333%"} {:*width "33.3023%"}] [".pure-u-sm-3-8" ".pure-u-sm-9-24" {:width "37.5000%"} {:*width "37.4690%"}] [".pure-u-sm-2-5" {:width "40%"} {:*width "39.9690%"}] [".pure-u-sm-5-12" ".pure-u-sm-10-24" {:width "41.6667%"} {:*width "41.6357%"}] [".pure-u-sm-11-24" {:width "45.8333%"} {:*width "45.8023%"}] [".pure-u-sm-1-2" ".pure-u-sm-12-24" {:width "50%"} {:*width "49.9690%"}] [".pure-u-sm-13-24" {:width "54.1667%"} {:*width "54.1357%"}] [".pure-u-sm-7-12" ".pure-u-sm-14-24" {:width "58.3333%"} {:*width "58.3023%"}] [".pure-u-sm-3-5" {:width "60%"} {:*width "59.9690%"}] [".pure-u-sm-5-8" ".pure-u-sm-15-24" {:width "62.5000%"} {:*width "62.4690%"}] [".pure-u-sm-2-3" ".pure-u-sm-16-24" {:width "66.6667%"} {:*width "66.6357%"}] [".pure-u-sm-17-24" {:width "70.8333%"} {:*width "70.8023%"}] [".pure-u-sm-3-4" ".pure-u-sm-18-24" {:width "75%"} {:*width "74.9690%"}] [".pure-u-sm-19-24" {:width "79.1667%"} {:*width "79.1357%"}] [".pure-u-sm-4-5" {:width "80%"} {:*width "79.9690%"}] [".pure-u-sm-5-6" ".pure-u-sm-20-24" {:width "83.3333%"} {:*width "83.3023%"}] [".pure-u-sm-7-8" ".pure-u-sm-21-24" {:width "87.5000%"} {:*width "87.4690%"}] [".pure-u-sm-11-12" ".pure-u-sm-22-24" {:width "91.6667%"} {:*width "91.6357%"}] [".pure-u-sm-23-24" {:width "95.8333%"} {:*width "95.8023%"}] [".pure-u-sm-1" ".pure-u-sm-1-1" ".pure-u-sm-5-5" ".pure-u-sm-24-24" {:width "100%"}])
  (garden.stylesheet/at-media
   ;;"screen and (min-width: 48em)"
   {:screen true :min-width (garden.units/em 48)}
   [".pure-u-md-1" ".pure-u-md-1-1" ".pure-u-md-1-2" ".pure-u-md-1-3" ".pure-u-md-2-3" ".pure-u-md-1-4" ".pure-u-md-3-4" ".pure-u-md-1-5" ".pure-u-md-2-5" ".pure-u-md-3-5" ".pure-u-md-4-5" ".pure-u-md-5-5" ".pure-u-md-1-6" ".pure-u-md-5-6" ".pure-u-md-1-8" ".pure-u-md-3-8" ".pure-u-md-5-8" ".pure-u-md-7-8" ".pure-u-md-1-12" ".pure-u-md-5-12" ".pure-u-md-7-12" ".pure-u-md-11-12" ".pure-u-md-1-24" ".pure-u-md-2-24" ".pure-u-md-3-24" ".pure-u-md-4-24" ".pure-u-md-5-24" ".pure-u-md-6-24" ".pure-u-md-7-24" ".pure-u-md-8-24" ".pure-u-md-9-24" ".pure-u-md-10-24" ".pure-u-md-11-24" ".pure-u-md-12-24" ".pure-u-md-13-24" ".pure-u-md-14-24" ".pure-u-md-15-24" ".pure-u-md-16-24" ".pure-u-md-17-24" ".pure-u-md-18-24" ".pure-u-md-19-24" ".pure-u-md-20-24" ".pure-u-md-21-24" ".pure-u-md-22-24" ".pure-u-md-23-24" ".pure-u-md-24-24" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:letter-spacing "normal"} {:word-spacing "normal"} {:vertical-align "top"} {:text-rendering "auto"}] [".pure-u-md-1-24" {:width "4.1667%"} {:*width "4.1357%"}] [".pure-u-md-1-12" ".pure-u-md-2-24" {:width "8.3333%"} {:*width "8.3023%"}] [".pure-u-md-1-8" ".pure-u-md-3-24" {:width "12.5000%"} {:*width "12.4690%"}] [".pure-u-md-1-6" ".pure-u-md-4-24" {:width "16.6667%"} {:*width "16.6357%"}] [".pure-u-md-1-5" {:width "20%"} {:*width "19.9690%"}] [".pure-u-md-5-24" {:width "20.8333%"} {:*width "20.8023%"}] [".pure-u-md-1-4" ".pure-u-md-6-24" {:width "25%"} {:*width "24.9690%"}] [".pure-u-md-7-24" {:width "29.1667%"} {:*width "29.1357%"}] [".pure-u-md-1-3" ".pure-u-md-8-24" {:width "33.3333%"} {:*width "33.3023%"}] [".pure-u-md-3-8" ".pure-u-md-9-24" {:width "37.5000%"} {:*width "37.4690%"}] [".pure-u-md-2-5" {:width "40%"} {:*width "39.9690%"}] [".pure-u-md-5-12" ".pure-u-md-10-24" {:width "41.6667%"} {:*width "41.6357%"}] [".pure-u-md-11-24" {:width "45.8333%"} {:*width "45.8023%"}] [".pure-u-md-1-2" ".pure-u-md-12-24" {:width "50%"} {:*width "49.9690%"}] [".pure-u-md-13-24" {:width "54.1667%"} {:*width "54.1357%"}] [".pure-u-md-7-12" ".pure-u-md-14-24" {:width "58.3333%"} {:*width "58.3023%"}] [".pure-u-md-3-5" {:width "60%"} {:*width "59.9690%"}] [".pure-u-md-5-8" ".pure-u-md-15-24" {:width "62.5000%"} {:*width "62.4690%"}] [".pure-u-md-2-3" ".pure-u-md-16-24" {:width "66.6667%"} {:*width "66.6357%"}] [".pure-u-md-17-24" {:width "70.8333%"} {:*width "70.8023%"}] [".pure-u-md-3-4" ".pure-u-md-18-24" {:width "75%"} {:*width "74.9690%"}] [".pure-u-md-19-24" {:width "79.1667%"} {:*width "79.1357%"}] [".pure-u-md-4-5" {:width "80%"} {:*width "79.9690%"}] [".pure-u-md-5-6" ".pure-u-md-20-24" {:width "83.3333%"} {:*width "83.3023%"}] [".pure-u-md-7-8" ".pure-u-md-21-24" {:width "87.5000%"} {:*width "87.4690%"}] [".pure-u-md-11-12" ".pure-u-md-22-24" {:width "91.6667%"} {:*width "91.6357%"}] [".pure-u-md-23-24" {:width "95.8333%"} {:*width "95.8023%"}] [".pure-u-md-1" ".pure-u-md-1-1" ".pure-u-md-5-5" ".pure-u-md-24-24" {:width "100%"}])
  (garden.stylesheet/at-media
   ;;"screen and (min-width: 64em)"
   {:screen true :min-width (garden.units/em 64)}
   [".pure-u-lg-1" ".pure-u-lg-1-1" ".pure-u-lg-1-2" ".pure-u-lg-1-3" ".pure-u-lg-2-3" ".pure-u-lg-1-4" ".pure-u-lg-3-4" ".pure-u-lg-1-5" ".pure-u-lg-2-5" ".pure-u-lg-3-5" ".pure-u-lg-4-5" ".pure-u-lg-5-5" ".pure-u-lg-1-6" ".pure-u-lg-5-6" ".pure-u-lg-1-8" ".pure-u-lg-3-8" ".pure-u-lg-5-8" ".pure-u-lg-7-8" ".pure-u-lg-1-12" ".pure-u-lg-5-12" ".pure-u-lg-7-12" ".pure-u-lg-11-12" ".pure-u-lg-1-24" ".pure-u-lg-2-24" ".pure-u-lg-3-24" ".pure-u-lg-4-24" ".pure-u-lg-5-24" ".pure-u-lg-6-24" ".pure-u-lg-7-24" ".pure-u-lg-8-24" ".pure-u-lg-9-24" ".pure-u-lg-10-24" ".pure-u-lg-11-24" ".pure-u-lg-12-24" ".pure-u-lg-13-24" ".pure-u-lg-14-24" ".pure-u-lg-15-24" ".pure-u-lg-16-24" ".pure-u-lg-17-24" ".pure-u-lg-18-24" ".pure-u-lg-19-24" ".pure-u-lg-20-24" ".pure-u-lg-21-24" ".pure-u-lg-22-24" ".pure-u-lg-23-24" ".pure-u-lg-24-24" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:letter-spacing "normal"} {:word-spacing "normal"} {:vertical-align "top"} {:text-rendering "auto"}] [".pure-u-lg-1-24" {:width "4.1667%"} {:*width "4.1357%"}] [".pure-u-lg-1-12" ".pure-u-lg-2-24" {:width "8.3333%"} {:*width "8.3023%"}] [".pure-u-lg-1-8" ".pure-u-lg-3-24" {:width "12.5000%"} {:*width "12.4690%"}] [".pure-u-lg-1-6" ".pure-u-lg-4-24" {:width "16.6667%"} {:*width "16.6357%"}] [".pure-u-lg-1-5" {:width "20%"} {:*width "19.9690%"}] [".pure-u-lg-5-24" {:width "20.8333%"} {:*width "20.8023%"}] [".pure-u-lg-1-4" ".pure-u-lg-6-24" {:width "25%"} {:*width "24.9690%"}] [".pure-u-lg-7-24" {:width "29.1667%"} {:*width "29.1357%"}] [".pure-u-lg-1-3" ".pure-u-lg-8-24" {:width "33.3333%"} {:*width "33.3023%"}] [".pure-u-lg-3-8" ".pure-u-lg-9-24" {:width "37.5000%"} {:*width "37.4690%"}] [".pure-u-lg-2-5" {:width "40%"} {:*width "39.9690%"}] [".pure-u-lg-5-12" ".pure-u-lg-10-24" {:width "41.6667%"} {:*width "41.6357%"}] [".pure-u-lg-11-24" {:width "45.8333%"} {:*width "45.8023%"}] [".pure-u-lg-1-2" ".pure-u-lg-12-24" {:width "50%"} {:*width "49.9690%"}] [".pure-u-lg-13-24" {:width "54.1667%"} {:*width "54.1357%"}] [".pure-u-lg-7-12" ".pure-u-lg-14-24" {:width "58.3333%"} {:*width "58.3023%"}] [".pure-u-lg-3-5" {:width "60%"} {:*width "59.9690%"}] [".pure-u-lg-5-8" ".pure-u-lg-15-24" {:width "62.5000%"} {:*width "62.4690%"}] [".pure-u-lg-2-3" ".pure-u-lg-16-24" {:width "66.6667%"} {:*width "66.6357%"}] [".pure-u-lg-17-24" {:width "70.8333%"} {:*width "70.8023%"}] [".pure-u-lg-3-4" ".pure-u-lg-18-24" {:width "75%"} {:*width "74.9690%"}] [".pure-u-lg-19-24" {:width "79.1667%"} {:*width "79.1357%"}] [".pure-u-lg-4-5" {:width "80%"} {:*width "79.9690%"}] [".pure-u-lg-5-6" ".pure-u-lg-20-24" {:width "83.3333%"} {:*width "83.3023%"}] [".pure-u-lg-7-8" ".pure-u-lg-21-24" {:width "87.5000%"} {:*width "87.4690%"}] [".pure-u-lg-11-12" ".pure-u-lg-22-24" {:width "91.6667%"} {:*width "91.6357%"}] [".pure-u-lg-23-24" {:width "95.8333%"} {:*width "95.8023%"}] [".pure-u-lg-1" ".pure-u-lg-1-1" ".pure-u-lg-5-5" ".pure-u-lg-24-24" {:width "100%"}]
   )
  (garden.stylesheet/at-media
   ;;"screen and (min-width: 80em)"
   {:screen true :min-width (garden.units/em 80)}
   [".pure-u-xl-1" ".pure-u-xl-1-1" ".pure-u-xl-1-2" ".pure-u-xl-1-3" ".pure-u-xl-2-3" ".pure-u-xl-1-4" ".pure-u-xl-3-4" ".pure-u-xl-1-5" ".pure-u-xl-2-5" ".pure-u-xl-3-5" ".pure-u-xl-4-5" ".pure-u-xl-5-5" ".pure-u-xl-1-6" ".pure-u-xl-5-6" ".pure-u-xl-1-8" ".pure-u-xl-3-8" ".pure-u-xl-5-8" ".pure-u-xl-7-8" ".pure-u-xl-1-12" ".pure-u-xl-5-12" ".pure-u-xl-7-12" ".pure-u-xl-11-12" ".pure-u-xl-1-24" ".pure-u-xl-2-24" ".pure-u-xl-3-24" ".pure-u-xl-4-24" ".pure-u-xl-5-24" ".pure-u-xl-6-24" ".pure-u-xl-7-24" ".pure-u-xl-8-24" ".pure-u-xl-9-24" ".pure-u-xl-10-24" ".pure-u-xl-11-24" ".pure-u-xl-12-24" ".pure-u-xl-13-24" ".pure-u-xl-14-24" ".pure-u-xl-15-24" ".pure-u-xl-16-24" ".pure-u-xl-17-24" ".pure-u-xl-18-24" ".pure-u-xl-19-24" ".pure-u-xl-20-24" ".pure-u-xl-21-24" ".pure-u-xl-22-24" ".pure-u-xl-23-24" ".pure-u-xl-24-24" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:letter-spacing "normal"} {:word-spacing "normal"} {:vertical-align "top"} {:text-rendering "auto"}] [".pure-u-xl-1-24" {:width "4.1667%"} {:*width "4.1357%"}] [".pure-u-xl-1-12" ".pure-u-xl-2-24" {:width "8.3333%"} {:*width "8.3023%"}] [".pure-u-xl-1-8" ".pure-u-xl-3-24" {:width "12.5000%"} {:*width "12.4690%"}] [".pure-u-xl-1-6" ".pure-u-xl-4-24" {:width "16.6667%"} {:*width "16.6357%"}] [".pure-u-xl-1-5" {:width "20%"} {:*width "19.9690%"}] [".pure-u-xl-5-24" {:width "20.8333%"} {:*width "20.8023%"}] [".pure-u-xl-1-4" ".pure-u-xl-6-24" {:width "25%"} {:*width "24.9690%"}] [".pure-u-xl-7-24" {:width "29.1667%"} {:*width "29.1357%"}] [".pure-u-xl-1-3" ".pure-u-xl-8-24" {:width "33.3333%"} {:*width "33.3023%"}] [".pure-u-xl-3-8" ".pure-u-xl-9-24" {:width "37.5000%"} {:*width "37.4690%"}] [".pure-u-xl-2-5" {:width "40%"} {:*width "39.9690%"}] [".pure-u-xl-5-12" ".pure-u-xl-10-24" {:width "41.6667%"} {:*width "41.6357%"}] [".pure-u-xl-11-24" {:width "45.8333%"} {:*width "45.8023%"}] [".pure-u-xl-1-2" ".pure-u-xl-12-24" {:width "50%"} {:*width "49.9690%"}] [".pure-u-xl-13-24" {:width "54.1667%"} {:*width "54.1357%"}] [".pure-u-xl-7-12" ".pure-u-xl-14-24" {:width "58.3333%"} {:*width "58.3023%"}] [".pure-u-xl-3-5" {:width "60%"} {:*width "59.9690%"}] [".pure-u-xl-5-8" ".pure-u-xl-15-24" {:width "62.5000%"} {:*width "62.4690%"}] [".pure-u-xl-2-3" ".pure-u-xl-16-24" {:width "66.6667%"} {:*width "66.6357%"}] [".pure-u-xl-17-24" {:width "70.8333%"} {:*width "70.8023%"}] [".pure-u-xl-3-4" ".pure-u-xl-18-24" {:width "75%"} {:*width "74.9690%"}] [".pure-u-xl-19-24" {:width "79.1667%"} {:*width "79.1357%"}] [".pure-u-xl-4-5" {:width "80%"} {:*width "79.9690%"}] [".pure-u-xl-5-6" ".pure-u-xl-20-24" {:width "83.3333%"} {:*width "83.3023%"}] [".pure-u-xl-7-8" ".pure-u-xl-21-24" {:width "87.5000%"} {:*width "87.4690%"}] [".pure-u-xl-11-12" ".pure-u-xl-22-24" {:width "91.6667%"} {:*width "91.6357%"}] [".pure-u-xl-23-24" {:width "95.8333%"} {:*width "95.8023%"}] [".pure-u-xl-1" ".pure-u-xl-1-1" ".pure-u-xl-5-5" ".pure-u-xl-24-24" {:width "100%"}])
  )

;; grids
(garden.def/defstyles grids [".pure-g" {:letter-spacing "-0.31em"} {:*letter-spacing "normal"} {:*word-spacing "-0.43em"} {:text-rendering "optimizespeed"} {:font-family "FreeSans, Arimo, \"Droid Sans\", Helvetica, Arial, sans-serif"} {:display "-webkit-box"} {:display "-webkit-flex"} {:display "-ms-flexbox"} {:display "flex"} {:-webkit-flex-flow "row wrap"} {:-ms-flex-flow "row wrap"} {:flex-flow "row wrap"} {:-webkit-align-content "flex-start"} {:-ms-flex-line-pack "start"} {:align-content "flex-start"}]
  (garden.stylesheet/at-media
   ;; hack um
   ;; @media all and (-ms-high-contrast: none), (-ms-high-contrast: active)
   ;; zu erzeugen
   {:all true "-ms-high-contrast: none), (-ms-high-contrast" :active}
   ["table .pure-g" {:display "block"}]) [".opera-only :-o-prefocus" ".pure-g" {:word-spacing "-0.43em"}] [".pure-u" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:letter-spacing "normal"} {:word-spacing "normal"} {:vertical-align "top"} {:text-rendering "auto"}] [".pure-g [class*=\"pure-u\"]" {:font-family "sans-serif"}] [".pure-u-1" ".pure-u-1-1" ".pure-u-1-2" ".pure-u-1-3" ".pure-u-2-3" ".pure-u-1-4" ".pure-u-3-4" ".pure-u-1-5" ".pure-u-2-5" ".pure-u-3-5" ".pure-u-4-5" ".pure-u-5-5" ".pure-u-1-6" ".pure-u-5-6" ".pure-u-1-8" ".pure-u-3-8" ".pure-u-5-8" ".pure-u-7-8" ".pure-u-1-12" ".pure-u-5-12" ".pure-u-7-12" ".pure-u-11-12" ".pure-u-1-24" ".pure-u-2-24" ".pure-u-3-24" ".pure-u-4-24" ".pure-u-5-24" ".pure-u-6-24" ".pure-u-7-24" ".pure-u-8-24" ".pure-u-9-24" ".pure-u-10-24" ".pure-u-11-24" ".pure-u-12-24" ".pure-u-13-24" ".pure-u-14-24" ".pure-u-15-24" ".pure-u-16-24" ".pure-u-17-24" ".pure-u-18-24" ".pure-u-19-24" ".pure-u-20-24" ".pure-u-21-24" ".pure-u-22-24" ".pure-u-23-24" ".pure-u-24-24" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:letter-spacing "normal"} {:word-spacing "normal"} {:vertical-align "top"} {:text-rendering "auto"}] [".pure-u-1-24" {:width "4.1667%"} {:*width "4.1357%"}] [".pure-u-1-12" ".pure-u-2-24" {:width "8.3333%"} {:*width "8.3023%"}] [".pure-u-1-8" ".pure-u-3-24" {:width "12.5000%"} {:*width "12.4690%"}] [".pure-u-1-6" ".pure-u-4-24" {:width "16.6667%"} {:*width "16.6357%"}] [".pure-u-1-5" {:width "20%"} {:*width "19.9690%"}] [".pure-u-5-24" {:width "20.8333%"} {:*width "20.8023%"}] [".pure-u-1-4" ".pure-u-6-24" {:width "25%"} {:*width "24.9690%"}] [".pure-u-7-24" {:width "29.1667%"} {:*width "29.1357%"}] [".pure-u-1-3" ".pure-u-8-24" {:width "33.3333%"} {:*width "33.3023%"}] [".pure-u-3-8" ".pure-u-9-24" {:width "37.5000%"} {:*width "37.4690%"}] [".pure-u-2-5" {:width "40%"} {:*width "39.9690%"}] [".pure-u-5-12" ".pure-u-10-24" {:width "41.6667%"} {:*width "41.6357%"}] [".pure-u-11-24" {:width "45.8333%"} {:*width "45.8023%"}] [".pure-u-1-2" ".pure-u-12-24" {:width "50%"} {:*width "49.9690%"}] [".pure-u-13-24" {:width "54.1667%"} {:*width "54.1357%"}] [".pure-u-7-12" ".pure-u-14-24" {:width "58.3333%"} {:*width "58.3023%"}] [".pure-u-3-5" {:width "60%"} {:*width "59.9690%"}] [".pure-u-5-8" ".pure-u-15-24" {:width "62.5000%"} {:*width "62.4690%"}] [".pure-u-2-3" ".pure-u-16-24" {:width "66.6667%"} {:*width "66.6357%"}] [".pure-u-17-24" {:width "70.8333%"} {:*width "70.8023%"}] [".pure-u-3-4" ".pure-u-18-24" {:width "75%"} {:*width "74.9690%"}] [".pure-u-19-24" {:width "79.1667%"} {:*width "79.1357%"}] [".pure-u-4-5" {:width "80%"} {:*width "79.9690%"}] [".pure-u-5-6" ".pure-u-20-24" {:width "83.3333%"} {:*width "83.3023%"}] [".pure-u-7-8" ".pure-u-21-24" {:width "87.5000%"} {:*width "87.4690%"}] [".pure-u-11-12" ".pure-u-22-24" {:width "91.6667%"} {:*width "91.6357%"}] [".pure-u-23-24" {:width "95.8333%"} {:*width "95.8023%"}] [".pure-u-1" ".pure-u-1-1" ".pure-u-5-5" ".pure-u-24-24" {:width "100%"}])


;; MENUS

(garden.def/defstyles menus [".pure-menu" {:box-sizing "border-box"}] [".pure-menu-fixed" {:position "fixed"} {:left "0"} {:top "0"} {:z-index "3"}] [".pure-menu-list" ".pure-menu-item" {:position "relative"}] [".pure-menu-list" {:list-style "none"} {:margin "0"} {:padding "0"}] [".pure-menu-item" {:padding "0"} {:margin "0"} {:height "100%"}] [".pure-menu-link" ".pure-menu-heading" {:display "block"} {:text-decoration "none"} {:white-space "nowrap"}] [".pure-menu-horizontal" {:width "100%"} {:white-space "nowrap"} [".pure-menu-list" {:display "inline-block"}] [".pure-menu-item" ".pure-menu-heading" ".pure-menu-separator" {:display "inline-block"} {:*display "inline"} {:zoom "1"} {:vertical-align "middle"}]] [".pure-menu-item .pure-menu-item" {:display "block"}] [".pure-menu-children" {:display "none"} {:position "absolute"} {:left "100%"} {:top "0"} {:margin "0"} {:padding "0"} {:z-index "3"}] [".pure-menu-horizontal .pure-menu-children" {:left "0"} {:top "auto"} {:width "inherit"}] [".pure-menu-allow-hover:hover > .pure-menu-children" ".pure-menu-active > .pure-menu-children" {:display "block"} {:position "absolute"}] [".pure-menu-has-children > .pure-menu-link:after" {:padding-left "0.5em"} {:content "\"\\25B8\""} {:font-size "small"}] [".pure-menu-horizontal .pure-menu-has-children > .pure-menu-link:after" {:content "\"\\25BE\""}] [".pure-menu-scrollable" {:overflow-y "scroll"} {:overflow-x "hidden"} [".pure-menu-list" {:display "block"}]] [".pure-menu-horizontal.pure-menu-scrollable" [".pure-menu-list" {:display "inline-block"}] {:white-space "nowrap"} {:overflow-y "hidden"} {:overflow-x "auto"} {:-ms-overflow-style "none"} {:-webkit-overflow-scrolling "touch"} {:padding ".5em 0"} ["&::-webkit-scrollbar" {:display "none"}]] [".pure-menu-separator" {:background-color "#ccc"} {:height "1px"} {:margin ".3em 0"}] [".pure-menu-horizontal .pure-menu-separator" {:width "1px"} {:height "1.3em"} {:margin "0 0.3em"}] [".pure-menu-heading" {:text-transform "uppercase"} {:color "#565d64"}] [".pure-menu-link" {:color "#777"}] [".pure-menu-children" {:background-color "#fff"}] [".pure-menu-link" ".pure-menu-disabled" ".pure-menu-heading" {:padding ".5em 1em"}] [".pure-menu-disabled" {:opacity ".5"} [".pure-menu-link:hover" {:background-color "transparent"}]] [".pure-menu-active > .pure-menu-link" {:background-color "#eee"}] [".pure-menu-link" ["&:hover" "&:focus" {:background-color "#eee"}]] [".pure-menu-selected .pure-menu-link" {:color "#000"} ["&:visited" {:color "#000"}]])


;; tables

(garden.def/defstyles tables [".pure-table" {:border-collapse "collapse"} {:border-spacing "0"} {:empty-cells "show"} {:border "1px solid #cbcbcb"} ["caption" {:color "#000"} {:font "italic 85%/1 arial, sans-serif"} {:padding "1em 0"} {:text-align "center"}] ["td" "th" {:border-left "1px solid #cbcbcb"} {:border-width "0 0 0 1px"} {:font-size "inherit"} {:margin "0"} {:overflow "visible"} {:padding "0.5em 1em"}] ["td:first-child" "th:first-child" {:border-left-width "0"}] ["thead" {:background-color "#e0e0e0"} {:color "#000"} {:text-align "left"} {:vertical-align "bottom"}] ["td" {:background-color "transparent"}]] [".pure-table-odd td" ".pure-table-striped tr:nth-child(2n-1) td" {:background-color "#f2f2f2"}] [".pure-table-bordered" ["td" {:border-bottom "1px solid #cbcbcb"}] ["tbody > tr:last-child > td" {:border-bottom-width "0"}]] [".pure-table-horizontal" ["td" "th" {:border-width "0 0 1px 0"} {:border-bottom "1px solid #cbcbcb"}] ["tbody > tr:last-child > td" {:border-bottom-width "0"}]])


(garden.def/defstyles v0.6.1 [base buttons forms grids grids-responsive menus tables])

(garden.core/css {:output-to "resources/pure-0.6.1.css"} garden-libs.purecss.core/v0.6.1)
