(ns snmp4clj.core
  (:use [snmp4clj pdu target]) ;; XXX NO NO NO
  (:import [org.snmp4j Snmp PDU]
           [org.snmp4j.smi OID]
           [org.snmp4j.event ResponseListener]
           [org.snmp4j.util TableUtils TreeUtils DefaultPDUFactory]))


(defn snmp-get
  [session
   {:keys [community address version async]
    :or {community "public"
         address "udp:localhost/161"
         version :v2c
         }}
   oids]
  (let [pdu (create-pdu version PDU/GET oids)
        target (create-target version
                              {:community community
                               :address address})]
    (if async
      (.send session pdu target nil async)
      (some-> (.send session pdu target)
              (.getResponse)
              (.getVariableBindings)
              (seq)))))


(defn snmp-get-next
  [session
   {:keys [community address version async]
    :or {community "public"
         address "udp:localhost/161"
         version :v2c
         }}
   oids]
  (let [pdu (create-pdu version PDU/GETNEXT oids)
        target (create-target version
                              {:community community
                               :address address})]
    (if async
      (.send session pdu target nil async)
      (some-> (.send session pdu target)
              (.getResponse)
              (.getVariableBindings)
              (seq)))))



(defn snmp-get-bulk
  [session
   {:keys [community address version async]
    :or {community "public"
         address "udp:localhost/161"
         version :v2c
         }}
   oids]
  (let [pdu (create-pdu version PDU/GETBULK oids)
        target (create-target version
                              {:community community
                               :address address})]
    (if async
      (.send session pdu target nil async)
      (some-> (.send session pdu target)
              (.getResponse)
              (.getVariableBindings)
              (seq)))))



(defn snmp-table-walk
  [session
   {:keys [community address version async max-rows-per-pdu max-cols-per-pdu lower-bound upper-bound]
    :or {community "public"
         address "udp:localhost/161"
         version :v2c
         max-rows-per-pdu 10
         max-cols-per-pdu 10}}
   oids]
  (let [target (create-target version
                              {:community community
                               :address address})
        table (doto (TableUtils. session (DefaultPDUFactory.))
                (.setMaxNumRowsPerPDU max-rows-per-pdu)
                (.setMaxNumColumnsPerPDU max-cols-per-pdu))]
    (if async
      (.getTable table target async nil (OID. (str lower-bound)) (OID. (str upper-bound)))
      ;; FIXME: ugly
      (let [tbl (.getTable table target
                           (into-array OID (map #(OID. %) oids))
                           (OID. (str lower-bound))
                           (OID. (str upper-bound)))]
        (let [ret (map (comp seq (memfn getColumns)) tbl)]
          (if (first ret)
            ret
            '()))))))



