(ns snmp4clj.target
  (:import [org.snmp4j CommunityTarget]
           [org.snmp4j.mp SnmpConstants]
           [org.snmp4j.smi GenericAddress OctetString]))


(defmulti create-target
  (fn [v m]
    (if (contains? #{:v1 :v2c :v3} v)
      v
      :v2c)))

(defmethod create-target :default
  [_ {:keys [community address timeout retries max-pdu]
      :or {community "public"
           address "udp:localhost/161"
           timeout 10
           retries 3
           max-pdu 65535}}]
  (doto (CommunityTarget.)
    (.setCommunity (OctetString. community))
    (.setVersion SnmpConstants/version2c)
    (.setAddress (GenericAddress/parse address))))


(defmethod create-target :v3
  [_ {:keys [community address timeout retries max-pdu]
      :or {community "public"
           address "udp:localhost/161"
           timeout 10
           retries 3
           max-pdu 65535}}]
  (println "create-target: not implemented yet"))



