/**
 * @fileoverview Generated by closureidl 0.1.
 * @see http://www.w3.org/TR/2011/REC-SVG11-20110816/svg.idl
 * @externs
 */


/**
 * @constructor
 * @extends {Element}
 */
function SVGElement() {}

/**
 * @type {string}
 */
SVGElement.prototype.id;

/**
 * @type {string}
 */
SVGElement.prototype.xmlbase;

/**
 * @type {SVGSVGElement}
 */
SVGElement.prototype.ownerSVGElement;

/**
 * @type {SVGElement}
 */
SVGElement.prototype.viewportElement;


/**
 * @constructor
 */
function SVGLangSpace() {}

/**
 * @type {string}
 */
SVGLangSpace.prototype.xmllang;

/**
 * @type {string}
 */
SVGLangSpace.prototype.xmlspace;


/**
 * @constructor
 */
function SVGExternalResourcesRequired() {}

/**
 * @type {SVGAnimatedBoolean}
 */
SVGExternalResourcesRequired.prototype.externalResourcesRequired;


/**
 * @constructor
 */
function SVGTests() {}

/**
 * @type {SVGStringList}
 */
SVGTests.prototype.requiredFeatures;

/**
 * @type {SVGStringList}
 */
SVGTests.prototype.requiredExtensions;

/**
 * @type {SVGStringList}
 */
SVGTests.prototype.systemLanguage;

/**
 * @param {string} extension
 * @return {boolean}
 */
SVGTests.prototype.hasExtension = function(extension) {};


/**
 * @constructor
 */
function SVGFitToViewBox() {}

/**
 * @type {SVGAnimatedRect}
 */
SVGFitToViewBox.prototype.viewBox;

/**
 * @type {SVGAnimatedPreserveAspectRatio}
 */
SVGFitToViewBox.prototype.preserveAspectRatio;


/**
 * @constructor
 */
function SVGZoomAndPan() {}

/**
 * @const
 * @type {number}
 */
SVGZoomAndPan.SVG_ZOOMANDPAN_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGZoomAndPan.SVG_ZOOMANDPAN_DISABLE;

/**
 * @const
 * @type {number}
 */
SVGZoomAndPan.SVG_ZOOMANDPAN_MAGNIFY;

/**
 * @type {number}
 */
SVGZoomAndPan.prototype.zoomAndPan;


/**
 * @constructor
 * @extends {SVGZoomAndPan}
 * @implements {SVGFitToViewBox}
 */
function SVGViewSpec() {}

/**
 * @type {SVGTransformList}
 */
SVGViewSpec.prototype.transform;

/**
 * @type {SVGElement}
 */
SVGViewSpec.prototype.viewTarget;

/**
 * @type {string}
 */
SVGViewSpec.prototype.viewBoxString;

/**
 * @type {string}
 */
SVGViewSpec.prototype.preserveAspectRatioString;

/**
 * @type {string}
 */
SVGViewSpec.prototype.transformString;

/**
 * @type {string}
 */
SVGViewSpec.prototype.viewTargetString;


/**
 * @constructor
 */
function SVGURIReference() {}

/**
 * @type {SVGAnimatedString}
 */
SVGURIReference.prototype.href;


/**
 * @constructor
 */
function SVGPoint() {}

/**
 * @type {number}
 */
SVGPoint.prototype.x;

/**
 * @type {number}
 */
SVGPoint.prototype.y;

/**
 * @param {SVGMatrix} matrix
 * @return {SVGPoint}
 */
SVGPoint.prototype.matrixTransform = function(matrix) {};


/**
 * @constructor
 */
function SVGMatrix() {}

/**
 * @type {number}
 */
SVGMatrix.prototype.a;

/**
 * @type {number}
 */
SVGMatrix.prototype.b;

/**
 * @type {number}
 */
SVGMatrix.prototype.c;

/**
 * @type {number}
 */
SVGMatrix.prototype.d;

/**
 * @type {number}
 */
SVGMatrix.prototype.e;

/**
 * @type {number}
 */
SVGMatrix.prototype.f;

/**
 * @param {SVGMatrix} secondMatrix
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.multiply = function(secondMatrix) {};

/**
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.inverse = function() {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.translate = function(x, y) {};

/**
 * @param {number} scaleFactor
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.scale = function(scaleFactor) {};

/**
 * @param {number} scaleFactorX
 * @param {number} scaleFactorY
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.scaleNonUniform = function(scaleFactorX, scaleFactorY) {};

/**
 * @param {number} angle
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.rotate = function(angle) {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.rotateFromVector = function(x, y) {};

/**
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.flipX = function() {};

/**
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.flipY = function() {};

/**
 * @param {number} angle
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.skewX = function(angle) {};

/**
 * @param {number} angle
 * @return {SVGMatrix}
 */
SVGMatrix.prototype.skewY = function(angle) {};


/**
 * @constructor
 */
function SVGPreserveAspectRatio() {}

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_NONE;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMIN;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMIN;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMIN;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMID;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMID;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMID;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMINYMAX;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMIDYMAX;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_PRESERVEASPECTRATIO_XMAXYMAX;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_MEETORSLICE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_MEETORSLICE_MEET;

/**
 * @const
 * @type {number}
 */
SVGPreserveAspectRatio.SVG_MEETORSLICE_SLICE;

/**
 * @type {number}
 */
SVGPreserveAspectRatio.prototype.align;

/**
 * @type {number}
 */
SVGPreserveAspectRatio.prototype.meetOrSlice;


/**
 * @constructor
 */
function SVGAnimatedPreserveAspectRatio() {}

/**
 * @type {SVGPreserveAspectRatio}
 */
SVGAnimatedPreserveAspectRatio.prototype.baseVal;

/**
 * @type {SVGPreserveAspectRatio}
 */
SVGAnimatedPreserveAspectRatio.prototype.animVal;


/**
 * @constructor
 */
function SVGTransformList() {}

/**
 * @type {number}
 */
SVGTransformList.prototype.numberOfItems;

/** */
SVGTransformList.prototype.clear = function() {};

/**
 * @param {SVGTransform} newItem
 * @return {SVGTransform}
 */
SVGTransformList.prototype.initialize = function(newItem) {};

/**
 * @param {number} index
 * @return {SVGTransform}
 */
SVGTransformList.prototype.getItem = function(index) {};

/**
 * @param {SVGTransform} newItem
 * @param {number} index
 * @return {SVGTransform}
 */
SVGTransformList.prototype.insertItemBefore = function(newItem, index) {};

/**
 * @param {SVGTransform} newItem
 * @param {number} index
 * @return {SVGTransform}
 */
SVGTransformList.prototype.replaceItem = function(newItem, index) {};

/**
 * @param {number} index
 * @return {SVGTransform}
 */
SVGTransformList.prototype.removeItem = function(index) {};

/**
 * @param {SVGTransform} newItem
 * @return {SVGTransform}
 */
SVGTransformList.prototype.appendItem = function(newItem) {};

/**
 * @param {SVGMatrix} matrix
 * @return {SVGTransform}
 */
SVGTransformList.prototype.createSVGTransformFromMatrix = function(matrix) {};

/**
 * @return {SVGTransform}
 */
SVGTransformList.prototype.consolidate = function() {};


/**
 * @constructor
 */
function SVGAnimatedTransformList() {}

/**
 * @type {SVGTransformList}
 */
SVGAnimatedTransformList.prototype.baseVal;

/**
 * @type {SVGTransformList}
 */
SVGAnimatedTransformList.prototype.animVal;


/**
 * @constructor
 */
function SVGTransform() {}

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_MATRIX;

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_TRANSLATE;

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_SCALE;

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_ROTATE;

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_SKEWX;

/**
 * @const
 * @type {number}
 */
SVGTransform.SVG_TRANSFORM_SKEWY;

/**
 * @type {number}
 */
SVGTransform.prototype.type;

/**
 * @type {SVGMatrix}
 */
SVGTransform.prototype.matrix;

/**
 * @type {number}
 */
SVGTransform.prototype.angle;

/**
 * @param {SVGMatrix} matrix
 */
SVGTransform.prototype.setMatrix = function(matrix) {};

/**
 * @param {number} tx
 * @param {number} ty
 */
SVGTransform.prototype.setTranslate = function(tx, ty) {};

/**
 * @param {number} sx
 * @param {number} sy
 */
SVGTransform.prototype.setScale = function(sx, sy) {};

/**
 * @param {number} angle
 * @param {number} cx
 * @param {number} cy
 */
SVGTransform.prototype.setRotate = function(angle, cx, cy) {};

/**
 * @param {number} angle
 */
SVGTransform.prototype.setSkewX = function(angle) {};

/**
 * @param {number} angle
 */
SVGTransform.prototype.setSkewY = function(angle) {};


/**
 * @constructor
 */
function SVGICCColor() {}

/**
 * @type {string}
 */
SVGICCColor.prototype.colorProfile;

/**
 * @type {SVGNumberList}
 */
SVGICCColor.prototype.colors;


/**
 * @constructor
 * @extends {CSSValue}
 */
function SVGColor() {}

/**
 * @const
 * @type {number}
 */
SVGColor.SVG_COLORTYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGColor.SVG_COLORTYPE_RGBCOLOR;

/**
 * @const
 * @type {number}
 */
SVGColor.SVG_COLORTYPE_RGBCOLOR_ICCCOLOR;

/**
 * @const
 * @type {number}
 */
SVGColor.SVG_COLORTYPE_CURRENTCOLOR;

/**
 * @type {number}
 */
SVGColor.prototype.colorType;

/**
 * @type {RGBColor}
 */
SVGColor.prototype.rgbColor;

/**
 * @type {SVGICCColor}
 */
SVGColor.prototype.iccColor;

/**
 * @param {string} rgbColor
 */
SVGColor.prototype.setRGBColor = function(rgbColor) {};

/**
 * @param {string} rgbColor
 * @param {string} iccColor
 */
SVGColor.prototype.setRGBColorICCColor = function(rgbColor, iccColor) {};

/**
 * @param {number} colorType
 * @param {string} rgbColor
 * @param {string} iccColor
 */
SVGColor.prototype.setColor = function(colorType, rgbColor, iccColor) {};


/**
 * @constructor
 * @extends {SVGColor}
 */
function SVGPaint() {}

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_RGBCOLOR;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_RGBCOLOR_ICCCOLOR;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_NONE;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_CURRENTCOLOR;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_URI_NONE;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_URI_CURRENTCOLOR;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_URI_RGBCOLOR_ICCCOLOR;

/**
 * @const
 * @type {number}
 */
SVGPaint.SVG_PAINTTYPE_URI;

/**
 * @type {number}
 */
SVGPaint.prototype.paintType;

/**
 * @type {string}
 */
SVGPaint.prototype.uri;

/**
 * @param {string} uri
 */
SVGPaint.prototype.setUri = function(uri) {};

/**
 * @param {number} paintType
 * @param {string} uri
 * @param {string} rgbColor
 * @param {string} iccColor
 */
SVGPaint.prototype.setPaint = function(paintType, uri, rgbColor, iccColor) {};


/**
 * @constructor
 * @extends {SVGLocatable}
 */
function SVGTransformable() {}

/**
 * @type {SVGAnimatedTransformList}
 */
SVGTransformable.prototype.transform;


/**
 * @constructor
 * @extends {Document}
 * @implements {DocumentEvent}
 */
function SVGDocument() {}

/**
 * @type {string}
 */
SVGDocument.prototype.title;

/**
 * @type {string}
 */
SVGDocument.prototype.referrer;

/**
 * @type {string}
 */
SVGDocument.prototype.domain;

/**
 * @type {string}
 */
SVGDocument.prototype.URL;

/**
 * @type {SVGSVGElement}
 */
SVGDocument.prototype.rootElement;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGLocatable}
 * @implements {SVGFitToViewBox}
 * @implements {SVGZoomAndPan}
 * @implements {DocumentEvent}
 * @implements {ViewCSS}
 * @implements {DocumentCSS}
 */
function SVGSVGElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGSVGElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGSVGElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGSVGElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGSVGElement.prototype.height;

/**
 * @type {string}
 */
SVGSVGElement.prototype.contentScriptType;

/**
 * @type {string}
 */
SVGSVGElement.prototype.contentStyleType;

/**
 * @type {SVGRect}
 */
SVGSVGElement.prototype.viewport;

/**
 * @type {number}
 */
SVGSVGElement.prototype.pixelUnitToMillimeterX;

/**
 * @type {number}
 */
SVGSVGElement.prototype.pixelUnitToMillimeterY;

/**
 * @type {number}
 */
SVGSVGElement.prototype.screenPixelToMillimeterX;

/**
 * @type {number}
 */
SVGSVGElement.prototype.screenPixelToMillimeterY;

/**
 * @type {boolean}
 */
SVGSVGElement.prototype.useCurrentView;

/**
 * @type {SVGViewSpec}
 */
SVGSVGElement.prototype.currentView;

/**
 * @type {number}
 */
SVGSVGElement.prototype.currentScale;

/**
 * @type {SVGPoint}
 */
SVGSVGElement.prototype.currentTranslate;

/**
 * @param {number} maxWaitMilliseconds
 * @return {number}
 */
SVGSVGElement.prototype.suspendRedraw = function(maxWaitMilliseconds) {};

/**
 * @param {number} suspendHandleID
 */
SVGSVGElement.prototype.unsuspendRedraw = function(suspendHandleID) {};

/** */
SVGSVGElement.prototype.unsuspendRedrawAll = function() {};

/** */
SVGSVGElement.prototype.forceRedraw = function() {};

/** */
SVGSVGElement.prototype.pauseAnimations = function() {};

/** */
SVGSVGElement.prototype.unpauseAnimations = function() {};

/**
 * @return {boolean}
 */
SVGSVGElement.prototype.animationsPaused = function() {};

/**
 * @return {number}
 */
SVGSVGElement.prototype.getCurrentTime = function() {};

/**
 * @param {number} seconds
 */
SVGSVGElement.prototype.setCurrentTime = function(seconds) {};

/**
 * @param {SVGRect} rect
 * @param {SVGElement} referenceElement
 * @return {NodeList}
 */
SVGSVGElement.prototype.getIntersectionList = function(rect, referenceElement) {};

/**
 * @param {SVGRect} rect
 * @param {SVGElement} referenceElement
 * @return {NodeList}
 */
SVGSVGElement.prototype.getEnclosureList = function(rect, referenceElement) {};

/**
 * @param {SVGElement} element
 * @param {SVGRect} rect
 * @return {boolean}
 */
SVGSVGElement.prototype.checkIntersection = function(element, rect) {};

/**
 * @param {SVGElement} element
 * @param {SVGRect} rect
 * @return {boolean}
 */
SVGSVGElement.prototype.checkEnclosure = function(element, rect) {};

/** */
SVGSVGElement.prototype.deselectAll = function() {};

/**
 * @return {SVGNumber}
 */
SVGSVGElement.prototype.createSVGNumber = function() {};

/**
 * @return {SVGLength}
 */
SVGSVGElement.prototype.createSVGLength = function() {};

/**
 * @return {SVGAngle}
 */
SVGSVGElement.prototype.createSVGAngle = function() {};

/**
 * @return {SVGPoint}
 */
SVGSVGElement.prototype.createSVGPoint = function() {};

/**
 * @return {SVGMatrix}
 */
SVGSVGElement.prototype.createSVGMatrix = function() {};

/**
 * @return {SVGRect}
 */
SVGSVGElement.prototype.createSVGRect = function() {};

/**
 * @return {SVGTransform}
 */
SVGSVGElement.prototype.createSVGTransform = function() {};

/**
 * @param {SVGMatrix} matrix
 * @return {SVGTransform}
 */
SVGSVGElement.prototype.createSVGTransformFromMatrix = function(matrix) {};

/**
 * @param {string} elementId
 * @return {Element}
 */
SVGSVGElement.prototype.getElementById = function(elementId) {};


/**
 * @constructor
 * @extends {EventTarget}
 */
function SVGElementInstance() {}

/**
 * @type {SVGElement}
 */
SVGElementInstance.prototype.correspondingElement;

/**
 * @type {SVGUseElement}
 */
SVGElementInstance.prototype.correspondingUseElement;

/**
 * @type {SVGElementInstance}
 */
SVGElementInstance.prototype.parentNode;

/**
 * @type {SVGElementInstanceList}
 */
SVGElementInstance.prototype.childNodes;

/**
 * @type {SVGElementInstance}
 */
SVGElementInstance.prototype.firstChild;

/**
 * @type {SVGElementInstance}
 */
SVGElementInstance.prototype.lastChild;

/**
 * @type {SVGElementInstance}
 */
SVGElementInstance.prototype.previousSibling;

/**
 * @type {SVGElementInstance}
 */
SVGElementInstance.prototype.nextSibling;


/**
 * @constructor
 */
function SVGElementInstanceList() {}

/**
 * @type {number}
 */
SVGElementInstanceList.prototype.length;

/**
 * @param {number} index
 * @return {SVGElementInstance}
 */
SVGElementInstanceList.prototype.item = function(index) {};


/**
 * @constructor
 */
function SVGAnimatedBoolean() {}

/**
 * @type {boolean}
 */
SVGAnimatedBoolean.prototype.baseVal;

/**
 * @type {boolean}
 */
SVGAnimatedBoolean.prototype.animVal;


/**
 * @constructor
 */
function SVGAnimatedString() {}

/**
 * @type {string}
 */
SVGAnimatedString.prototype.baseVal;

/**
 * @type {string}
 */
SVGAnimatedString.prototype.animVal;


/**
 * @constructor
 */
function SVGStringList() {}

/**
 * @type {number}
 */
SVGStringList.prototype.numberOfItems;

/** */
SVGStringList.prototype.clear = function() {};

/**
 * @param {string} newItem
 * @return {string}
 */
SVGStringList.prototype.initialize = function(newItem) {};

/**
 * @param {number} index
 * @return {string}
 */
SVGStringList.prototype.getItem = function(index) {};

/**
 * @param {string} newItem
 * @param {number} index
 * @return {string}
 */
SVGStringList.prototype.insertItemBefore = function(newItem, index) {};

/**
 * @param {string} newItem
 * @param {number} index
 * @return {string}
 */
SVGStringList.prototype.replaceItem = function(newItem, index) {};

/**
 * @param {number} index
 * @return {string}
 */
SVGStringList.prototype.removeItem = function(index) {};

/**
 * @param {string} newItem
 * @return {string}
 */
SVGStringList.prototype.appendItem = function(newItem) {};


/**
 * @constructor
 */
function SVGAnimatedEnumeration() {}

/**
 * @type {number}
 */
SVGAnimatedEnumeration.prototype.baseVal;

/**
 * @type {number}
 */
SVGAnimatedEnumeration.prototype.animVal;


/**
 * @constructor
 */
function SVGAnimatedInteger() {}

/**
 * @type {number}
 */
SVGAnimatedInteger.prototype.baseVal;

/**
 * @type {number}
 */
SVGAnimatedInteger.prototype.animVal;


/**
 * @constructor
 */
function SVGNumber() {}

/**
 * @type {number}
 */
SVGNumber.prototype.value;


/**
 * @constructor
 */
function SVGAnimatedNumber() {}

/**
 * @type {number}
 */
SVGAnimatedNumber.prototype.baseVal;

/**
 * @type {number}
 */
SVGAnimatedNumber.prototype.animVal;


/**
 * @constructor
 */
function SVGNumberList() {}

/**
 * @type {number}
 */
SVGNumberList.prototype.numberOfItems;

/** */
SVGNumberList.prototype.clear = function() {};

/**
 * @param {SVGNumber} newItem
 * @return {SVGNumber}
 */
SVGNumberList.prototype.initialize = function(newItem) {};

/**
 * @param {number} index
 * @return {SVGNumber}
 */
SVGNumberList.prototype.getItem = function(index) {};

/**
 * @param {SVGNumber} newItem
 * @param {number} index
 * @return {SVGNumber}
 */
SVGNumberList.prototype.insertItemBefore = function(newItem, index) {};

/**
 * @param {SVGNumber} newItem
 * @param {number} index
 * @return {SVGNumber}
 */
SVGNumberList.prototype.replaceItem = function(newItem, index) {};

/**
 * @param {number} index
 * @return {SVGNumber}
 */
SVGNumberList.prototype.removeItem = function(index) {};

/**
 * @param {SVGNumber} newItem
 * @return {SVGNumber}
 */
SVGNumberList.prototype.appendItem = function(newItem) {};


/**
 * @constructor
 */
function SVGAnimatedNumberList() {}

/**
 * @type {SVGNumberList}
 */
SVGAnimatedNumberList.prototype.baseVal;

/**
 * @type {SVGNumberList}
 */
SVGAnimatedNumberList.prototype.animVal;


/**
 * @constructor
 */
function SVGLength() {}

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_NUMBER;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_PERCENTAGE;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_EMS;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_EXS;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_PX;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_CM;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_MM;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_IN;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_PT;

/**
 * @const
 * @type {number}
 */
SVGLength.SVG_LENGTHTYPE_PC;

/**
 * @type {number}
 */
SVGLength.prototype.unitType;

/**
 * @type {number}
 */
SVGLength.prototype.value;

/**
 * @type {number}
 */
SVGLength.prototype.valueInSpecifiedUnits;

/**
 * @type {string}
 */
SVGLength.prototype.valueAsString;

/**
 * @param {number} unitType
 * @param {number} valueInSpecifiedUnits
 */
SVGLength.prototype.newValueSpecifiedUnits = function(unitType, valueInSpecifiedUnits) {};

/**
 * @param {number} unitType
 */
SVGLength.prototype.convertToSpecifiedUnits = function(unitType) {};


/**
 * @constructor
 */
function SVGAnimatedLength() {}

/**
 * @type {SVGLength}
 */
SVGAnimatedLength.prototype.baseVal;

/**
 * @type {SVGLength}
 */
SVGAnimatedLength.prototype.animVal;


/**
 * @constructor
 */
function SVGLengthList() {}

/**
 * @type {number}
 */
SVGLengthList.prototype.numberOfItems;

/** */
SVGLengthList.prototype.clear = function() {};

/**
 * @param {SVGLength} newItem
 * @return {SVGLength}
 */
SVGLengthList.prototype.initialize = function(newItem) {};

/**
 * @param {number} index
 * @return {SVGLength}
 */
SVGLengthList.prototype.getItem = function(index) {};

/**
 * @param {SVGLength} newItem
 * @param {number} index
 * @return {SVGLength}
 */
SVGLengthList.prototype.insertItemBefore = function(newItem, index) {};

/**
 * @param {SVGLength} newItem
 * @param {number} index
 * @return {SVGLength}
 */
SVGLengthList.prototype.replaceItem = function(newItem, index) {};

/**
 * @param {number} index
 * @return {SVGLength}
 */
SVGLengthList.prototype.removeItem = function(index) {};

/**
 * @param {SVGLength} newItem
 * @return {SVGLength}
 */
SVGLengthList.prototype.appendItem = function(newItem) {};


/**
 * @constructor
 */
function SVGAnimatedLengthList() {}

/**
 * @type {SVGLengthList}
 */
SVGAnimatedLengthList.prototype.baseVal;

/**
 * @type {SVGLengthList}
 */
SVGAnimatedLengthList.prototype.animVal;


/**
 * @constructor
 */
function SVGAngle() {}

/**
 * @const
 * @type {number}
 */
SVGAngle.SVG_ANGLETYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGAngle.SVG_ANGLETYPE_UNSPECIFIED;

/**
 * @const
 * @type {number}
 */
SVGAngle.SVG_ANGLETYPE_DEG;

/**
 * @const
 * @type {number}
 */
SVGAngle.SVG_ANGLETYPE_RAD;

/**
 * @const
 * @type {number}
 */
SVGAngle.SVG_ANGLETYPE_GRAD;

/**
 * @type {number}
 */
SVGAngle.prototype.unitType;

/**
 * @type {number}
 */
SVGAngle.prototype.value;

/**
 * @type {number}
 */
SVGAngle.prototype.valueInSpecifiedUnits;

/**
 * @type {string}
 */
SVGAngle.prototype.valueAsString;

/**
 * @param {number} unitType
 * @param {number} valueInSpecifiedUnits
 */
SVGAngle.prototype.newValueSpecifiedUnits = function(unitType, valueInSpecifiedUnits) {};

/**
 * @param {number} unitType
 */
SVGAngle.prototype.convertToSpecifiedUnits = function(unitType) {};


/**
 * @constructor
 */
function SVGAnimatedAngle() {}

/**
 * @type {SVGAngle}
 */
SVGAnimatedAngle.prototype.baseVal;

/**
 * @type {SVGAngle}
 */
SVGAnimatedAngle.prototype.animVal;


/**
 * @constructor
 */
function SVGRect() {}

/**
 * @type {number}
 */
SVGRect.prototype.x;

/**
 * @type {number}
 */
SVGRect.prototype.y;

/**
 * @type {number}
 */
SVGRect.prototype.width;

/**
 * @type {number}
 */
SVGRect.prototype.height;


/**
 * @constructor
 */
function SVGAnimatedRect() {}

/**
 * @type {SVGRect}
 */
SVGAnimatedRect.prototype.baseVal;

/**
 * @type {SVGRect}
 */
SVGAnimatedRect.prototype.animVal;


/**
 * @constructor
 */
function SVGUnitTypes() {}

/**
 * @const
 * @type {number}
 */
SVGUnitTypes.SVG_UNIT_TYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGUnitTypes.SVG_UNIT_TYPE_USERSPACEONUSE;

/**
 * @const
 * @type {number}
 */
SVGUnitTypes.SVG_UNIT_TYPE_OBJECTBOUNDINGBOX;


/**
 * @constructor
 */
function SVGStylable() {}

/**
 * @type {SVGAnimatedString}
 */
SVGStylable.prototype.className;

/**
 * @type {CSSStyleDeclaration}
 */
SVGStylable.prototype.style;

/**
 * @param {string} name
 * @return {CSSValue}
 */
SVGStylable.prototype.getPresentationAttribute = function(name) {};


/**
 * @constructor
 */
function SVGLocatable() {}

/**
 * @type {SVGElement}
 */
SVGLocatable.prototype.nearestViewportElement;

/**
 * @type {SVGElement}
 */
SVGLocatable.prototype.farthestViewportElement;

/**
 * @return {SVGRect}
 */
SVGLocatable.prototype.getBBox = function() {};

/**
 * @return {SVGMatrix}
 */
SVGLocatable.prototype.getCTM = function() {};

/**
 * @return {SVGMatrix}
 */
SVGLocatable.prototype.getScreenCTM = function() {};

/**
 * @param {SVGElement} element
 * @return {SVGMatrix}
 */
SVGLocatable.prototype.getTransformToElement = function(element) {};


/**
 * @constructor
 * @extends {CSSRule}
 */
function SVGCSSRule() {}

/**
 * @const
 * @type {number}
 */
SVGCSSRule.COLOR_PROFILE_RULE;


/**
 * @constructor
 */
function SVGRenderingIntent() {}

/**
 * @const
 * @type {number}
 */
SVGRenderingIntent.RENDERING_INTENT_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGRenderingIntent.RENDERING_INTENT_AUTO;

/**
 * @const
 * @type {number}
 */
SVGRenderingIntent.RENDERING_INTENT_PERCEPTUAL;

/**
 * @const
 * @type {number}
 */
SVGRenderingIntent.RENDERING_INTENT_RELATIVE_COLORIMETRIC;

/**
 * @const
 * @type {number}
 */
SVGRenderingIntent.RENDERING_INTENT_SATURATION;

/**
 * @const
 * @type {number}
 */
SVGRenderingIntent.RENDERING_INTENT_ABSOLUTE_COLORIMETRIC;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGGElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGDefsElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGLangSpace}
 * @implements {SVGStylable}
 */
function SVGDescElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGLangSpace}
 * @implements {SVGStylable}
 */
function SVGTitleElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGFitToViewBox}
 */
function SVGSymbolElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGUseElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGUseElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGUseElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGUseElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGUseElement.prototype.height;

/**
 * @type {SVGElementInstance}
 */
SVGUseElement.prototype.instanceRoot;

/**
 * @type {SVGElementInstance}
 */
SVGUseElement.prototype.animatedInstanceRoot;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGImageElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGImageElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGImageElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGImageElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGImageElement.prototype.height;

/**
 * @type {SVGAnimatedPreserveAspectRatio}
 */
SVGImageElement.prototype.preserveAspectRatio;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGSwitchElement() {}


/**
 * @constructor
 */
function GetSVGDocument() {}

/**
 * @return {SVGDocument}
 */
GetSVGDocument.prototype.getSVGDocument = function() {};


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGLangSpace}
 */
function SVGStyleElement() {}

/**
 * @type {string}
 */
SVGStyleElement.prototype.type;

/**
 * @type {string}
 */
SVGStyleElement.prototype.media;

/**
 * @type {string}
 */
SVGStyleElement.prototype.title;


/**
 * @constructor
 */
function SVGPointList() {}

/**
 * @type {number}
 */
SVGPointList.prototype.numberOfItems;

/** */
SVGPointList.prototype.clear = function() {};

/**
 * @param {SVGPoint} newItem
 * @return {SVGPoint}
 */
SVGPointList.prototype.initialize = function(newItem) {};

/**
 * @param {number} index
 * @return {SVGPoint}
 */
SVGPointList.prototype.getItem = function(index) {};

/**
 * @param {SVGPoint} newItem
 * @param {number} index
 * @return {SVGPoint}
 */
SVGPointList.prototype.insertItemBefore = function(newItem, index) {};

/**
 * @param {SVGPoint} newItem
 * @param {number} index
 * @return {SVGPoint}
 */
SVGPointList.prototype.replaceItem = function(newItem, index) {};

/**
 * @param {number} index
 * @return {SVGPoint}
 */
SVGPointList.prototype.removeItem = function(index) {};

/**
 * @param {SVGPoint} newItem
 * @return {SVGPoint}
 */
SVGPointList.prototype.appendItem = function(newItem) {};


/**
 * @constructor
 */
function SVGPathSeg() {}

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CLOSEPATH;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_MOVETO_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_MOVETO_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_LINETO_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_LINETO_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_CUBIC_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_CUBIC_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_ARC_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_ARC_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_LINETO_HORIZONTAL_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_LINETO_VERTICAL_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_LINETO_VERTICAL_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_CUBIC_SMOOTH_REL;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_ABS;

/**
 * @const
 * @type {number}
 */
SVGPathSeg.PATHSEG_CURVETO_QUADRATIC_SMOOTH_REL;

/**
 * @type {number}
 */
SVGPathSeg.prototype.pathSegType;

/**
 * @type {string}
 */
SVGPathSeg.prototype.pathSegTypeAsLetter;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegClosePath() {}


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegMovetoAbs() {}

/**
 * @type {number}
 */
SVGPathSegMovetoAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegMovetoAbs.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegMovetoRel() {}

/**
 * @type {number}
 */
SVGPathSegMovetoRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegMovetoRel.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegLinetoAbs() {}

/**
 * @type {number}
 */
SVGPathSegLinetoAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegLinetoAbs.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegLinetoRel() {}

/**
 * @type {number}
 */
SVGPathSegLinetoRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegLinetoRel.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoCubicAbs() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicAbs.prototype.y;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicAbs.prototype.x1;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicAbs.prototype.y1;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicAbs.prototype.x2;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicAbs.prototype.y2;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoCubicRel() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicRel.prototype.y;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicRel.prototype.x1;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicRel.prototype.y1;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicRel.prototype.x2;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicRel.prototype.y2;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoQuadraticAbs() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticAbs.prototype.y;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticAbs.prototype.x1;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticAbs.prototype.y1;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoQuadraticRel() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticRel.prototype.y;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticRel.prototype.x1;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticRel.prototype.y1;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegArcAbs() {}

/**
 * @type {number}
 */
SVGPathSegArcAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegArcAbs.prototype.y;

/**
 * @type {number}
 */
SVGPathSegArcAbs.prototype.r1;

/**
 * @type {number}
 */
SVGPathSegArcAbs.prototype.r2;

/**
 * @type {number}
 */
SVGPathSegArcAbs.prototype.angle;

/**
 * @type {boolean}
 */
SVGPathSegArcAbs.prototype.largeArcFlag;

/**
 * @type {boolean}
 */
SVGPathSegArcAbs.prototype.sweepFlag;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegArcRel() {}

/**
 * @type {number}
 */
SVGPathSegArcRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegArcRel.prototype.y;

/**
 * @type {number}
 */
SVGPathSegArcRel.prototype.r1;

/**
 * @type {number}
 */
SVGPathSegArcRel.prototype.r2;

/**
 * @type {number}
 */
SVGPathSegArcRel.prototype.angle;

/**
 * @type {boolean}
 */
SVGPathSegArcRel.prototype.largeArcFlag;

/**
 * @type {boolean}
 */
SVGPathSegArcRel.prototype.sweepFlag;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegLinetoHorizontalAbs() {}

/**
 * @type {number}
 */
SVGPathSegLinetoHorizontalAbs.prototype.x;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegLinetoHorizontalRel() {}

/**
 * @type {number}
 */
SVGPathSegLinetoHorizontalRel.prototype.x;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegLinetoVerticalAbs() {}

/**
 * @type {number}
 */
SVGPathSegLinetoVerticalAbs.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegLinetoVerticalRel() {}

/**
 * @type {number}
 */
SVGPathSegLinetoVerticalRel.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoCubicSmoothAbs() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothAbs.prototype.y;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothAbs.prototype.x2;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothAbs.prototype.y2;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoCubicSmoothRel() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothRel.prototype.y;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothRel.prototype.x2;

/**
 * @type {number}
 */
SVGPathSegCurvetoCubicSmoothRel.prototype.y2;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoQuadraticSmoothAbs() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticSmoothAbs.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticSmoothAbs.prototype.y;


/**
 * @constructor
 * @extends {SVGPathSeg}
 */
function SVGPathSegCurvetoQuadraticSmoothRel() {}

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticSmoothRel.prototype.x;

/**
 * @type {number}
 */
SVGPathSegCurvetoQuadraticSmoothRel.prototype.y;


/**
 * @constructor
 */
function SVGPathSegList() {}

/**
 * @type {number}
 */
SVGPathSegList.prototype.numberOfItems;

/** */
SVGPathSegList.prototype.clear = function() {};

/**
 * @param {SVGPathSeg} newItem
 * @return {SVGPathSeg}
 */
SVGPathSegList.prototype.initialize = function(newItem) {};

/**
 * @param {number} index
 * @return {SVGPathSeg}
 */
SVGPathSegList.prototype.getItem = function(index) {};

/**
 * @param {SVGPathSeg} newItem
 * @param {number} index
 * @return {SVGPathSeg}
 */
SVGPathSegList.prototype.insertItemBefore = function(newItem, index) {};

/**
 * @param {SVGPathSeg} newItem
 * @param {number} index
 * @return {SVGPathSeg}
 */
SVGPathSegList.prototype.replaceItem = function(newItem, index) {};

/**
 * @param {number} index
 * @return {SVGPathSeg}
 */
SVGPathSegList.prototype.removeItem = function(index) {};

/**
 * @param {SVGPathSeg} newItem
 * @return {SVGPathSeg}
 */
SVGPathSegList.prototype.appendItem = function(newItem) {};


/**
 * @constructor
 */
function SVGAnimatedPathData() {}

/**
 * @type {SVGPathSegList}
 */
SVGAnimatedPathData.prototype.pathSegList;

/**
 * @type {SVGPathSegList}
 */
SVGAnimatedPathData.prototype.normalizedPathSegList;

/**
 * @type {SVGPathSegList}
 */
SVGAnimatedPathData.prototype.animatedPathSegList;

/**
 * @type {SVGPathSegList}
 */
SVGAnimatedPathData.prototype.animatedNormalizedPathSegList;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 * @implements {SVGAnimatedPathData}
 */
function SVGPathElement() {}

/**
 * @type {SVGAnimatedNumber}
 */
SVGPathElement.prototype.pathLength;

/**
 * @return {number}
 */
SVGPathElement.prototype.getTotalLength = function() {};

/**
 * @param {number} distance
 * @return {SVGPoint}
 */
SVGPathElement.prototype.getPointAtLength = function(distance) {};

/**
 * @param {number} distance
 * @return {number}
 */
SVGPathElement.prototype.getPathSegAtLength = function(distance) {};

/**
 * @return {SVGPathSegClosePath}
 */
SVGPathElement.prototype.createSVGPathSegClosePath = function() {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGPathSegMovetoAbs}
 */
SVGPathElement.prototype.createSVGPathSegMovetoAbs = function(x, y) {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGPathSegMovetoRel}
 */
SVGPathElement.prototype.createSVGPathSegMovetoRel = function(x, y) {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGPathSegLinetoAbs}
 */
SVGPathElement.prototype.createSVGPathSegLinetoAbs = function(x, y) {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGPathSegLinetoRel}
 */
SVGPathElement.prototype.createSVGPathSegLinetoRel = function(x, y) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} x1
 * @param {number} y1
 * @param {number} x2
 * @param {number} y2
 * @return {SVGPathSegCurvetoCubicAbs}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoCubicAbs = function(x, y, x1, y1, x2, y2) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} x1
 * @param {number} y1
 * @param {number} x2
 * @param {number} y2
 * @return {SVGPathSegCurvetoCubicRel}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoCubicRel = function(x, y, x1, y1, x2, y2) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} x1
 * @param {number} y1
 * @return {SVGPathSegCurvetoQuadraticAbs}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticAbs = function(x, y, x1, y1) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} x1
 * @param {number} y1
 * @return {SVGPathSegCurvetoQuadraticRel}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticRel = function(x, y, x1, y1) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} r1
 * @param {number} r2
 * @param {number} angle
 * @param {boolean} largeArcFlag
 * @param {boolean} sweepFlag
 * @return {SVGPathSegArcAbs}
 */
SVGPathElement.prototype.createSVGPathSegArcAbs = function(x, y, r1, r2, angle, largeArcFlag, sweepFlag) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} r1
 * @param {number} r2
 * @param {number} angle
 * @param {boolean} largeArcFlag
 * @param {boolean} sweepFlag
 * @return {SVGPathSegArcRel}
 */
SVGPathElement.prototype.createSVGPathSegArcRel = function(x, y, r1, r2, angle, largeArcFlag, sweepFlag) {};

/**
 * @param {number} x
 * @return {SVGPathSegLinetoHorizontalAbs}
 */
SVGPathElement.prototype.createSVGPathSegLinetoHorizontalAbs = function(x) {};

/**
 * @param {number} x
 * @return {SVGPathSegLinetoHorizontalRel}
 */
SVGPathElement.prototype.createSVGPathSegLinetoHorizontalRel = function(x) {};

/**
 * @param {number} y
 * @return {SVGPathSegLinetoVerticalAbs}
 */
SVGPathElement.prototype.createSVGPathSegLinetoVerticalAbs = function(y) {};

/**
 * @param {number} y
 * @return {SVGPathSegLinetoVerticalRel}
 */
SVGPathElement.prototype.createSVGPathSegLinetoVerticalRel = function(y) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} x2
 * @param {number} y2
 * @return {SVGPathSegCurvetoCubicSmoothAbs}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothAbs = function(x, y, x2, y2) {};

/**
 * @param {number} x
 * @param {number} y
 * @param {number} x2
 * @param {number} y2
 * @return {SVGPathSegCurvetoCubicSmoothRel}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoCubicSmoothRel = function(x, y, x2, y2) {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGPathSegCurvetoQuadraticSmoothAbs}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothAbs = function(x, y) {};

/**
 * @param {number} x
 * @param {number} y
 * @return {SVGPathSegCurvetoQuadraticSmoothRel}
 */
SVGPathElement.prototype.createSVGPathSegCurvetoQuadraticSmoothRel = function(x, y) {};


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGRectElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGRectElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGRectElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGRectElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGRectElement.prototype.height;

/**
 * @type {SVGAnimatedLength}
 */
SVGRectElement.prototype.rx;

/**
 * @type {SVGAnimatedLength}
 */
SVGRectElement.prototype.ry;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGCircleElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGCircleElement.prototype.cx;

/**
 * @type {SVGAnimatedLength}
 */
SVGCircleElement.prototype.cy;

/**
 * @type {SVGAnimatedLength}
 */
SVGCircleElement.prototype.r;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGEllipseElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGEllipseElement.prototype.cx;

/**
 * @type {SVGAnimatedLength}
 */
SVGEllipseElement.prototype.cy;

/**
 * @type {SVGAnimatedLength}
 */
SVGEllipseElement.prototype.rx;

/**
 * @type {SVGAnimatedLength}
 */
SVGEllipseElement.prototype.ry;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGLineElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGLineElement.prototype.x1;

/**
 * @type {SVGAnimatedLength}
 */
SVGLineElement.prototype.y1;

/**
 * @type {SVGAnimatedLength}
 */
SVGLineElement.prototype.x2;

/**
 * @type {SVGAnimatedLength}
 */
SVGLineElement.prototype.y2;


/**
 * @constructor
 */
function SVGAnimatedPoints() {}

/**
 * @type {SVGPointList}
 */
SVGAnimatedPoints.prototype.points;

/**
 * @type {SVGPointList}
 */
SVGAnimatedPoints.prototype.animatedPoints;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 * @implements {SVGAnimatedPoints}
 */
function SVGPolylineElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 * @implements {SVGAnimatedPoints}
 */
function SVGPolygonElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 */
function SVGTextContentElement() {}

/**
 * @const
 * @type {number}
 */
SVGTextContentElement.LENGTHADJUST_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGTextContentElement.LENGTHADJUST_SPACING;

/**
 * @const
 * @type {number}
 */
SVGTextContentElement.LENGTHADJUST_SPACINGANDGLYPHS;

/**
 * @type {SVGAnimatedLength}
 */
SVGTextContentElement.prototype.textLength;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGTextContentElement.prototype.lengthAdjust;

/**
 * @return {number}
 */
SVGTextContentElement.prototype.getNumberOfChars = function() {};

/**
 * @return {number}
 */
SVGTextContentElement.prototype.getComputedTextLength = function() {};

/**
 * @param {number} charnum
 * @param {number} nchars
 * @return {number}
 */
SVGTextContentElement.prototype.getSubStringLength = function(charnum, nchars) {};

/**
 * @param {number} charnum
 * @return {SVGPoint}
 */
SVGTextContentElement.prototype.getStartPositionOfChar = function(charnum) {};

/**
 * @param {number} charnum
 * @return {SVGPoint}
 */
SVGTextContentElement.prototype.getEndPositionOfChar = function(charnum) {};

/**
 * @param {number} charnum
 * @return {SVGRect}
 */
SVGTextContentElement.prototype.getExtentOfChar = function(charnum) {};

/**
 * @param {number} charnum
 * @return {number}
 */
SVGTextContentElement.prototype.getRotationOfChar = function(charnum) {};

/**
 * @param {SVGPoint} point
 * @return {number}
 */
SVGTextContentElement.prototype.getCharNumAtPosition = function(point) {};

/**
 * @param {number} charnum
 * @param {number} nchars
 */
SVGTextContentElement.prototype.selectSubString = function(charnum, nchars) {};


/**
 * @constructor
 * @extends {SVGTextContentElement}
 */
function SVGTextPositioningElement() {}

/**
 * @type {SVGAnimatedLengthList}
 */
SVGTextPositioningElement.prototype.x;

/**
 * @type {SVGAnimatedLengthList}
 */
SVGTextPositioningElement.prototype.y;

/**
 * @type {SVGAnimatedLengthList}
 */
SVGTextPositioningElement.prototype.dx;

/**
 * @type {SVGAnimatedLengthList}
 */
SVGTextPositioningElement.prototype.dy;

/**
 * @type {SVGAnimatedNumberList}
 */
SVGTextPositioningElement.prototype.rotate;


/**
 * @constructor
 * @extends {SVGTextPositioningElement}
 * @implements {SVGTransformable}
 */
function SVGTextElement() {}


/**
 * @constructor
 * @extends {SVGTextPositioningElement}
 */
function SVGTSpanElement() {}


/**
 * @constructor
 * @extends {SVGTextPositioningElement}
 * @implements {SVGURIReference}
 */
function SVGTRefElement() {}


/**
 * @constructor
 * @extends {SVGTextContentElement}
 * @implements {SVGURIReference}
 */
function SVGTextPathElement() {}

/**
 * @const
 * @type {number}
 */
SVGTextPathElement.TEXTPATH_METHODTYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGTextPathElement.TEXTPATH_METHODTYPE_ALIGN;

/**
 * @const
 * @type {number}
 */
SVGTextPathElement.TEXTPATH_METHODTYPE_STRETCH;

/**
 * @const
 * @type {number}
 */
SVGTextPathElement.TEXTPATH_SPACINGTYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGTextPathElement.TEXTPATH_SPACINGTYPE_AUTO;

/**
 * @const
 * @type {number}
 */
SVGTextPathElement.TEXTPATH_SPACINGTYPE_EXACT;

/**
 * @type {SVGAnimatedLength}
 */
SVGTextPathElement.prototype.startOffset;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGTextPathElement.prototype.method;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGTextPathElement.prototype.spacing;


/**
 * @constructor
 * @extends {SVGTextPositioningElement}
 * @implements {SVGURIReference}
 */
function SVGAltGlyphElement() {}

/**
 * @type {string}
 */
SVGAltGlyphElement.prototype.glyphRef;

/**
 * @type {string}
 */
SVGAltGlyphElement.prototype.format;


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGAltGlyphDefElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGAltGlyphItemElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGStylable}
 */
function SVGGlyphRefElement() {}

/**
 * @type {string}
 */
SVGGlyphRefElement.prototype.glyphRef;

/**
 * @type {string}
 */
SVGGlyphRefElement.prototype.format;

/**
 * @type {number}
 */
SVGGlyphRefElement.prototype.x;

/**
 * @type {number}
 */
SVGGlyphRefElement.prototype.y;

/**
 * @type {number}
 */
SVGGlyphRefElement.prototype.dx;

/**
 * @type {number}
 */
SVGGlyphRefElement.prototype.dy;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGFitToViewBox}
 */
function SVGMarkerElement() {}

/**
 * @const
 * @type {number}
 */
SVGMarkerElement.SVG_MARKERUNITS_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGMarkerElement.SVG_MARKERUNITS_USERSPACEONUSE;

/**
 * @const
 * @type {number}
 */
SVGMarkerElement.SVG_MARKERUNITS_STROKEWIDTH;

/**
 * @const
 * @type {number}
 */
SVGMarkerElement.SVG_MARKER_ORIENT_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGMarkerElement.SVG_MARKER_ORIENT_AUTO;

/**
 * @const
 * @type {number}
 */
SVGMarkerElement.SVG_MARKER_ORIENT_ANGLE;

/**
 * @type {SVGAnimatedLength}
 */
SVGMarkerElement.prototype.refX;

/**
 * @type {SVGAnimatedLength}
 */
SVGMarkerElement.prototype.refY;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGMarkerElement.prototype.markerUnits;

/**
 * @type {SVGAnimatedLength}
 */
SVGMarkerElement.prototype.markerWidth;

/**
 * @type {SVGAnimatedLength}
 */
SVGMarkerElement.prototype.markerHeight;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGMarkerElement.prototype.orientType;

/**
 * @type {SVGAnimatedAngle}
 */
SVGMarkerElement.prototype.orientAngle;

/** */
SVGMarkerElement.prototype.setOrientToAuto = function() {};

/**
 * @param {SVGAngle} angle
 */
SVGMarkerElement.prototype.setOrientToAngle = function(angle) {};


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGRenderingIntent}
 */
function SVGColorProfileElement() {}

/**
 * @type {string}
 */
SVGColorProfileElement.prototype.local;

/**
 * @type {string}
 */
SVGColorProfileElement.prototype.name;

/**
 * @type {number}
 */
SVGColorProfileElement.prototype.renderingIntent;


/**
 * @constructor
 * @extends {SVGCSSRule}
 * @implements {SVGRenderingIntent}
 */
function SVGColorProfileRule() {}

/**
 * @type {string}
 */
SVGColorProfileRule.prototype.src;

/**
 * @type {string}
 */
SVGColorProfileRule.prototype.name;

/**
 * @type {number}
 */
SVGColorProfileRule.prototype.renderingIntent;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGUnitTypes}
 */
function SVGGradientElement() {}

/**
 * @const
 * @type {number}
 */
SVGGradientElement.SVG_SPREADMETHOD_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGGradientElement.SVG_SPREADMETHOD_PAD;

/**
 * @const
 * @type {number}
 */
SVGGradientElement.SVG_SPREADMETHOD_REFLECT;

/**
 * @const
 * @type {number}
 */
SVGGradientElement.SVG_SPREADMETHOD_REPEAT;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGGradientElement.prototype.gradientUnits;

/**
 * @type {SVGAnimatedTransformList}
 */
SVGGradientElement.prototype.gradientTransform;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGGradientElement.prototype.spreadMethod;


/**
 * @constructor
 * @extends {SVGGradientElement}
 */
function SVGLinearGradientElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGLinearGradientElement.prototype.x1;

/**
 * @type {SVGAnimatedLength}
 */
SVGLinearGradientElement.prototype.y1;

/**
 * @type {SVGAnimatedLength}
 */
SVGLinearGradientElement.prototype.x2;

/**
 * @type {SVGAnimatedLength}
 */
SVGLinearGradientElement.prototype.y2;


/**
 * @constructor
 * @extends {SVGGradientElement}
 */
function SVGRadialGradientElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGRadialGradientElement.prototype.cx;

/**
 * @type {SVGAnimatedLength}
 */
SVGRadialGradientElement.prototype.cy;

/**
 * @type {SVGAnimatedLength}
 */
SVGRadialGradientElement.prototype.r;

/**
 * @type {SVGAnimatedLength}
 */
SVGRadialGradientElement.prototype.fx;

/**
 * @type {SVGAnimatedLength}
 */
SVGRadialGradientElement.prototype.fy;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGStylable}
 */
function SVGStopElement() {}

/**
 * @type {SVGAnimatedNumber}
 */
SVGStopElement.prototype.offset;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGFitToViewBox}
 * @implements {SVGUnitTypes}
 */
function SVGPatternElement() {}

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGPatternElement.prototype.patternUnits;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGPatternElement.prototype.patternContentUnits;

/**
 * @type {SVGAnimatedTransformList}
 */
SVGPatternElement.prototype.patternTransform;

/**
 * @type {SVGAnimatedLength}
 */
SVGPatternElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGPatternElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGPatternElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGPatternElement.prototype.height;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 * @implements {SVGUnitTypes}
 */
function SVGClipPathElement() {}

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGClipPathElement.prototype.clipPathUnits;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGUnitTypes}
 */
function SVGMaskElement() {}

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGMaskElement.prototype.maskUnits;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGMaskElement.prototype.maskContentUnits;

/**
 * @type {SVGAnimatedLength}
 */
SVGMaskElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGMaskElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGMaskElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGMaskElement.prototype.height;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGUnitTypes}
 */
function SVGFilterElement() {}

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFilterElement.prototype.filterUnits;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFilterElement.prototype.primitiveUnits;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterElement.prototype.height;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFilterElement.prototype.filterResX;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFilterElement.prototype.filterResY;

/**
 * @param {number} filterResX
 * @param {number} filterResY
 */
SVGFilterElement.prototype.setFilterRes = function(filterResX, filterResY) {};


/**
 * @constructor
 * @extends {SVGStylable}
 */
function SVGFilterPrimitiveStandardAttributes() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterPrimitiveStandardAttributes.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterPrimitiveStandardAttributes.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterPrimitiveStandardAttributes.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGFilterPrimitiveStandardAttributes.prototype.height;

/**
 * @type {SVGAnimatedString}
 */
SVGFilterPrimitiveStandardAttributes.prototype.result;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEBlendElement() {}

/**
 * @const
 * @type {number}
 */
SVGFEBlendElement.SVG_FEBLEND_MODE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFEBlendElement.SVG_FEBLEND_MODE_NORMAL;

/**
 * @const
 * @type {number}
 */
SVGFEBlendElement.SVG_FEBLEND_MODE_MULTIPLY;

/**
 * @const
 * @type {number}
 */
SVGFEBlendElement.SVG_FEBLEND_MODE_SCREEN;

/**
 * @const
 * @type {number}
 */
SVGFEBlendElement.SVG_FEBLEND_MODE_DARKEN;

/**
 * @const
 * @type {number}
 */
SVGFEBlendElement.SVG_FEBLEND_MODE_LIGHTEN;

/**
 * @type {SVGAnimatedString}
 */
SVGFEBlendElement.prototype.in1;

/**
 * @type {SVGAnimatedString}
 */
SVGFEBlendElement.prototype.in2;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFEBlendElement.prototype.mode;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEColorMatrixElement() {}

/**
 * @const
 * @type {number}
 */
SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_MATRIX;

/**
 * @const
 * @type {number}
 */
SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_SATURATE;

/**
 * @const
 * @type {number}
 */
SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_HUEROTATE;

/**
 * @const
 * @type {number}
 */
SVGFEColorMatrixElement.SVG_FECOLORMATRIX_TYPE_LUMINANCETOALPHA;

/**
 * @type {SVGAnimatedString}
 */
SVGFEColorMatrixElement.prototype.in1;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFEColorMatrixElement.prototype.type;

/**
 * @type {SVGAnimatedNumberList}
 */
SVGFEColorMatrixElement.prototype.values;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEComponentTransferElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFEComponentTransferElement.prototype.in1;


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGComponentTransferFunctionElement() {}

/**
 * @const
 * @type {number}
 */
SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_IDENTITY;

/**
 * @const
 * @type {number}
 */
SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_TABLE;

/**
 * @const
 * @type {number}
 */
SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_DISCRETE;

/**
 * @const
 * @type {number}
 */
SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_LINEAR;

/**
 * @const
 * @type {number}
 */
SVGComponentTransferFunctionElement.SVG_FECOMPONENTTRANSFER_TYPE_GAMMA;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGComponentTransferFunctionElement.prototype.type;

/**
 * @type {SVGAnimatedNumberList}
 */
SVGComponentTransferFunctionElement.prototype.tableValues;

/**
 * @type {SVGAnimatedNumber}
 */
SVGComponentTransferFunctionElement.prototype.slope;

/**
 * @type {SVGAnimatedNumber}
 */
SVGComponentTransferFunctionElement.prototype.intercept;

/**
 * @type {SVGAnimatedNumber}
 */
SVGComponentTransferFunctionElement.prototype.amplitude;

/**
 * @type {SVGAnimatedNumber}
 */
SVGComponentTransferFunctionElement.prototype.exponent;

/**
 * @type {SVGAnimatedNumber}
 */
SVGComponentTransferFunctionElement.prototype.offset;


/**
 * @constructor
 * @extends {SVGComponentTransferFunctionElement}
 */
function SVGFEFuncRElement() {}


/**
 * @constructor
 * @extends {SVGComponentTransferFunctionElement}
 */
function SVGFEFuncGElement() {}


/**
 * @constructor
 * @extends {SVGComponentTransferFunctionElement}
 */
function SVGFEFuncBElement() {}


/**
 * @constructor
 * @extends {SVGComponentTransferFunctionElement}
 */
function SVGFEFuncAElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFECompositeElement() {}

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_OVER;

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_IN;

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_OUT;

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_ATOP;

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_XOR;

/**
 * @const
 * @type {number}
 */
SVGFECompositeElement.SVG_FECOMPOSITE_OPERATOR_ARITHMETIC;

/**
 * @type {SVGAnimatedString}
 */
SVGFECompositeElement.prototype.in1;

/**
 * @type {SVGAnimatedString}
 */
SVGFECompositeElement.prototype.in2;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFECompositeElement.prototype.operator;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFECompositeElement.prototype.k1;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFECompositeElement.prototype.k2;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFECompositeElement.prototype.k3;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFECompositeElement.prototype.k4;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEConvolveMatrixElement() {}

/**
 * @const
 * @type {number}
 */
SVGFEConvolveMatrixElement.SVG_EDGEMODE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFEConvolveMatrixElement.SVG_EDGEMODE_DUPLICATE;

/**
 * @const
 * @type {number}
 */
SVGFEConvolveMatrixElement.SVG_EDGEMODE_WRAP;

/**
 * @const
 * @type {number}
 */
SVGFEConvolveMatrixElement.SVG_EDGEMODE_NONE;

/**
 * @type {SVGAnimatedString}
 */
SVGFEConvolveMatrixElement.prototype.in1;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFEConvolveMatrixElement.prototype.orderX;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFEConvolveMatrixElement.prototype.orderY;

/**
 * @type {SVGAnimatedNumberList}
 */
SVGFEConvolveMatrixElement.prototype.kernelMatrix;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEConvolveMatrixElement.prototype.divisor;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEConvolveMatrixElement.prototype.bias;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFEConvolveMatrixElement.prototype.targetX;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFEConvolveMatrixElement.prototype.targetY;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFEConvolveMatrixElement.prototype.edgeMode;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEConvolveMatrixElement.prototype.kernelUnitLengthX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEConvolveMatrixElement.prototype.kernelUnitLengthY;

/**
 * @type {SVGAnimatedBoolean}
 */
SVGFEConvolveMatrixElement.prototype.preserveAlpha;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEDiffuseLightingElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFEDiffuseLightingElement.prototype.in1;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDiffuseLightingElement.prototype.surfaceScale;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDiffuseLightingElement.prototype.diffuseConstant;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDiffuseLightingElement.prototype.kernelUnitLengthX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDiffuseLightingElement.prototype.kernelUnitLengthY;


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFEDistantLightElement() {}

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDistantLightElement.prototype.azimuth;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDistantLightElement.prototype.elevation;


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFEPointLightElement() {}

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEPointLightElement.prototype.x;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEPointLightElement.prototype.y;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEPointLightElement.prototype.z;


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFESpotLightElement() {}

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.x;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.y;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.z;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.pointsAtX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.pointsAtY;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.pointsAtZ;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.specularExponent;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpotLightElement.prototype.limitingConeAngle;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEDisplacementMapElement() {}

/**
 * @const
 * @type {number}
 */
SVGFEDisplacementMapElement.SVG_CHANNEL_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFEDisplacementMapElement.SVG_CHANNEL_R;

/**
 * @const
 * @type {number}
 */
SVGFEDisplacementMapElement.SVG_CHANNEL_G;

/**
 * @const
 * @type {number}
 */
SVGFEDisplacementMapElement.SVG_CHANNEL_B;

/**
 * @const
 * @type {number}
 */
SVGFEDisplacementMapElement.SVG_CHANNEL_A;

/**
 * @type {SVGAnimatedString}
 */
SVGFEDisplacementMapElement.prototype.in1;

/**
 * @type {SVGAnimatedString}
 */
SVGFEDisplacementMapElement.prototype.in2;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEDisplacementMapElement.prototype.scale;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFEDisplacementMapElement.prototype.xChannelSelector;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFEDisplacementMapElement.prototype.yChannelSelector;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEFloodElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEGaussianBlurElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFEGaussianBlurElement.prototype.in1;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEGaussianBlurElement.prototype.stdDeviationX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEGaussianBlurElement.prototype.stdDeviationY;

/**
 * @param {number} stdDeviationX
 * @param {number} stdDeviationY
 */
SVGFEGaussianBlurElement.prototype.setStdDeviation = function(stdDeviationX, stdDeviationY) {};


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEImageElement() {}

/**
 * @type {SVGAnimatedPreserveAspectRatio}
 */
SVGFEImageElement.prototype.preserveAspectRatio;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEMergeElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFEMergeNodeElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFEMergeNodeElement.prototype.in1;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEMorphologyElement() {}

/**
 * @const
 * @type {number}
 */
SVGFEMorphologyElement.SVG_MORPHOLOGY_OPERATOR_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFEMorphologyElement.SVG_MORPHOLOGY_OPERATOR_ERODE;

/**
 * @const
 * @type {number}
 */
SVGFEMorphologyElement.SVG_MORPHOLOGY_OPERATOR_DILATE;

/**
 * @type {SVGAnimatedString}
 */
SVGFEMorphologyElement.prototype.in1;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFEMorphologyElement.prototype.operator;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEMorphologyElement.prototype.radiusX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEMorphologyElement.prototype.radiusY;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFEOffsetElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFEOffsetElement.prototype.in1;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEOffsetElement.prototype.dx;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFEOffsetElement.prototype.dy;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFESpecularLightingElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFESpecularLightingElement.prototype.in1;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpecularLightingElement.prototype.surfaceScale;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpecularLightingElement.prototype.specularConstant;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpecularLightingElement.prototype.specularExponent;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpecularLightingElement.prototype.kernelUnitLengthX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFESpecularLightingElement.prototype.kernelUnitLengthY;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFETileElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGFETileElement.prototype.in1;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGFilterPrimitiveStandardAttributes}
 */
function SVGFETurbulenceElement() {}

/**
 * @const
 * @type {number}
 */
SVGFETurbulenceElement.SVG_TURBULENCE_TYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFETurbulenceElement.SVG_TURBULENCE_TYPE_FRACTALNOISE;

/**
 * @const
 * @type {number}
 */
SVGFETurbulenceElement.SVG_TURBULENCE_TYPE_TURBULENCE;

/**
 * @const
 * @type {number}
 */
SVGFETurbulenceElement.SVG_STITCHTYPE_UNKNOWN;

/**
 * @const
 * @type {number}
 */
SVGFETurbulenceElement.SVG_STITCHTYPE_STITCH;

/**
 * @const
 * @type {number}
 */
SVGFETurbulenceElement.SVG_STITCHTYPE_NOSTITCH;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFETurbulenceElement.prototype.baseFrequencyX;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFETurbulenceElement.prototype.baseFrequencyY;

/**
 * @type {SVGAnimatedInteger}
 */
SVGFETurbulenceElement.prototype.numOctaves;

/**
 * @type {SVGAnimatedNumber}
 */
SVGFETurbulenceElement.prototype.seed;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFETurbulenceElement.prototype.stitchTiles;

/**
 * @type {SVGAnimatedEnumeration}
 */
SVGFETurbulenceElement.prototype.type;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGTests}
 * @implements {SVGExternalResourcesRequired}
 */
function SVGCursorElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGCursorElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGCursorElement.prototype.y;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGAElement() {}

/**
 * @type {SVGAnimatedString}
 */
SVGAElement.prototype.target;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGFitToViewBox}
 * @implements {SVGZoomAndPan}
 */
function SVGViewElement() {}

/**
 * @type {SVGStringList}
 */
SVGViewElement.prototype.viewTarget;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGExternalResourcesRequired}
 */
function SVGScriptElement() {}

/**
 * @type {string}
 */
SVGScriptElement.prototype.type;


/**
 * @constructor
 * @extends {UIEvent}
 */
function SVGZoomEvent() {}

/**
 * @type {SVGRect}
 */
SVGZoomEvent.prototype.zoomRectScreen;

/**
 * @type {number}
 */
SVGZoomEvent.prototype.previousScale;

/**
 * @type {SVGPoint}
 */
SVGZoomEvent.prototype.previousTranslate;

/**
 * @type {number}
 */
SVGZoomEvent.prototype.newScale;

/**
 * @type {SVGPoint}
 */
SVGZoomEvent.prototype.newTranslate;


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGExternalResourcesRequired}
 * @implements {ElementTimeControl}
 */
function SVGAnimationElement() {}

/**
 * @type {SVGElement}
 */
SVGAnimationElement.prototype.targetElement;

/**
 * @return {number}
 */
SVGAnimationElement.prototype.getStartTime = function() {};

/**
 * @return {number}
 */
SVGAnimationElement.prototype.getCurrentTime = function() {};

/**
 * @return {number}
 */
SVGAnimationElement.prototype.getSimpleDuration = function() {};


/**
 * @constructor
 * @extends {SVGAnimationElement}
 * @implements {SVGStylable}
 */
function SVGAnimateElement() {}


/**
 * @constructor
 * @extends {SVGAnimationElement}
 */
function SVGSetElement() {}


/**
 * @constructor
 * @extends {SVGAnimationElement}
 */
function SVGAnimateMotionElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGURIReference}
 * @implements {SVGExternalResourcesRequired}
 */
function SVGMPathElement() {}


/**
 * @constructor
 * @extends {SVGAnimationElement}
 * @implements {SVGStylable}
 */
function SVGAnimateColorElement() {}


/**
 * @constructor
 * @extends {SVGAnimationElement}
 */
function SVGAnimateTransformElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 */
function SVGFontElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGStylable}
 */
function SVGGlyphElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGStylable}
 */
function SVGMissingGlyphElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGHKernElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGVKernElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFontFaceElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFontFaceSrcElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFontFaceUriElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFontFaceFormatElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGFontFaceNameElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 */
function SVGMetadataElement() {}


/**
 * @constructor
 * @extends {SVGElement}
 * @implements {SVGTests}
 * @implements {SVGLangSpace}
 * @implements {SVGExternalResourcesRequired}
 * @implements {SVGStylable}
 * @implements {SVGTransformable}
 */
function SVGForeignObjectElement() {}

/**
 * @type {SVGAnimatedLength}
 */
SVGForeignObjectElement.prototype.x;

/**
 * @type {SVGAnimatedLength}
 */
SVGForeignObjectElement.prototype.y;

/**
 * @type {SVGAnimatedLength}
 */
SVGForeignObjectElement.prototype.width;

/**
 * @type {SVGAnimatedLength}
 */
SVGForeignObjectElement.prototype.height;


