;;This file autogenerated from 
;;
;;  src/cljx/c2/geo/geom.cljx
;;
(ns c2.geo.geom (:use [clojure.core.match :only [match]] [clojure.string :only [join]] [c2.maths :only [abs add sub div mul]]) (:require c2.geom.polygon))
(defn area "Calculate the area of a geoJSON feature.\n\n   Kwargs:\n   > *:projection* fn applied to each coordinate, defaults to identity. If your input coordinates are lat/lon, you probably want this to be `(albers :scale radius-of-earth)` since albers is an area-preserving projection." [geo & {:keys [projection], :or {projection identity}}] (let [polygon-area (fn [poly-coordinates] (let [area (fn [coordinates] (abs (c2.geom.polygon/area (map projection coordinates))))] (apply - (area (first poly-coordinates)) (map area (rest poly-coordinates)))))] (abs (match [geo] [{:type "FeatureCollection", :features xs}] (apply + (map area xs)) [{:type "Feature", :geometry g}] (area g) [{:type "Polygon", :coordinates xs}] (polygon-area xs) [{:type "MultiPolygon", :coordinates xs}] (apply + (map polygon-area xs))))))
(defn centroid "Calculate the centroid coordinates of a geoJSON feature.\n\n   Kwargs:\n   > *:projection* fn applied to each coordinate, defaults to identity." [geo & {:keys [projection], :or {projection identity}}] (let [polygon-centroid (fn [poly-coordinates] (let [areas (map (fn [coordinates] (abs (c2.geom.polygon/area (map projection coordinates)))) poly-coordinates)] {:centroid (div (apply sub (map (fn [coordinates area] (mul (c2.geom.polygon/centroid coordinates) area)) poly-coordinates areas)) (apply - areas)), :area (apply + areas)}))] (match [geo] [{:type "Feature", :geometry g}] (centroid g) [{:type "Polygon", :coordinates xs}] (:centroid (polygon-centroid xs)) [{:type "MultiPolygon", :coordinates xs}] (let [centroids (map polygon-centroid xs)] (div (apply add (map (fn [{:keys [centroid area]}] (mul centroid area)) centroids)) (apply add (map :area centroids)))))))