;;This file autogenerated from 
;;
;;  src/cljx/c2/layout/histogram.cljx
;;
(ns c2.layout.histogram (:use [c2.maths :only [log]]))
(defn- binary-search [v target] "VM agnostic j.u.Collections/binarySearch, from http://www.gettingclojure.com/cookbook:sequences" (loop [low 0 high (dec (count v))] (if (> low high) (- (inc low)) (let [mid (quot (+ low high) 2) mid-val (v mid)] (cond (< mid-val target) (recur (inc mid) high) (< target mid-val) (recur low (dec mid)) :else mid)))))
(defn- sturges "Calulate reasonable number of bins assuming an approximately normal\n  distribution" [values] (-> (count values) (log 2) int inc))
(defn- fixed-size-bins "Return the inclusive upper threshold of all bins" [[mn mx] n] (let [size (/ (- mx mn) n)] (vec (for [step (range (inc n))] (+ mn (* size step))))))
(defn histogram "The histogram layout transforms data by grouping descrete data points into\n  bins. Returns a collection of values with the following metadata set:\n\n  > *:x* the lower bound of the bin (inclusive).\n\n  > *:dx* the width of the bin; x + dx is the upper bound (exclusive).\n\n  > *:y* the count\n\n   Kwargs:\n\n   > *:value* fn that calculates value of node, defaults to `:value`\n\n   > *:index* opaque value passed to `:bins` and `:range`\n\n   > *:range* fn which calculates the minimum and maximum values given the array of values\n\n   > *:bins* Number of bins /or/ fn that takes the range, array of values, and current index" [data & {:keys [value index range bins], :or {value :value, range (fn [xs _] ((juxt (partial reduce min) (partial reduce max)) xs)), bins (fn [r xs _] (fixed-size-bins r (sturges xs)))}}] (let [values (map value data) r (cond (fn? range) (range values index) :else range) thresholds (cond (fn? bins) (bins r values index) (number? bins) (fixed-size-bins r bins) :else bins) binner (fn [e] (->> (value e) (binary-search (subvec thresholds 0 (dec (count thresholds)))) inc Math/abs dec)) groups (group-by binner (filter (fn* [p1__23836#] (and (>= (value p1__23836#) (r 0)) (<= (value p1__23836#) (r 1)))) data))] (map-indexed (fn [index [mn mx]] (let [group (or (groups index) [])] (with-meta group {:x mn, :dx (- mx mn), :y (count group)}))) (partition 2 1 thresholds))))